<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin_details' => 'Admin Details',
    'admins' => 'Admins',
    'admin' => 'Admin',
    'roles' => 'Roles',
    'doctor_departments' => 'Doctor Departments',
    'nurses' => 'Nurses',
    'doctors' => 'Doctors',
    'patients' => 'Patients',
    'lab_technicians' => 'Lab Technicians',
    'receptionists' => 'Receptionists',
    'pharmacists' => 'Pharmacists',
    'accountants' => 'Accountants',
    'appointments' => 'Appointments',
    'insurances' => 'Insurances',
    'investigation_reports' => 'Investigation Reports',
    'death_reports' => 'Death Reports',
    'birth_reports' => 'Birth Reports',
    'operation_reports' => 'Operation Reports',
    'medicine_categories' => 'Medicine Categories',
    'medicine_brands' => 'Medicine Brands',
    'medicines' => 'Medicines',
    'cases' => 'Cases',
    'case_handlers' => 'Case Handlers',
    'bed_types' => 'Bed Types',
    'beds' => 'Beds',
    'bed_assigns' => 'Bed Assigns',
    'packages' => 'Packages',
    'schedules' => 'Schedules',
    'schedule_label' => 'Schedule',
    'services' => 'Services',
    'accounts' => 'Accounts',
    'payments' => 'Payments',
    'bills' => 'Bills',
    'employee_payrolls' => 'Employee Payrolls',
    'documents' => 'Documents',
    'document_types' => 'Document Types',
    'notice_boards' => 'Notice Boards',
    'settings' => 'Settings',
    'doctors_list' => 'Doctors List',
    'my_payrolls' => 'Payrolls',
    'blood_banks' => 'Blood Banks',
    'blood_donors' => 'Blood Donors',
    'invoices' => 'Invoices',
    'patients_cases' => 'Patients Cases',
    'patients_case_details' => 'Patients Case Details',
    'account_manager' => 'Account Manager',
    'bed_management' => 'Bed Management',
    'blood_bank' => 'Blood Bank',
    'billing' => 'Billing',
    'case_manager' => 'Case Manager',
    'cms' => 'CMS',
    'front_cms_services' => 'Front CMS Services',
    'department' => 'Department',
    'departments' => 'Departments',
    'hospital_activities' => 'Hospital Activities',
    'advanced_payments' => 'Advance Payments',
    'patient_admissions' => 'Patient Admissions',
    'appointment_calendar' => 'Appoint. Calendar',
    'bed_mgt' => 'Bed Management',
    'reports' => 'Reports',
    'enquiries' => 'Enquiries',
    'mail' => 'Mail',
    'ambulances' => 'Ambulances',
    'ambulance_calls' => 'Ambulance Calls',
    'prescriptions' => 'Prescriptions',
    'hospital_charges' => 'Hospital Charges',
    'charge_categories' => 'Charge Categories',
    'charges' => 'Charges',
    'radiologies' => 'Radiology',
    'radiology_categories' => 'Radiology Category',
    'pathologies' => 'Pathology',
    'pathology_categories' => 'Pathology Category',
    'radiology_tests' => 'Radiology Tests',
    'doctor_opd_charges' => 'Doctor OPD Charges',
    'pathology_tests' => 'Pathology Tests',
    'expenses' => 'Expenses',
    'income' => 'Income',
    'finance' => 'Finance',
    'issued_items' => 'Issued Items',
    'ipd_patients' => 'IPD Patients',
    'ipd_opd' => 'IPD/OPD',
    'ipd_diagnosis' => 'Diagnosis',
    'ipd_consultant_register' => 'Consultant Instruction',
    'ipd_charges' => 'Charges',
    'ipd_prescription' => 'Prescriptions',
    'ipd_timelines' => 'Timelines',
    'opd_patients' => 'OPD Patients',
    'call_logs' => 'Call Logs',
    'visitors' => 'Visitors',
    'front_office' => 'Front Office',
    'postal_receive' => 'Postal Receive',
    'postal_dispatch' => 'Postal Dispatch',
    'inventory' => 'Inventory',
    'items_categories' => 'Items Categories',
    'items' => 'Items',
    'items_stocks' => 'Item Stocks',
    'general' => 'General',
    'sidebar_setting' => 'Sidebar Setting',
    'testimonials' => 'Testimonials',
    'blood_donations' => 'Blood Donations',
    'blood_issues' => 'Blood Issues',
    'live_consultations' => 'Live Consultations',
    'live_meetings' => 'Live Meetings',
    'vaccinations' => 'Vaccinations',
    'vaccinated_patients' => 'Vaccinated Patients',
    'users' => 'Users',
    'posts' => 'Posts',
    'front_settings' => 'Front Settings',
    'about_us' => 'About Us',
    'make_an_appointment' => 'Make An Appointment',
    'patient_appointment' => 'Patient Appointment',
    'old_patient' => 'Old Patient',
    'new_patient' => 'New Patient',
    'available_slot' => 'Available Slot',
    'available_slots' => 'Available Slots',
    'contact_us' => 'Contact Us',
    'short_description' => 'Short Description',
    'icon' => 'Icon',
    'front_cms' => 'Front CMS',
    'facebook_url' => 'Facebook URL',
    'twitter_url' => 'Twitter URL',
    'instagram_url' => 'Instagram URL',
    'linkedIn_url' => 'LinkedIn URL',
    'hospital_schedule' => 'Hospital Schedule',
    'impersonate' => 'Impersonate',
    'subscription_plan' => 'Subscription Plan',
    'subscription_days_plan_not_found' => 'We couldn\'t find any days subscription plans',
    'subscription_month_plan_not_found' => 'We couldn\'t find any month subscription plans',
    'subscription_year_plan_not_found' => 'We couldn\'t find any year subscription plans',
    'subscription_plan_not_found' => 'Subscription Plan Not Found',
    'month' => 'Month',
    'year' => 'Year',
    'day' => 'Day',
    'file_name' => 'File Name',
    'view_all' => 'View All',
    'hospitals' => 'Hospitals',
    'hospitals_type' => 'Hospital Type',
    'hospital' => 'Hospital',
    'hospital_details' => 'Hospital Details',
    'overview' => 'Overview',
    'billings' => 'Billings',
    'billing_detail' => 'Billing Detail',
    'our_hospitals' => 'Our Hospitals',
    'hospital_schedules' => 'Hospital Schedules',
    'plan_expire_notifications' => 'Plan Expire Notification (in Days)',
    'valid' => 'Valid',
    'paytm' => 'Paytm',
    'appointment_charge' => 'Appointment Charge',
    'manual_billing_payments' => 'Manual Billing Payments',
    'faq' => 'FAQ',
    'paid' => 'Paid',
    'unpaid' => 'Unpaid',
    'hospital_type' => 'Hospital Type',
    'minutes' => 'Minutes',
    'hours' => 'Hours',


    'language' => [
        'Arabic' => 'Arabic',
        'Chinese' => 'Chinese',
        'English' => 'English',
        'French' => 'French',
        'German' => 'German',
        'Portuguese' => 'Portuguese',
        'Russian' => 'Russian',
        'Spanish' => 'Spanish',
        'Turkish' => 'Spanish',
    ],

    'admin_user' => [
        'new_admin' => 'New Admin',
        'admin_saved_successfully' => 'Admin saved successfully',
        'admin_updated_successfully' => 'Admin updated successfully',
        'admin_deleted_successfully' => 'Admin deleted successfully',
    ],

    //roles
    'role' => [
        'new_role' => 'New Role',
        'edit_role' => 'Edit Role',
        'admin' => 'Admin',
        'doctor' => 'Doctor',
        'patient' => 'Patient',
        'nurse' => 'Nurse',
        'receptionist' => 'Receptionist',
        'pharmacist' => 'Pharmacist',
        'accountant' => 'Accountant',
        'case_manager' => 'Case Manager',
        'lab_technician' => 'Lab Technician',
    ],

    //filters
    'filter' => [
        'all' => 'All',
        'active' => 'Active',
        'deactive' => 'Deactive',
        'inactive' => 'Inactive',
    ],

    //user keys
    'user' => [
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'username' => 'Username',
        'name' => 'Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'designation' => 'Designation',
        'gender' => 'Gender',
        'male' => 'Male',
        'female' => 'Female',
        'qualification' => 'Qualification',
        'dob' => 'Date Of Birth',
        'blood_group' => 'Blood Group',
        'select_blood_group' => 'Select Blood Group',
        'select_donor_name' => 'Select Donor Name',
        'select_patient_name' => 'Select Patient Name',
        'password' => 'Password',
        'password_confirmation' => 'Confirm Password',
        'address1' => 'Address 1',
        'address2' => 'Address 2',
        'city' => 'City',
        'zip' => 'Zip',
        'address_details' => 'Address Details',
        'address_not_found' => 'No Address details found',
        'education' => 'Education',
        'status' => 'Status',
        'edit_profile' => 'Edit Profile',
        'change_password' => 'Change Password',
        'logout' => 'Logout',
        'new_user' => 'New User',
        'edit_user' => 'Edit User',
        'user_details' => 'User Details',
        'email_verified' => 'Email Verified',
        'email_not_verified' => 'Email Not Verified',
        'back_to_admin' => 'Back To Super Admin',
        'hospital_slug' => 'Hospital Slug',
        'enter_hospital_name' => 'Enter Hospital Name',
        'enter_hospital_slug' => 'Enter Hospital Slug',
        'enter_email' => 'Enter Email',
    ],

    //posts keys
    'post' => [
        'name' => 'Name',
        'description' => 'Description',
        'new_post' => 'New Post',
        'edit_post' => 'Edit Post',
        'post_details' => 'Post Details',
        'image' => 'Image',
        'status' => 'Status',
    ],

    //common keys
    'common' => [
        'default_country_code' => 'Default Country Code',
        'profile' => 'Profile',
        'post_image' => 'Post Image',
        'status' => 'Status',
        'action' => 'Action',
        'save' => 'Save',
        'cancel' => 'Cancel',
        'canceled' => 'Canceled',
        'confirm' => 'Confirm',
        'back' => 'Back',
        'created_on' => 'Created On',
        'updated_on' => 'Updated On',
        'last_updated' => 'Last Updated',
        'n/a' => 'N/A',
        'new' => 'New',
        'total' => 'Total',
        'add' => 'Add',
        'active' => 'Active',
        'deactive' => 'Deactive',
        'name' => 'Name',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'view' => 'View',
        'view_attachment' => 'View Attachment',
        'de_active' => 'Deactive',
        'description' => 'Description',
        'created_at' => 'Created On',
        'updated_at' => 'Last Updated',
        'is_available' => 'Is Available',
        'choose' => 'Choose',
        'yes' => 'Yes',
        'no' => 'No',
        'address' => 'Address',
        'export_to_excel' => 'Export to Excel',
        'reset' => 'Reset',
        'actions' => 'Actions',
        'filter_options' => 'Filter Options',
        'select_status' => 'Select Status',
        'showing' => 'Showing',
        'of' => 'of',
        'results' => 'Results',
        'show' => 'Show',
        'previous' => 'Previous',
        'next' => 'Next',
        'default_plan' => 'Default Plan',
        'select_type' => 'Select Type',
        'select_type_number' => 'Select Type Number',
        'filter' => 'Filter',
        'user_details' => 'User',
        'no_data_available' => 'No data available in table',
        'allow_img_text' => 'Allowed file types: png, jpg, jpeg, svg.',
        'search' => 'Search',
        'no_matching_records_found' => 'No matching records found',
        'custom' => 'Custom',
        'apply' => 'Apply',
        'from' => 'From',
        'to' => 'To',
        'invalid_number' => 'Invalid number',
        'invalid_country_code' => 'Invalid country code',
        'too_short' => 'Too short',
        'too_long' => 'Too long',
        'undefined' => 'undefined',
        'not_found' => 'not found',
        'no data available in table' => 'No data available in table',
        'status_updated_successfully' => 'Status updated successfully.',
        'saved_successfully' => 'saved successfully',
        'updated_successfully' => 'updated successfully',
        'deleted_successfully' => 'deleted successfully',
        'are_you_sure_want_to_delete_this' => 'Are you sure want to delete this ',
        'deleted' => 'Deleted',
        'has_been_deleted' => 'has been deleted.',
        'cant_be_deleted' => 'can\'t be deleted',
        'ok' => 'Ok',
        'this_action_is_not_allowed_for_default_record' => 'This action is not allowed for default record.',
        'please_enter_valid_facebook_url' => 'Please enter a valid facebook URL',
        'please_enter_valid_twitter_url' => 'Please enter a valid Twitter URL',
        'please_enter_valid_linkedin_url' => 'Please enter a valid LinkedIn URL',
        'please_enter_valid_Instagram_url' => 'Please enter a valid Instagram URL',
        'select_payment' => 'Select Payment Status',
        'logged_in_successfully' => 'Logged in successfully.',
        'logout_successfully' => 'Logout successfully.',
        'we_have_your_password_resetk_link' => 'We have e-mailed your password reset link!',
        'we_cant_find_user' => 'We can\'t find user with this email address',
        'this_password_reset_token_is_invalid' => 'This password reset token is invalid',
        'password_reset_successfully' => 'Password reset successfully',
        'please_enter_correct_old_password' => 'please enter correct old password',
        'password_updated' => 'Your password has been successfully updated.',
        'doctor_scheduled' => 'Doctor Scheduled',
        'patient_registered_successfully' => 'Patient registered successfully',
        'appointment_confirmed_successfully' => 'Appointment confirmed successfully',
        'bed_assigned_successfully' => 'Bed Assigned Successfully',
        'username_and_password_required' => 'Username and password required',
        'meeting_finished_or_cancelled' => 'This meeting is finished or cancelled',
        'something_want_wrong' => 'Something went wrong',
        'cancelled_successfully' => 'cancelled successfully',
        'not_updated' => 'Not updated',
        'invalid_username_password' => 'Invalid username or password',
        'appointment_transaction' => 'Appointment Transaction',
        'no_data_found' => 'No Data Found',
        'is_already_exists' => 'is already exists.',
        'close' => 'Close',
    ],

    'months' => [
        'jan' => 'January',
        'feb' => 'February',
        'mar' => 'March',
        'apr' => 'April',
        'may' => 'May',
        'jun' => 'June',
        'jul' => 'July',
        'aug' => 'August',
        'sep' => 'September',
        'oct' => 'October',
        'nov' => 'November',
        'dec' => 'December',
    ],

    'weekdays' => [
        'sun' => 'SUN',
        'mon' => 'MON',
        'tue' => 'TUE',
        'wed' => 'WED',
        'thu' => 'THU',
        'fri' => 'FRI',
        'sat' => 'SAT',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'Receptionist',
        'receptionists' => 'Receptionists',
        'receptionist_details' => 'Receptionist Details',
        'new_receptionist' => 'New Receptionist',
        'edit_receptionist' => 'Edit Receptionist',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'Insurance',
        'insurances' => 'Insurances',
        'insurance_details' => 'Insurance Details',
        'new_insurance' => 'New Insurance',
        'edit_insurance' => 'Edit Insurance',
        'service_tax' => 'Service Tax',
        'insurance_no' => 'Insurance No',
        'insurance_code' => 'Insurance Code',
        'hospital_rate' => 'Hospital Rate',
        'discount' => 'Discount',
        'remark' => 'Remark',
        'disease_details' => 'Disease Details',
        'diseases_name' => 'Diseases Name',
        'diseases_charge' => 'Diseases charge',
        'total_amount' => 'Total Amount',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'Doctor Departments',
        'doctor_department' => 'Doctor Department',
        'doctor_department_details' => 'Doctor Department Details',
        'new_doctor_department' => 'New Doctor Department',
        'edit_doctor_department' => 'Edit Doctor Department',
        'title' => 'Title',
        'description' => 'Description',
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'Investigation Reports',
        'investigation_report' => 'Investigation Report',
        'investigation_report_details' => 'Investigation Report Details',
        'new_investigation_report' => 'New Investigation Report',
        'edit_investigation_report' => 'Edit Investigation Report',
        'patient' => 'Patient',
        'date' => 'Date',
        'title' => 'Title',
        'doctor' => 'Doctor',
        'description' => 'Description',
        'attachment' => 'Attachment',
        'solved' => 'Solved',
        'not_solved' => 'Not Solved',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'New Pharmacist',
        'edit_pharmacist' => 'Edit Pharmacist',
        'pharmacists' => 'Pharmacists',
        'pharmacist_details' => 'Pharmacist Details',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'Death Report',
        'death_reports' => 'Death Reports',
        'new_death_report' => 'New Death Report',
        'edit_death_report' => 'Edit Death Report',
        'death_report_details' => 'Death Report Details',
        'patient_name' => 'Patient Name',
        'case_id' => 'Case ID',
        'doctor_name' => 'Doctor Name',
        'date' => 'Date',
        'description' => 'Description',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'Birth Report',
        'birth_reports' => 'Birth Reports',
        'birth_report_details' => 'Birth Report Details',
        'new_birth_report' => 'New Birth Report',
        'edit_birth_report' => 'Edit Birth Report',
        'patient_name' => 'Patient Name',
        'case_id' => 'Case ID',
        'doctor_name' => 'Doctor Name',
        'date' => 'Date',
        'description' => 'Description',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'New Accountant',
        'edit_accountant' => 'Edit Accountant',
        'accountants' => 'Accountants',
        'accountant_details' => 'Accountant Details',
        'credit' => 'Credit',
        'debit' => 'Debit',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'Employee Payroll',
        'employee_payrolls' => 'Employee Payrolls',
        'employee_payroll_details' => 'Employee Payroll Details',
        'new_employee_payroll' => 'New Employee Payroll',
        'edit_employee_payroll' => 'Edit Employee Payroll',
        'sr_no' => 'Sr No',
        'payroll_id' => 'Payroll ID',
        'month' => 'Month',
        'year' => 'Year',
        'role' => 'Role',
        'employee' => 'Employee',
        'basic_salary' => 'Basic Salary',
        'allowance' => 'Allowance',
        'deductions' => 'Deductions',
        'net_salary' => 'Net Salary',
        'paid' => 'Paid',
        'not_paid' => 'Not Paid',
        'unpaid' => 'Unpaid',
        'employee_name' => 'Employee Name',
        'select_employee' => 'Select Employee',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'Operation Report',
        'operation_reports' => 'Operation Reports',
        'operation_report_details' => 'Operation Report Details',
        'new_operation_report' => 'New Operation Report',
        'edit_operation_report' => 'Edit Operation Report',
        'patient_name' => 'Patient Name',
        'case_id' => 'Case ID',
        'doctor_name' => 'Doctor Name',
        'date' => 'Date',
        'description' => 'Description',
    ],

    // accounts keys
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'account_details' => 'Account Details',
        'new_account' => 'New Account',
        'edit_account' => 'Edit Account',
        'name' => 'Name',
        'description' => 'Description',
        'type' => 'Type',
        'status' => 'Status',
        'payments' => 'Payments',
    ],

    // invoices keys
    'invoice' => [
        'send_mail' => 'Send Mail',
        'invoice_id' => 'Invoice ID',
        'invoice' => 'Invoice',
        'invoices' => 'Invoices',
        'invoice_details' => 'Invoice Details',
        'new_invoice' => 'New Invoice',
        'edit_invoice' => 'Edit Invoice',
        'patient' => 'Patient',
        'invoice_date' => 'Invoice Date',
        'amount' => 'Amount',
        'patient_id' => 'Patient ID',
        'discount' => 'Discount',
        'account_name' => 'Account Name',
        'description' => 'Description',
        'qty' => 'Qty',
        'price' => 'Price',
        'add' => 'Add',
        'sub_total' => 'Sub Total',
        'total' => 'Total Amount',
        'edit' => 'Edit',
        'hospital_address' => 'Hospital Address',
        'paid' => 'Paid',
        'not_paid' => 'Not Paid',
        'print_invoice' => 'Print Invoice',
    ],

    //nurses
    'nurse' => [
        'new_nurse' => 'New Nurse',
        'edit_nurse' => 'Edit Nurse',
        'nurse_details' => 'Nurse Details',
        'phone_no' => 'Phone No',
        'birth_date' => 'Birth Date',
        'choose' => 'Choose',
    ],

    //patient
    'patient' => [
        'new_patient' => 'New Patient',
        'edit_patient' => 'Edit Patient',
        'patient_details' => 'Patient Details',
        'total_cases' => 'Total Cases',
        'total_admissions' => 'Total Admissions',
        'total_appointments' => 'Total Appointments',
    ],

    // payments keys
    'payment' => [
        'payment' => 'Payment',
        'payments' => 'Payments',
        'payment_details' => 'Payment Details',
        'new_payment' => 'New Payment',
        'edit_payment' => 'Edit Payment',
        'account_name' => 'Account Name',
        'payment_date' => 'Payment Date',
        'pay_to' => 'Pay To',
        'amount' => 'Amount',
        'account' => 'Account',
        'description' => 'Description',
        'payment_reports' => 'Payment Reports',
        'your_payment_is_successfully_completed' => 'Your Payment is successfully completed',
        'payment_failed' => 'Sorry! Payment is failed, Try again after some time',
    ],

    //    transaction filter
    'transaction_filter' => [
        'manual' => 'Manual',
        'razorpay' => 'Razorpay',
        'paypal' => 'Paypal',
        'stripe' => 'Stripe',
        'paystack' => 'Paystack',
        'paytm' => 'Paytm',
        'cash' => 'Cash',
        'cheque' => 'Cheque',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'Advance Payment',
        'advanced_payments' => 'Advance Payments',
        'advanced_payment_details' => 'Advance Payment Details',
        'new_advanced_payment' => 'New Advance Payment',
        'edit_advanced_payment' => 'Edit Advance Payment',
        'patient' => 'Patient',
        'receipt_no' => 'Receipt No',
        'amount' => 'Amount',
        'date' => 'Date',
        'patient_name' => 'Patient Name',
    ],

    // beds keys
    'bed' => [
        'bed' => 'New Bed',
        'beds' => 'Beds',
        'bed_details' => 'Bed Details',
        'new_bed' => 'New Bed',
        'edit_bed' => 'Edit Bed',
        'new_bulk_bed' => 'New Bulk Bed',
        'name' => 'Name',
        'bed_type' => 'Bed Type',
        'charge' => 'Charge',
        'available' => 'Available',
        'not_available' => 'Not Available',
        'description' => 'Description',
        'add' => 'Add',
        'bed_id' => 'Bed ID',
        'select_bed_type' => 'Select Bed Type',
        'select_bed' => 'Select Bed',
        'choose_bed' => 'Choose Bed',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'Bed Type',
        'bed_types' => 'Bed Types',
        'bed_type_details' => 'Bed Type Details',
        'new_bed_type' => 'New Bed Type',
        'edit_bed_type' => 'Edit Bed Type',
        'title' => 'Title',
        'description' => 'Description',
    ],

    'doctor' => [
        'new_doctor' => 'New Doctor',
        'edit_doctor' => 'Edit Doctor',
        'doctor_details' => 'Doctor Details',
        'specialist' => 'Specialist',
        'name' => 'Name',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'Bed Assign',
        'bed_assigns' => 'Bed Assigns',
        'bed_assign_details' => 'Bed Assign Details',
        'new_bed_assign' => 'New Bed Assign',
        'edit_bed_assign' => 'Edit Bed Assign',
        'patient_name' => 'Patient Name',
        'bed_name' => 'Bed Name',
        'case_id' => 'Case ID',
        'assign_date' => 'Assign Date',
        'discharge_date' => 'Discharge Date',
        'bed' => 'Bed',
        'description' => 'Description',
        'assigned' => 'Assigned',
        'not_assigned' => 'Not Assigned',
        'ipd_patient_id' => 'IPD Patient ID',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'Bed Assign date should not be smaller than patient birth date.',
    ],

    // packages keys
    'package' => [
        'package' => 'Package',
        'packages' => 'Packages',
        'package_details' => 'Package Details',
        'new_package' => 'New Package',
        'edit_package' => 'Edit Package',
        'name' => 'Name',
        'description' => 'Description',
        'discount' => 'Discount',
        'total_amount' => 'Total Amount',
        'service' => 'Service',
        'qty' => 'Qty',
        'rate' => 'Rate',
        'amount' => 'Amount',
        'select_service' => 'Select Service',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'Print Bill',
        'bill_id' => 'Bill ID',
        'bill' => 'Bill',
        'bills' => 'Bills',
        'bill_details' => 'Bill Details',
        'new_bill' => 'New Bill',
        'edit_bill' => 'Edit Bill',
        'patient' => 'Patient',
        'bill_date' => 'Bill Date',
        'amount' => 'Amount',
        'admission_id' => 'Admission ID',
        'patient_name' => 'Patient Name',
        'patient_email' => 'Patient Email',
        'patient_cell_no' => 'Patient Cell No',
        'patient_gender' => 'Patient Gender',
        'patient_dob' => 'Patient DOB',
        'doctor_name' => 'Doctor Name',
        'admission_date' => 'Admission Date',
        'discharge_date' => 'Discharge Date',
        'package_name' => 'Package Name',
        'insurance_name' => 'Insurance Name',
        'total_days' => 'Total Days',
        'policy_no' => 'Policy No',
        'item_name' => 'Item Name',
        'qty' => 'Qty',
        'price' => 'Price',
        'add' => 'Add',
        'total_amount' => 'Total Amount',
        'edit' => 'Edit',
        'cell_no' => 'Cell No',
        'bill_summary' => 'Bill Summary',
        'generate_bill' => 'Generate Bill',
        'update_bill' => 'Update Bill',
        'calculate' => 'Calculate',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'Blood Donor',
        'blood_donors' => 'Blood Donors',
        'blood_donor_details' => 'Blood Donor Details',
        'new_blood_donor' => 'New Blood Donor',
        'edit_blood_donor' => 'Edit Blood Donor',
        'name' => 'Name',
        'age' => 'Age',
        'gender' => 'Gender',
        'blood_group' => 'Blood Group',
        'donation_date' => 'Donation Date',
        'last_donation_date' => 'Last Donation Date',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'Blood Bank',
        'blood_banks' => 'Blood Banks',
        'blood_bank_details' => 'Blood Bank Details',
        'new_blood_group' => 'New Blood Group',
        'edit_blood_group' => 'Edit Blood Group',
        'blood_group' => 'Blood Group',
        'remained_bags' => 'Remained Bags',
    ],

    //Case
    'case' => [
        'case' => 'Case',
        'select_case' => 'Select Case',
        'case_date' => 'Case Date',
        'new_case' => 'New Case',
        'edit_case' => 'Edit Case',
        'case_details' => 'Case Details',
        'phone' => 'Phone',
        'fee' => 'Fee',
        'patient' => 'Patient',
        'doctor' => 'Doctor',
        'case_id' => 'Case ID',
        'date' => 'Date',
        'description' => 'Description',
    ],

    //services
    'service' => [
        'new_service' => 'New Service',
        'edit_service' => 'Edit Service',
        'service_details' => 'Service Details',
        'quantity' => 'Quantity',
        'rate' => 'Rate',
        'given' => 'Given',
        'not_given' => 'Not Given',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'New Appointment',
        'edit_appointment' => 'Edit Appointment',
        'appointment_details' => 'Appointment Details',
        'calendar_view' => 'Calendar View',
        'patient_name' => 'Patient Name',
        'doctor_name' => 'Doctor Name',
        'department_name' => 'Department Name',
        'date' => 'Date',
        'doctor_department' => 'Doctor Department',
        'doctor_department_name' => 'Doctor Department Name',
        'doctor' => 'Doctor',
        'description' => 'Description',
        'patient' => 'Patient',
        'appointment_calendar' => 'Appointment Calendar',
        'appointment_list' => 'Appointment List',
        'completed' => 'Completed',
        'pending' => 'Pending',
        'available_slot' => 'Available Slot',
        'no_available' => 'Not Available',
        'today' => 'Today',
        'month' => 'Month',
        'week' => 'Week',
        'day' => 'Day',
        'opd_date' => 'Opd Date',
        'yesterday' => 'Yesterday',
        'this_week' => 'This Week',
        'last_7_days' => 'Last 7 days',
        'last_30_days' => 'Last 30 days',
        'this_month' => 'This month',
        'last_month' => 'Last month',
        'custom' => 'Custom',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'change_status' => 'Change status',
        'are_you_sure_want_to_change' => 'Are you sure want to change ',
        'changed_appointment' => 'Changed Appointment',
        'has_been_changed' => 'has been Changed.',
        'are_you_sure_want_to_cancel' => 'Are you sure want to cancel',
        'has_been_cancelled' => 'has been Cancelled.',
        'please_select_doctor' => 'Please select Doctor',
        'doctor_schedule_not_available_on_this_date' => 'Doctor Schedule not available this date.',
        'patient_not_exists_or_status_is_not_active' => 'Patient not exists or status is not active.',
        'please_select_appointment_time_slot' => 'Please select appointment time slot',
        'time' => 'Time',
    ],

    'case_handler' => [
        'new_case_handler' => 'New Case Handler',
        'edit_case_handler' => 'Edit Case Handler',
        'case_handler_detail' => 'Case Handler Details',
    ],

    'lab_tech' => [
        'new_lab_tech' => 'New Lab Technician',
        'edit_lab_tech' => 'Edit Lab Technician',
        'lab_tech_detail' => 'Lab Technician Details',
    ],

    'doc_type' => [
        'new_doc_type' => 'New Document Type',
        'edit_doc_type' => 'Edit Document Type',
        'name' => 'Name',
    ],

    'document' => [
        'document' => 'Document',
        'documents' => 'Documents',
        'new_document' => 'New Document',
        'edit_document' => 'Edit Document',
        'title' => 'Title',
        'document_type' => 'Document Type',
        'document_type_details' => 'Document Type Details',
        'patient' => 'Patient',
        'download' => 'Download',
        'select_patient' => 'Select Patient',
        'select_account' => 'Select Account',
        'select_admission_id' => 'Select Admission ID',
        'in_percentage' => 'In percentage',
        'select_document_type' => 'Select Document Type',
        'uploaded_by' => 'Uploaded By',
        'document_detail' => 'Document Details',
        'notes' => 'Notes',
        'view' => 'View',
        'attachment' => 'Attachment',
        'change_attachment' => 'Change Attachment',
        'document_file_size' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx., mp3, mp4',
    ],

    'patient_admission' => [
        'patient_admission' => 'Patient Admission',
        'new_patient_admission' => 'New Patient Admission',
        'edit_patient_admission' => 'Edit Patient Admission',
        'details' => 'Patient Admission Details',
        'patient' => 'Patient',
        'patient_name' => 'Patient Name',
        'doctor' => 'Doctor',
        'doctor_name' => 'Doctor Name',
        'admission_date' => 'Admission Date',
        'discharge_date' => 'Discharge Date',
        'package' => 'Package',
        'package_name' => 'Package Name',
        'insurance' => 'Insurance',
        'insurance_name' => 'Insurance Name',
        'policy_no' => 'Policy No',
        'bed' => 'Bed',
        'agent_name' => 'Agent Name',
        'guardian_name' => 'Guardian Name',
        'guardian_relation' => 'Guardian Relation',
        'guardian_contact' => 'Guardian Contact',
        'guardian_address' => 'Guardian Address',
        'patient_admission_id' => 'Patient Admission ID',
        'select_package' => 'Select Package',
        'select_insurance' => 'Select Insurance',
    ],

    'setting' => [
        'paystack' => 'PayStack',
        'paystack_public_key' => 'Paystack Public Key',
        'paystack_secret_key' => 'Paystack Secret Key',
        'paytm' => 'Paytm',
        'paytm_merchant_id' => 'Paytm Merchant ID',
        'paytm_merchant_key' => 'Paytm Merchant Key',
        'app_name' => 'App Name',
        'company_name' => 'Company Name',
        'app_logo' => 'App Logo',
        'change_logo' => 'Change Logo',
        'currency' => 'Current Currency',
        'address' => 'Hospital Address',
        'hospital_email' => 'Hospital Email',
        'hospital_phone' => 'Hospital Phone',
        'hospital_from_day' => 'Hospital From Day',
        'hospital_from_time' => 'Hospital From Time',
        'about_us' => 'About Us',
        'image_validation' => 'The image must be of pixel 90 x 60.',
        'favicon' => 'Favicon',
        'change_favicon' => 'Change Favicon',
        'favicon_validation' => 'The image must be of pixel 34 x 34.',
        'social_details' => 'Social Details',
        'enable_google_reCAPTCHA' => 'Enable Google reCAPTCHA',
        'credential' => 'Credential',
        'clinic_name' => 'Clinic Name',
        'credentials' => 'Credentials',
        'stripe' => 'Stripe',
        'stripe_key' => 'Stripe key',
        'stripe_secret' => 'Stripe Secret',
        'paypal_secret' => 'Paypal Secret',
        'paypal_client_id' => 'Paypal Client ID',
        'paypal_mode' => 'Paypal Mode',
        'paypal' => 'Paypal',
        'paypal_key' => 'Paypal key',
        'razorpay_key' => 'Razorpay Key',
        'razorpay_secret' => 'Razorpay Secret',
        'razorpay' => 'Razorpay',
        'payment_gateway' => 'Payment Gateway',
    ],

    'currency' => [
        'currencies' => 'Currencies',
        'new_currency' => 'New Currency',
        'edit_currency' => 'Edit Currency',
        'currency_name' => 'Currency Name',
        'currency_code' => 'Currency Code',
        'currency_icon' => 'Currency Icon',
        'add_currency_code_as_per_three_letter_iso_code' => 'Add currency code as per three-letter ISO code',
        'you_can_find_out_here' => 'you can find out here',

    ],

    'schedule' => [
        'new' => 'New Schedule',
        'edit' => 'Edit Schedule',
        'details' => 'Schedule Details',
        'doctor_name' => 'Doctor Name',
        'select_doctor_name' => 'Select Doctor Name',
        'per_patient_time' => 'Per Patient Time',
        'serial_visibility' => 'Serial Visibility',
        'select_serial_visibility' => 'Select Serial Visibility',
        'available_on' => 'Available On',
        'available_from' => 'Available From',
        'available_to' => 'Available To',
        'sequential' => 'Sequential',
        'timestamp' => 'Timestamp',
    ],

    'notice_board' => [
        'new' => 'New Notice Board',
        'edit' => 'Edit Notice Board',
        'details' => 'Notice Board Details',
        'title' => 'Title',
        'description' => 'Description',
        'created_at' => 'Created At',
    ],

    'my_payroll' => [
        'my_payrolls' => 'My Payrolls',
        'basic_salary' => 'Basic Salary',
        'allowance' => 'Allowance',
        'deductions' => 'Deductions',
        'net_salary' => 'Net Salary',
    ],

    'medicine' => [
        'medicine' => 'Medicine',
        'medicine_category' => 'Medicine Category',
        'medicine_category_details' => 'Medicine Category Details',
        'medicines' => 'Medicines',
        'medicine_details' => 'Medicine Details',
        'new_medicine' => 'New Medicine',
        'new_medicine_category' => 'New Medicine Category',
        'edit_medicine_category' => 'Edit Medicine Category',
        'edit_medicine' => 'Edit Medicine',
        'name' => 'Name',
        'brand' => 'Brand',
        'selling_price' => 'Selling Price',
        'buying_price' => 'Buying Price',
        'category' => 'Category',
        'salt_composition' => 'Salt Composition',
        'side_effects' => 'Side Effects',
        'description' => 'Description',
        'category_id' => 'Category ID',
        'brand_name' => 'Brand Name',
        'medicine_brands' => 'Medicine Brands',
        'medicine_brands_details' => 'Medicine Brand Details',
        'new_brand' => 'New Brand',
        'new_medicine_brand' => 'New Medicine Brand',
        'edit_medicine_brand' => 'Edit Medicine Brand',
        'select_category' => 'Select Category',
        'select_brand' => 'Select Brand',
        'is_active' => 'Is active',
    ],

    'profile' => [
        'change_language' => 'Change Language',
        'change_Profile' => 'Change Profile',
        'change_post_image' => 'Change Post Image',
        'language' => 'Language',
        'edit_profile' => 'Edit Profile',
        'full_name' => 'Full Name',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'profile' => 'Profile',
        'type' => 'Type',
    ],

    'dashboard' => [
        'dashboard' => 'Dashboard',
        'total_invoices' => 'Invoice Amount',
        'total_bills' => 'Billed Amount',
        'total_payments' => 'Payment Amount',
        'total_advance_payments' => 'Advance Payment Amount',
        'notice_boards' => 'Notice Boards',
        'title' => 'Title',
        'doctors' => 'Doctors',
        'available_beds' => 'Available Beds',
        'patients' => 'Patients',
        'income_and_expense_report' => 'Income and Expense Report',
        'income_and_expense_reports' => 'Income and Expense Reports',
        'no_enquiries_yet' => 'No Enquiries yet...',
        'no_notice_yet' => 'No Notice Boards yet..',
        'total_hospitals' => 'Total Hospitals',
        'total_subscription_plans' => 'Total Subscription Plans',
        'total_subscribers' => 'Total Subscribers',
        'total_enquiries' => 'Total Enquiries',
        'total_revenue' => 'Total Revenue',
        'total_active_hospital_plan' => 'Total Active Hospital Plans',
        'total_expired_hospital_plan' => 'Total Expired Hospital Plans',
        'income_report' => 'Income Overview',
        'please_select_rang_picker' => 'Please Select Rang Picker',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'Name',
        'email' => 'Email',
        'contact' => 'Contact',
        'type' => 'Type',
        'message' => 'Message',
        'viewed_by' => 'Viewed By',
        'enquiry_details' => 'Enquiry Details',
        'read' => 'Read',
        'unread' => 'Unread',
        'not_viewed' => 'Not Viewed',
        'received_on' => 'Received On',
        'send_enquiry' => 'Send Enquiry',
        'general_enquiry' => 'General Enquiry',
        'residential_care' => 'Residential Care',
        'feedback/suggestions' => 'Feedback / Suggestions',

    ],

    'email' => [
        'to' => 'To',
        'subject' => 'Subject',
        'message' => 'Message',
        'attachment' => 'Attachment',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'Ambulance',
        'ambulances' => 'Ambulances',
        'ambulance_details' => 'Ambulance Details',
        'vehicle_number' => 'Vehicle Number',
        'vehicle_model' => 'Vehicle Model',
        'year_made' => 'Year Made',
        'driver_name' => 'Driver Name',
        'driver_license' => 'Driver License',
        'driver_contact' => 'Driver Contact',
        'note' => 'Note',
        'vehicle_type' => 'Vehicle Type',
        'is_available' => 'Is Available',
        'new_ambulance' => 'New Ambulance',
        'edit_ambulance' => 'Edit Ambulance',
        'select_ambulance' => 'Select Ambulance',
        'owned' => 'Owned',
        'contractual' => 'Contractual',

    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'Ambulance Call',
        'ambulance_calls' => 'Ambulance Calls',
        'ambulance_call_details' => 'Ambulance Call Details',
        'vehicle_model' => 'Vehicle Model',
        'patient' => 'Patient',
        'driver_name' => 'Driver Name',
        'date' => 'Date',
        'amount' => 'Amount',
        'new_ambulance_call' => 'New Ambulance Call',
        'edit_ambulance_call' => 'Edit Ambulance Call',
        'select_ambulance' => 'Select Ambulance',
    ],

    // prescription keys
    'prescription' => [
        'prescription' => 'Prescription',
        'prescriptions' => 'Prescriptions',
        'prescription_details' => 'Prescription Details',
        'new_prescription' => 'New Prescription',
        'edit_prescription' => 'Edit Prescription',
        'patient' => 'Patient',
        'doctor' => 'Doctor',
        'food_allergies' => 'Food Allergies',
        'tendency_bleed' => 'Tendency Bleed',
        'heart_disease' => 'Heart Disease',
        'high_blood_pressure' => 'High Blood Pressure',
        'diabetic' => 'Diabetic',
        'surgery' => 'Surgery',
        'accident' => 'Accident',
        'others' => 'Others',
        'medical_history' => 'Medical History',
        'current_medication' => 'Current Medication',
        'female_pregnancy' => 'Female Pregnancy',
        'breast_feeding' => 'Breast Feeding',
        'health_insurance' => 'Health Insurance',
        'low_income' => 'Low Income',
        'reference' => 'Reference',
        'physical_information' => 'Physical Information',
        'new_medicine' => 'New Medicine',
        'plus_rate' => 'Pulse Rate',
        'temperature' => 'Temperature',
        'problem_description' => 'Problem Description',
        'test' => 'Test',
        'advice' => 'Advice',
        'next_visit' => 'Next Visit',
        'time' => 'Time',
        'comment' => 'Comment',
        'problem' => 'Problem',
        'rx' => 'Rx',
        'medicine_name' => 'Medicine Name',
        'duration' => 'Duration',
        'days' => 'Days',
        'after_meal' => 'After Meal',
        'before_meal' => 'Before Meal',
        'fill_physical_information' => 'Fill any details of physical information',
        'data_retrive_from_openai' => 'Data Retrive Successfully from OpenAI',
    ],

    'charge_category' => [
        'charge_categories' => 'Charge Categories',
        'new_charge_category' => 'New Charge Category',
        'edit_charge_category' => 'Edit Charge Category',
        'charge_type' => 'Charge Type',
        'charge_category_details' => 'Charge Category Details',
        'select_charge_type' => 'Select Category Type',
    ],

    //    charge filter
    'charge_filter' => [
        'investigation' => 'Investigation',
        'procedure' => 'Procedure',
        'supplier' => 'Supplier',
        'operation_theater' => 'Operation Theater',
        'others' => 'Others',
    ],

    'charge' => [
        'new_charge' => 'New Charge',
        'edit_charge' => 'Edit Charge',
        'charge_details' => 'Charge Details',
        'charge_category' => 'Charge Category',
        'standard_charge' => 'Standard Charge',
        'code' => 'Code',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'Name',
        'radiology_categories' => 'Radiology Categories',
        'new_radiology_category' => 'New Radiology Category',
        'edit_radiology_category' => 'Edit Radiology Category',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'Pathology Categories',
        'select_charge_category' => 'Select Charge Category',
        'new_pathology_category' => 'New Pathology Category',
        'edit_pathology_category' => 'Edit Pathology Category',
        'name' => 'Name',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'Radiology Tests',
        'new_radiology_test' => 'New Radiology Test',
        'edit_radiology_test' => 'Edit Radiology Test',
        'radiology_test_details' => 'Radiology Test Details',
        'test_name' => 'Test Name',
        'short_name' => 'Short Name',
        'test_type' => 'Test Type',
        'category_name' => 'Category Name',
        'subcategory' => 'Sub Category',
        'report_days' => 'Report Days',
        'charge_category' => 'Charge Category',
        'standard_charge' => 'Standard Charge',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'new_doctor_opd_charge' => 'New Doctor OPD Charge',
        'edit_doctor_opd_charge' => 'Edit Doctor OPD Charge',
        'doctor_name' => 'Doctor Name',
        'standard_charge' => 'Doctor OPD Charge',
        'doctor' => 'Doctor',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'Pathology Tests',
        'new_pathology_test' => 'New Pathology Test',
        'edit_pathology_test' => 'Edit Pathology Test',
        'pathology_test_details' => 'Pathology Test Details',
        'test_name' => 'Test Name',
        'short_name' => 'Short Name',
        'test_type' => 'Test Type',
        'category_name' => 'Category Name',
        'unit' => 'Unit',
        'subcategory' => 'Sub Category',
        'method' => 'Method',
        'report_days' => 'Report Days',
        'charge_category' => 'Charge Category',
        'standard_charge' => 'Standard Charge',
    ],

    //    expense filter
    'expense_filter' => [
        'building_rent' => 'Building Rent',
        'equipments' => 'Equipments',
        'electricity_bill' => 'Electricity Bill',
        'telephone_bill' => 'Telephone Bill',
        'power_generator_fuel_charge' => 'Power Generator Fuel Charge',
        'tea_expense' => 'Tea Expense',
    ],

    //expenses keys
    'expense' => [
        'new_expense' => 'New Expense',
        'edit_expense' => 'Edit Expense',
        'expense_head' => 'Expense Head',
        'name' => 'Name',
        'date' => 'Date',
        'invoice_number' => 'Invoice Number',
        'amount' => 'Amount',
        'attachment' => 'Attachment',
        'description' => 'Description',
        'choose' => 'Choose',
        'download' => 'Download',
        'select_expense_head' => 'Select Expense Head',
        'expense_details' => 'Expense Details',
        'document_error' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //    income filter
    'income_filter' => [
        'canteen_rate' => 'Canteen Rent',
        'hospital_charges' => 'Hospital Charges',
        'special_campaign' => 'Special Campaign',
        'vehicle_stand_charge' => 'Vehicle Stand Charge',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'Incomes',
        'new_income' => 'New Income',
        'edit_income' => 'Edit Income',
        'income_head' => 'Income Head',
        'name' => 'Name',
        'date' => 'Date',
        'invoice_number' => 'Invoice Number',
        'amount' => 'Amount',
        'attachment' => 'Attachment',
        'description' => 'Description',
        'choose' => 'Choose',
        'download' => 'Download',
        'select_income_head' => 'Select Income Head',
        'income_details' => 'Income Details',
        'document_error' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Bed Status',
        'assigned_beds' => 'Assigned Beds',
        'available_beds' => 'Available Beds',
        'bed_name' => 'Bed Name',
        'patient_name' => 'Patient Name',
        'phone' => 'Phone',
        'admission_date' => 'Admission Date',
        'gender' => 'Gender',
    ],

    //Messages keys
    'message' => [
        'message' => 'Message',
        'messages' => 'Messages',
        'send_to' => 'Send To',
        'subject' => 'Subject',
        'new_message' => 'New Message',
        'messages_details' => 'Message Details',
        'sender_name' => 'Sender Name',
        'date' => 'Date',
        'select_user' => 'Select User',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'SMS',
        'new_sms' => 'New SMS',
        'send_to' => 'Send To',
        'phone_number' => 'Phone Number',
        'send_by' => 'Send By',
        'message' => 'Message',
        'sms_details' => 'SMS Details',
        'date' => 'Date',
        'send' => 'Send',
        'role' => 'Role',
        'select_role' => 'Select Role',
        'send_sms_by_number_directly' => 'Send SMS by number directly',
        'only_user_with_registered_phone_will_display' => '(Only Users with a registered phone will display.)',
        'sms_mail' => 'SMS/Mail',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'Diagnosis',
        'diagnosis_test' => 'Diagnosis Tests',
        'patient_diagnosis_test' => 'Patient Diagnosis Tests',
        'report_number' => 'Report number',
        'patient' => 'Patient',
        'doctor' => 'Doctor',
        'created_at' => 'Created at',
        'action' => 'Action',
        'new_patient_diagnosis_test' => 'New Patient Diagnosis Test',
        'edit_patient_diagnosis_test' => 'Edit Patient Diagnosis Test',
        'create_patient_diagnosis_test' => 'Create Patient Diagnosis Test',
        'patient_diagnosis_test_details' => 'Patient Diagnosis Test Details',
        'diagnosis_category' => 'Diagnosis Category',
        'add_other_diagnosis_property' => 'Add other diagnosis property',
        'other_diagnosis_property' => 'Other diagnosis property',
        'diagnosis_property_name' => 'Diagnosis Property Name',
        'diagnosis_property_value' => 'Diagnosis Property Value',
        'patient_name' => 'Patient name',
        'doctor_name' => 'Doctor name',
        'age' => 'Age',
        'height' => 'Height',
        'weight' => 'Weight',
        'average_glucose' => 'Average glucose',
        'fasting_blood_sugar' => 'Fasting Blood Sugar',
        'urine_sugar' => 'Urine Sugar',
        'blood_pressure' => 'Blood Pressure',
        'diabetes' => 'Diabetes',
        'cholesterol' => 'Cholesterol',
        'print_diagnosis_test' => 'Print Diagnosis Test',
        'select_diagnosis_cat' => 'Select Diagnosis Category',
        'patient_unique' => 'The patient\'s name has already been taken.',
        'report_generated' => 'Report Generated',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'Diagnosis Category',
        'diagnosis_category_details' => 'Diagnosis Category Details',
        'diagnosis_categories' => 'Diagnosis Categories',
        'new_diagnosis_category' => 'New Diagnosis Category',
        'description' => 'Description',
        'category_name' => 'Category name',
        'diagnosis_category_details' => 'Diagnosis Category Details',
        'edit_diagnosis_category' => 'Edit Diagnosis Category',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'Item Category',
        'item_categories' => 'Item Categories',
        'new_item_category' => 'New Item Category',
        'edit_item_category' => 'Edit Item Category',
        'name' => 'Name',
    ],

    'item' => [
        'item' => 'Item',
        'items' => 'Items',
        'new_item' => 'New Item',
        'edit_item' => 'Edit Item',
        'item_details' => 'Item Details',
        'name' => 'Name',
        'item_category' => 'Item Category',
        'unit' => 'Unit',
        'description' => 'Description',
        'available_quantity' => 'Available Quantity',
        'select_item_category' => 'Select Item Category',
    ],

    'item_stock' => [
        'item_stock' => 'Item Stock',
        'item_stocks' => 'Item Stocks',
        'new_item_stock' => 'New Item Stock',
        'edit_item_stock' => 'Edit Item Stock',
        'item_stock_details' => 'Item Stock Details',
        'item_category' => 'Item Category',
        'item' => 'Item Name',
        'supplier_name' => 'Supplier Name',
        'store_name' => 'Store Name',
        'quantity' => 'Quantity',
        'purchase_price' => 'Purchase Price',
        'description' => 'Description',
        'attachment' => 'Attachment',
    ],

    'issued_item' => [
        'issued_item' => 'Issued Item',
        'issued_items' => 'Issued Items',
        'new_issued_item' => 'New Issued Item',
        'edit_issued_item' => 'Edit Issued Item',
        'issued_item_details' => 'Issued Items Details',
        'department_id' => 'User Type',
        'user_id' => 'Issue To',
        'issued_by' => 'Issue By',
        'issued_for' => 'Issue For',
        'issued_date' => 'Issue Date',
        'return_date' => 'Return Date',
        'item_category' => 'Item Category',
        'item' => 'Item',
        'quantity' => 'Quantity',
        'description' => 'Description',
        'available_quantity' => 'Available Quantity',
        'item_return' => 'Return Item',
        'item_returned' => 'Returned',
        'select_user_type' => 'Select User Type',
        'qty_cannot_be_zero' => 'Quantity cannot be zero.',
        'qty_must_be_less_than_available_qty' => 'Quantity must be less than Available quantity.',
        'are_you_sure_want_to_return_this_item' => 'Are you sure want to return this item',
    ],

    'ipd_patient' => [
        'ipd_patient' => 'IPD Patient',
        'ipd_patients' => 'IPD Patients',
        'new_ipd_patient' => 'New IPD Patient',
        'edit_ipd_patient' => 'Edit IPD Patient',
        'ipd_patient_details' => 'IPD Patient Details',
        'patient_id' => 'Patient',
        'ipd_number' => 'IPD No',
        'height' => 'Height',
        'weight' => 'Weight',
        'bp' => 'Blood Pressure',
        'symptoms' => 'Symptoms',
        'notes' => 'Notes',
        'admission_date' => 'Admission Date',
        'case_id' => 'Case',
        'is_old_patient' => 'Is Old Patient',
        'doctor_id' => 'Doctor',
        'bed_type_id' => 'Bed Type',
        'bed_id' => 'Bed',
        'bill_status' => 'Bill Status',
        'choose_case' => 'Choose Case',
        'discharged' => 'Discharged',
        'discharge_patient' => 'Discharge patient',
        'please_select_applied_date' => 'Please select Applied date',
        'please_select_instruction_date' => 'Please select Instruction date',
        'please_enter_instruction' => 'Please enter Instruction',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'Add Diagnosis',
        'edit_ipd_diagnosis' => 'Edit Diagnosis',
        'report_type' => 'Report Type',
        'report_date' => 'Report Date',
        'document' => 'Document',
        'description' => 'Description',
    ],

    'ipd_patient_consultant_register' => [
        'new_consultant_register' => 'Add Consultant Instruction',
        'edit_consultant_register' => 'Edit Consultant Instruction',
        'applied_date' => 'Applied Date',
        'doctor_id' => 'Doctor',
        'instruction' => 'Instruction',
        'instruction_date' => 'Instruction Date',
    ],

    'ipd_patient_charges' => [
        'new_charge' => 'Add Charges',
        'edit_charge' => 'Edit Charges',
        'date' => 'Date',
        'charge_type_id' => 'Charge Type',
        'charge_category_id' => 'Charge Category',
        'charge_id' => 'Code',
        'standard_charge' => 'Standard Charge',
        'applied_charge' => 'Applied Charge',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD No',
        'header_note' => 'Header Note',
        'footer_note' => 'Footer Note',
        'new_prescription' => 'Add Prescription',
        'edit_prescription' => 'Edit Prescription',
        'prescription_details' => 'Prescription Details',
        'category_id' => 'Medicine Category',
        'medicine_id' => 'Medicine',
        'dosage' => 'Dosage',
        'instruction' => 'Instruction',
        'print_prescription' => 'Print Prescription',
    ],

    'ipd_patient_timeline' => [
        'new_ipd_timeline' => 'Add Timeline',
        'edit_ipd_timeline' => 'Edit Timeline',
        'title' => 'Title',
        'date' => 'Date',
        'description' => 'Description',
        'document' => 'Document',
        'visible_to_person' => 'Visible To Person',
        'no_timeline_found' => 'No TimeLine Found',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'Add IPD Payment',
        'edit_ipd_payment' => 'Edit IPD Payment',
        'select_payment_mode' => 'Select Payment Mode',
        'payment_mode' => 'Payment Mode',
        'make_payment' => 'Make Payment',
    ],

    'ipd_bill' => [
        'paid_amount' => 'Paid Amount',
        'total_charges' => 'Total Charges',
        'gross_total' => 'Gross Total',
        'discount_in_percentage' => 'Discount In Percentage',
        'discount_in_number' => 'Discount In Number',
        'tax_in_percentage' => 'Tax In Percentage',
        'tax_in_number' => 'Tax In Number',
        'other_charges' => 'Other Charges',
        'net_payable_amount' => 'Net Payable Amount',
        'discharge_patient' => 'Discharge Patient',
    ],

    'opd_patient' => [
        'opd_patient' => 'OPD Patient',
        'opd_patients' => 'OPD Patients',
        'new_opd_patient' => 'New OPD Patient',
        'edit_opd_patient' => 'Edit OPD Patient',
        'opd_patient_details' => 'OPD Patient Details',
        'opd_number' => 'OPD No',
        'appointment_date' => 'Appointment Date',
        'visits' => 'Visits',
        'revisits' => 'Revisit',
        'total_visits' => 'Total Visits',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'Add Opd Payment',
        'edit_opd_payment' => 'Edit Opd Payment',
        'payment_mode' => 'Payment Mode',
        'make_payment' => 'Make Payment',
        'choose_payment' => 'Choose Payment',
    ],

    'call_log' => [
        'new' => 'New Call Log',
        'edit' => 'Edit Call Log',
        'name' => 'Name',
        'phone' => 'Phone',
        'received_on' => 'Received On',
        'follow_up_date' => 'Follow-Up Date',
        'note' => 'Note',
        'call_type' => 'Call Type',
        'incoming' => 'Incoming',
        'outgoing' => 'Outgoing',
    ],

    //    visitor filter
    'visitor_filter' => [
        'visit' => 'Visit',
        'enquiry' => 'Enquiry',
        'seminar' => 'Seminar',
    ],

    'visitor' => [
        'new' => 'New Visitor',
        'edit' => 'Edit Visitor',
        'name' => 'Name',
        'purpose' => 'Purpose',
        'phone' => 'Phone',
        'id_card' => 'ID Card',
        'number_of_person' => 'Number Of Person',
        'date' => 'Date',
        'in_time' => 'In Time',
        'out_time' => 'Out Time',
        'note' => 'Note',
        'select_purpose' => 'Select purpose'
    ],

    'postal' => [
        'new_receive' => 'New Receive',
        'new_dispatch' => 'New Dispatch',
        'dispatch' => 'Dispatch',
        'receive' => 'Receive',
        'edit_receive' => 'Edit Receive',
        'edit_dispatch' => 'Edit Dispatch',
        'to_title' => 'To Title',
        'from_title' => 'From Title',
        'reference_no' => 'Reference Number',
        'date' => 'Date',
        'address' => 'Address',
    ],

    'testimonial' => [
        'new_testimonial' => 'New Testimonial',
        'edit_testimonial' => 'Edit Testimonial',
        'name' => 'Name',
        'description' => 'Description',
        'profile_error' => 'The document must be a file of type: jpeg, jpg, png.',
        'position' => 'Position',
        'show_testimonial' => 'Show Testimonial',
    ],

    'blood_donation' => [
        'new_blood_donation' => 'New Blood Donation',
        'edit_blood_donation' => 'Edit Blood Donation',
        'donor_name' => 'Donor Name',
        'bags' => 'Bags',
    ],

    'blood_issue' => [
        'new_blood_issue' => 'New Blood Issue',
        'edit_blood_issue' => 'Edit Blood Issue',
        'issue_date' => 'Issue Date',
        'patient_name' => 'Patient Name',
        'doctor_name' => 'Doctor Name',
        'donor_name' => 'Donor Name',
        'amount' => 'Amount',
        'remarks' => 'Remarks',
    ],

    'notification' => [
        'notifications' => 'Notifications',
        'mark_all_as_read' => 'Mark All As Read',
        'you_don`t_have_any_new_notification' => 'You don\'t have any new notification',
    ],

    //    live_consultation_filter
    'live_consultation_filter' => [
        'awaited' => 'Awaited',
        'cancelled' => 'Cancelled',
        'finished' => 'Finished',
    ],

    'live_consultation' => [
        'new_live_consultation' => 'New Live Consultation',
        'consultation_title' => 'Consultation Title',
        'consultation_date' => 'Consultation Date',
        'consultation_duration_minutes' => 'Consultation Duration Minutes',
        'client_video' => 'Client Video',
        'host_video' => 'Host Video',
        'enable' => 'Enable',
        'disabled' => 'Disabled',
        'type' => 'Type',
        'type_number' => 'Type Number',
        'created_by' => 'Created By',
        'created_for' => 'Created For',
        'new_live_meeting' => 'New Live Meeting',
        'staff_list' => 'Staff List',
        'edit_live_consultation' => 'Edit Live Consultation',
        'duration' => 'Duration (in minutes)',
        'start_now' => 'Start Now',
        'join_now' => 'Join Now',
        'edit_live_meeting' => 'Edit Live Meeting',
        'add_credential' => 'Add Credential',
        'zoom_api_key' => 'Zoom Api Key',
        'zoom_api_secret' => 'Zoom API Secret',
        'how_to_generate_Oauth_credentials' => 'How to generate OAuth credentials',
        'select_platform' => 'Select platform'
    ],

    'vaccination' => [
        'vaccinations' => 'Vaccinations',
        'new_vaccination' => 'New Vaccination',
        'edit_vaccination' => 'Edit Vaccination',
        'select_vaccination' => 'Select Vaccination',
        'name' => 'Name',
        'manufactured_by' => 'Manufactured By',
        'brand' => 'Brand',
        'vaccinated' => 'Vaccinated',
    ],

    'vaccinated_patient' => [
        'patient' => 'Patient',
        'vaccination' => 'Vaccination',
        'vaccination_name' => 'Vaccination Name',
        'serial_no' => 'Serial No',
        'does_no' => 'Dose No',
        'dose_given_date' => 'Dose Given Date',
        'description' => 'Description',
        'add_vaccinate_patient' => 'Add Vaccinated Patient',
        'new_vaccinate_patient' => 'New Vaccinated Patient',
        'edit_vaccinate_patient' => 'Edit Vaccinated Patient',
        'vaccine' => 'Vaccine',
        'vaccinate_patient' => 'Vaccinate Patient',
    ],

    'front_setting' => [
        'front_setting_details' => 'Front Setting Details',
        'about_us_details' => 'About Us Details',
        'appointment_details' => 'Appointment Details',
        'terms_condition_details' => 'T&C Details',
        'about_us_title' => 'Title',
        'about_us_mission' => 'Mission',
        'about_us_image' => 'Image',
        'about_us_description' => 'Description',
        'home_page_image' => 'Home Page Image',
        'home_page_title' => 'Home Page Title',
        'home_page_description' => 'Home Page Description',
        'home_page_box_title' => 'Home Page Box Title',
        'home_page_box_description' => 'Home Page Box Description',
        'home_page_experience' => 'Home Page Experience',
        'home_page_step_1_title' => 'Home Page Step 1 Title',
        'home_page_step_1_description' => 'Home Page Step 1 Description',
        'home_page_step_2_title' => 'Home Page Step 2 Title',
        'home_page_step_2_description' => 'Home Page Step 2 Description',
        'home_page_step_3_title' => 'Home Page Step 3 Title',
        'home_page_step_3_description' => 'Home Page Step 3 Description',
        'home_page_step_4_title' => 'Home Page Step 4 Title',
        'home_page_step_4_description' => 'Home Page Step 4 Description',
        'terms_conditions' => 'Terms & Conditions',
        'privacy_policy' => 'Privacy Policy',
        'home_page_certified_doctor_image' => 'Home Page Certified Doctor Image',
        'home_page_certified_doctor_text' => 'Home Page Certified Doctor Text',
        'home_page_certified_doctor_title' => 'Home Page Certified Doctor Title',
        'home_page_certified_doctor_description' => 'Home Page Certified Doctor Description',
        'home_page_certified_box_title' => 'Home Page Certified Box Title',
        'home_page_certified_box_description' => 'Home Page Certified Box Description',
    ],

    'change_password' => [
        'change_password' => 'Change Password',
        'current_password' => 'Current Password',
        'new_password' => 'New Password',
        'confirm_password' => 'Confirm Password',
        'enter_your_current_password' => 'Enter your current password',
        'enter_a_new_password' => 'Enter a new password',
        'confirm_your_new_password' => 'Confirm your new password',
    ],

    'front_services' => [
        'new_service' => 'New Service',
        'edit_service' => 'Edit Service',
    ],

    'web_home' => [
        'home' => 'Home',
        'services' => 'Services',
        'doctors' => 'Doctors',
        'about_us' => 'About Us',
        'contact' => 'Contact',
        'make_appointment' => 'Make Appointment',
        'working_hours' => 'Working Hours',
        'testimonials' => 'Testimonials',
        'terms_of_service' => 'Terms of Service',
        'privacy_policy' => 'Privacy Policy',
        'patients' => 'Patients',
        'years_experience' => 'Years Experience',
        'sign_up' => 'Sign Up',
        'available_doctors' => 'Available Doctors',
        'select_doctors' => 'Select Doctors',
        'contact_doctors' => 'Contact Doctor',
        'contact_hospital' => 'Contact Hospital',
        'easy_solutions' => 'Easy Solutions',
        '4_easy_step_and_get_the_world_best_treatment' => '4 Easy Step and Get the World Best Treatment',
        'book_an_appointment' => 'Book an Appointment',
        'select_doctor' => 'Select Doctor',
        'book_now' => 'Book Now',
        'patients_beds' => 'Patients Beds',
        'doctors_nurses' => 'Doctors & Nurses',
        'happy_patients' => 'Happy Patients',
        'book_appointment' => 'Book Appointment',
        'our_services' => 'Our Services',
        'we_offer_different_services_to_improve_your_health' => 'We Offer Different Services To Improve Your Health',
        'professional_doctors' => 'Professional Doctors',
        'we_are_experienced_healthcare_professionals' => 'We are Experienced Healthcare Professionals',
        'our_testimonials' => 'Our Testimonials',
        'what_our_patient_say_about_medical_treatments' => 'What Our Patients Say About Our Medical Treatments',
    ],

    'web_contact' => [
        'call_today' => 'Call Today',
        'open_hours' => 'Open Hours',
        'our_location' => 'Our Location',
        'send_us_a_message' => 'Send Us a Message',
        'your_name' => 'Your Name',
        'your_email' => 'Your Email',
        'phone_number' => 'Phone Number',
        'select_enquiry' => 'Select Enquiry',
        'your_message' => 'Your Message',
        'send_message' => 'Send Message',
        'enter_your_name' => 'Enter your name',
        'enter_your_email' => 'Enter your email',
        'contact_no' => 'Contact No',
        'please_enter_your_phone_number' => 'Please enter your phone number',
        'enter_your_phone_number' => 'Enter your phone number',
        'write_your_message' => 'Write your message',
        'type_your_message' => 'Type your message',
        'get_in_touch' => 'Get in touch and let us know how we can help. Fill out the form and we’ll be in touch as soon as possible.',
    ],

    'web_menu' => [
        'about' => 'About',
        'our_features' => 'Our Features',
        'appointment' => 'Appointment',
        'working_hours' => 'Working Hours',
        'login' => 'Login',
        'useful_link' => 'Useful Link',
        'contact_information' => 'Contact Information',
        'copyright' => 'Copyright',
        'all_rights_reserved_by' => 'All Rights Reserved by',
        'all_rights_reserved' => 'All Rights Reserved',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'Make an Appointment',
        'call_now_and_get_a_free_consulting' => 'Call Now and Get a Free Consulting',
        'enter_your_first_name' => 'Enter your First Name',
        'enter_your_last_name' => 'Enter your Last Name',
        'enter_your_password' => 'Enter your Password',
        'enter_confirm_password' => 'Enter Confirm Password',
        'select_department' => 'Select Department',
        'select_doctor' => 'Select Doctor',
        'enter_description' => 'Enter Description',
        'select_time' => 'Select Time',
        'select_date' => 'Select Date',
    ],

    'web_working_hours' => [
        'opening_hours' => 'Opening Hours',
        'no_yet_opening_hours' => 'No yet Opening Hours',
    ],

    // subscription plan
    'subscription_plans' => [
        'select_plan_type' => 'Select Plan Type',
        'add_subscription_plan' => 'Add Subscription Plan',
        'name' => 'Name',
        'currency' => 'Currency',
        'price' => 'Price',
        'valid_until' => 'Trial Days',
        'edit_subscription_plan' => 'Edit Subscription Plan',
        'plan_type' => 'Frequency',
        'active_plan' => 'Active Plans',
        'valid_until_tooltip' => 'If you are entering 1 & plan type is year it will be considered as 1 year same for month.',
        'trail_plan' => 'Trial Days',
        'trail_plan_text' => ' trial days will be available for this plan.',
        'payment_type' => 'Choose Payment Type',
        'transactions' => 'Transactions',
        'transaction_details' => 'Transaction Detail',
        'plan_name' => 'Plan Name',
        'transaction_date' => 'Transaction Date',
        'payment_method' => 'Payment Method',
        'amount' => 'Amount',
        'free_plan' => 'Free Plan',
        'plan_features' => 'Plan Features',
        'select_all' => 'Select All',
        'default_plan_text_one' => 'This menu contains',
        'default_plan_text_two' => 'sub menus.',
        'view_subscription_plan' => 'Subscription Plan Details',
        'start_date' => 'Start Date',
        'end_date' => 'Expires On',
        'make_default' => 'Make Default',
        'default_plan' => 'Default Plan',
        'subscription_plans' => 'Subscription Plans',
        'remaining_balance' => 'Remaining Balance',
        'amount_to_pay' => 'Amount to Pay',
        'used_days' => 'Used Days',
        'total_extra_days' => 'Total Extra Days',
        'pay_or_switch_plan' => 'Pay / Switch Plan',
        'transaction' => 'Transaction',
        'frequency' => 'Frequency',
        'trail_end_date' => 'Trial End Date',
        'payment' => 'Payment',
        'enter_plan_name' => 'Enter Plan Name',
        'select_currency' => 'Select Currency',
        'enter_price' => 'Enter Price',
        'enter_trial_day' => 'Enter Trial Days',
    ],

    // subscription pricing plan keys
    'subscription_pricing_plans' => [
        'subscription_pricing_plan' => 'Subscription Pricing Plan',
        'choose_plan' => 'Choose Plan',
        'week' => 'Week',
        'month' => 'Month',
        'year' => 'Year',
        'has_been_subscribed' => 'has been subscribed',
        'has_already_been_subscribed' => 'is already subscribed',
        'currently_active' => 'Currently Active',
        'renew_plan' => 'Renew Plan',
        'no_pricing_plan_found' => 'We couldn\'t find any Subscription Plan\'s',
        'renew_free_plan' => 'Free Plan cannot be renewed/chosen again',
        'proceed_to_payment' => 'Proceed to Payment',
        'switch_plan' => 'Switch Plan',
    ],

    // Landing Cms
    'landing_cms' => [
        'landing_cms' => 'Landing CMS',
        'section_one' => 'Section One',
        'text_main' => 'Text Main',
        'text_secondary' => 'Text Secondary',
        'image' => 'Image',
        'section_two' => 'Section Two',
        'card_one_image' => 'Card One Image',
        'card_one_text' => 'Card One Text',
        'card_one_text_secondary' => 'Card One Text Secondary',
        'card_two_image' => 'Card Two Image',
        'card_two_text' => 'Card Two Text',
        'card_two_text_secondary' => 'Card Two Text Secondary',
        'card_third_image' => 'Card Third Image',
        'card_third_text' => 'Card Third Text',
        'card_third_text_secondary' => 'Card Third Text Secondary',
        'section_three' => 'Section Three',
        'text_one' => 'Text One',
        'text_two' => 'Text Two',
        'text_three' => 'Text Three',
        'text_four' => 'Text Four',
        'text_five' => 'Text Five',
        'section_four' => 'Section Four',
        'card_three_image' => 'Card Three Image',
        'card_three_text' => 'Card Three Text',
        'card_three_text_secondary' => 'Card Three Text Secondary',
        'card_four_image' => 'Card Four Image',
        'card_four_text' => 'Card Four Text',
        'card_four_text_secondary' => 'Card Four Text Secondary',
        'card_five_image' => 'Card Five Image',
        'card_five_text' => 'Card Five Text',
        'card_five_text_secondary' => 'Card Five Text Secondary',
        'card_six_image' => 'Card Six Image',
        'card_six_text' => 'Card Six Text',
        'card_six_text_secondary' => 'Card Six Text Secondary',
        'section_five' => 'Section Five',
        'main_image' => 'Main Image',
        'card_one_number' => 'Card One Number',
        'card_two_number' => 'Card Two Number',
        'card_three_number' => 'Card Three Number',
        'card_four_number' => 'Card Four Number',
        'about_us' => 'About Us',
        'main_img_one' => 'Main Image One',
        'main_img_two' => 'Main Image Two',
    ],

    'subscribe' => [
        'subscribers' => 'Subscribers',
    ],

    'footer_setting' => [
        'footer_settings' => 'Footer Settings',
        'footer_text' => 'Footer Text',
        'address' => 'Address',
    ],

    'landing' => [
        'subscribe_our_newsletter' => 'Subscribe Our Newsletter',
        'subscribe' => 'Subscribe',
        'usefull_link' => 'Useful links',
        'faqs' => 'FAQs',
        'about' => 'About',
        'home' => 'Home',
        'pricing' => 'Pricing',
        'get_in_touch' => 'Get In Touch',
        'all_rights_reserved' => 'All Right Reserved',
        'call' => 'Call',
        'choose_your_pricing_plan' => 'Choose Your Pricing Plan',
        'enquiry' => 'Enquiry',
    ],

    'faqs' => [
        'faqs' => 'FAQs',
        'add_faqs' => 'Add FAQs',
        'edit_faqs' => 'Edit FAQs',
        'question' => 'Question',
        'answer' => 'Answer',
        'show' => 'Show FAQs',
    ],

    'service_slider' => [
        'service_slider_image' => 'Service Slider Image',
        'add_service_slider' => 'Add Service Slider Image',
        'edit_service_slider' => 'Edit Service Slider Image',
        'img_tooltip_text' => 'Best resolution for this image will be 140x50',
    ],

    'hospitals_list' => [
        'hospital_name' => 'Hospital Name',
        'hospital_username' => 'Hospital Username',
        'add_new_hospital' => 'Add New Hospital',
        'edit_hospital' => 'Edit Hospital',
        'new_hospital' => 'New Hospital',
    ],

    'subscription' => [
        'month' => 'Month',
        'year' => 'Year',
        'subscription' => 'Subscription',
        'subscriptions' => 'Subscriptions',
        'subscription_details' => 'Subscription Details',
        'edit_subscription' => 'Edit Subscription',
        'payment_approved' => 'Payment Approved',
        'approved' => 'Approved',
        'denied' => 'Denied',
        'select_manual_payment' => 'Select Manual Payment',
        'waiting_for_approval' => 'Waiting for Approval',
        'cash_payment_done' => 'Your payment is done and your subscription will be activated once the admin approve your transaction.',
    ],

    'delete' => [
        'accountant' => 'Accountant',
        'account' => 'Account',
        'advanced_payment' => 'Advanced Payment',
        'ambulance_call' => 'Ambulance Call',
        'ambulance' => 'Ambulance',
        'appointment' => 'Appointment',
        'bed_assign' => 'Bed Assign',
        'bed_type' => 'Bed Type',
        'bed' => 'Bed',
        'bill' => 'Bill',
        'birth_report' => 'Birth Report',
        'blood_group' => 'Blood Group',
        'blood_donation' => 'Blood Donation',
        'blood_donor' => 'Blood Donor',
        'blood_issue' => 'Blood Issue',
        'medicine_brand' => 'Medicine Brand',
        'call_log' => 'Call Log',
        'case_handler' => 'Case Handler',
        'medicine_category' => 'Medicine Category',
        'charge_category' => 'Charge Category',
        'charge' => 'Charge',
        'department' => 'Department',
        'diagnosis_category' => 'Diagnosis Category',
        'doctor_opd_charge' => 'Doctor Opd Charge',
        'doctor_department' => 'Doctor Department',
        'document' => 'Document',
        'document_type' => 'Document Type',
        'employee_payroll' => 'Employee Payroll',
        'expense' => 'Expense',
        'faq' => 'FAQ',
        'income' => 'Income',
        'insurance' => 'Insurance',
        'investigation_report' => 'Investigation Report',
        'invoice' => 'Invoice',
        'ipd_charge' => 'IPD Charge',
        'ipd_consultant_instruction' => 'IPD Consultant Instruction',
        'ipd_diagnosis' => 'IPD Diagnosis',
        'ipd_patient' => 'IPD Patient',
        'ipd_payment' => 'IPD Payment',
        'ipd_prescription' => 'IPD Prescription',
        'issued_item' => 'Issued Item',
        'item_category' => 'Item Category',
        'item_stock' => 'Item Stock',
        'item' => 'Item',
        'lab_technician' => 'Lab Technician',
        'live_consultation' => 'Live Consultation',
        'live_meeting' => 'Live Meeting',
        'medicine' => 'Medicine',
        'notice_board' => 'Notice Board',
        'nurse' => 'Nurse',
        'opd_diagnosis' => 'OPD Diagnosis',
        'opd_patient' => 'OPD Patient',
        'opd_patient_visit' => 'OPD Patient Visit',
        'operation_report' => 'Operation Report',
        'package' => 'Package',
        'pathology_category' => 'Pathology Category',
        'pathology_test' => 'Pathology Test',
        'patient_admission' => 'Patient Admission',
        'case' => 'Case',
        'patient_diagnosis_test' => 'Patient diagnosis test',
        'patient' => 'Patient',
        'payment' => 'Payment',
        'pharmacist' => 'Pharmacist',
        'prescription' => 'Prescription',
        'radiology_category' => 'Radiology Category',
        'radiology_test' => 'Radiology Test',
        'receptionist' => 'Receptionist',
        'schedule' => 'Schedule',
        'service_slider' => 'Service Slider',
        'service' => 'Service',
        'sms' => 'SMS',
        'subscriber' => 'Subscriber',
        'subscription_plan' => 'Subscription Plan',
        'hospital' => 'Hospital',
        'enquiry' => 'Enquiry',
        'user' => 'User',
        'vaccinated_patient' => 'Vaccinated Patient',
        'vaccination' => 'Vaccination',
        'visitor' => 'Visitor',
        'testimonial' => 'Testimonial',
        'opd_timelines' => 'OPD Timeline',
    ],

    'flash' => [
        'not_allow_access_record' => 'Seems, you are not allowed to access this record.',
        'accountant_not_found' => 'Accountant not found',
        'admin_not_found' => 'Admin not found',
        'advance_payment_not_found' => 'Advance Payment not found',
        'ambulance_call_not_found' => 'Ambulance Call not found',
        'ambulance_not_found' => 'Ambulance not found',
        'bed_assign_not_found' => 'Bed Assign not found',
        'bed_not_found' => 'Bed not found',
        'birth_report_not_found' => 'Birth Report not found',
        'blood_bank_not_found' => 'Blood bank not found',
        'blood_donation_not_found' => 'Blood donation not found',
        'blood_donor_not_found' => 'Blood Donor not found',
        'blood_issue_not_found' => 'Blood issue not found',
        'brand_not_found' => 'Brand not found',
        'call_log_not_found' => 'Call log not found',
        'case_handler_not_found' => 'Case Handler not found',
        'charge_not_found' => 'Charge not found',
        'currency_not_found' => 'Currency not found',
        'death_report_not_found' => 'Death Report not found',
        'department_not_found' => 'Department not found',
        'doctor_opd_charge_not_found' => 'Doctor Opd Charge not found',
        'document_not_found' => 'Document not found',
        'employee_payroll_not_found' => 'Employee Payroll not found',
        'expense_not_found' => 'Expense not found',
        'front_service_not_found' => 'Front Service not found',
        'hospital_not_found' => 'Hospital not found',
        'income_not_found' => 'Income not found',
        'insurance_not_found' => 'Insurance not found',
        'invoice_not_found' => 'Invoice not found',
        'ipd_charge_not_found' => 'IPD Charge not found',
        'ipd_consultant_register_not_found' => 'IPD Consultant Register not found',
        'ipd_diagnosis_not_found' => 'IPD Diagnosis not found',
        'ipd_patient_not_found' => 'IPD Patient not found',
        'ipd_payment_not_found' => 'IPD Payment not found',
        'ipd_prescription_not_found' => 'IPD Prescription not found',
        'ipd_timeline_not_found' => 'IPD Timeline not found',
        'issued_item_not_found' => 'Issued Item not found',
        'item_category_not_found' => 'Item Category not found',
        'item_stock_not_found' => 'Item Stock not found',
        'lab_technician_not_found' => 'Lab Technician not found',
        'live_consultation_not_found' => 'Live Consultation not found',
        'live_meeting_not_found' => 'Live Meeting not found',
        'medicine_not_found' => 'Medicine not found',
        'notice_board_not_found' => 'Notice Board not found',
        'nurse_not_found' => 'Nurse not found',
        'opd_diagnosis_not_found' => 'Opd Diagnosis not found',
        'opd_patient_not_found' => 'Opd Patient not found',
        'opd_timeline_not_found' => 'Opd Timeline not found',
        'operation_report_not_found' => 'Operation Report not found',
        'package_not_found' => 'Package not found',
        'pathology_category_not_found' => 'Pathology Category not found',
        'pathology_test_not_found' => 'Pathology Test not found',
        'patient_admission_not_found' => 'Patient Admission not found',
        'patient_case_not_found' => 'Patient Case not found',
        'patient_not_found' => 'Patient not found',
        'diagnosis_test_not_found' => 'Diagnosis Test not found',
        'pharmacist_not_found' => 'Pharmacist not found',
        'postal_not_found' => 'Postal not found',
        'radiology_category_not_found' => 'Radiology Category not found',
        'radiology_test_not_found' => 'Radiology Test not found',
        'receptionist__not_found' => 'Receptionist__not_found not found',
        'schedule_not_found' => 'Schedule not found',
        'sms_not_found' => 'Sms not found',
        'user_not_found' => 'User not found',
        'vaccinated_patient_not_found' => 'Vaccinated Patient not found',
        'vaccination_not_found' => 'Vaccination not found',
        'visitor_not_found' => 'Visitor not found',
        'testimonial_not_found' => 'Testimonial not found',
        'accountant_save' => 'Accountant saved successfully.',
        'accountant_update' => 'Accountant updated successfully.',
        'accountant_cant_delete' => 'Accountant can\'t be deleted.',
        'accountant_delete' => 'Accountant deleted successfully.',
        'account_save' => 'Account saved successfully.',
        'account_retrieved' => 'Account retrieved successfully.',
        'account_cant_delete' => 'Account can\'t be deleted.',
        'account_delete' => 'Account deleted successfully.',
        'account_update' => 'Account updated successfully.',
        'advanced_payment_save' => 'Advanced Payment saved successfully.',
        'advanced_payment_not' => 'Advanced Payment not found',
        'advanced_payment_retrieve' => 'Advanced Payment retrieved successfully.',
        'advanced_payment_updated' => 'Advanced Payment updated successfully.',
        'advanced_payment_deleted' => 'AdvancedPayment deleted successfully.',
        'ambulance_call_saved' => 'Ambulance Call saved successfully.',
        'ambulance_call_updated' => 'Ambulance Call updated successfully.',
        'ambulance_call_deleted' => 'Ambulance Call deleted successfully.',
        'driver_not_found' => 'Driver name not found',
        'driver_retrieved' => 'Driver name retrieved successful',
        'ambulance_saved' => 'Ambulance saved successfully.',
        'ambulance_update' => 'Ambulance updated successfully.',
        'ambulance_cant_delete' => 'Ambulance can\'t be deleted.',
        'ambulance_delete' => 'Ambulance deleted successfully.',
        'appointment_list_retrieved' => 'Appointment list retrieved successfully.',
        'appointment_retrieved' => 'Appointment Retrieved Successfully.',
        'appointment_not_found' => 'Appointment not found',
        'date_smaller' => 'Date should not be smaller than patient birth date.',
        'assign_date_smaller' => 'Assign date should not be smaller than patient birth date.',
        'admission_date_smaller' => 'Admission date should not be smaller than patient birth date.',
        'case_date_smaller' => 'Case date should not be smaller than patient birth date.',
        'investigation_date_smaller' => 'Investigation report date should not be smaller than patient birth date.',
        'bill_date_smaller' => 'Bill date should not be smaller than patient birth date.',
        'cant_create' => 'Can\'t create report because the patient has been dead.',
        'appointment_created' => 'Appointment created successfully.',
        'appointment_delete' => 'Appointment deleted successfully.',
        'appointment_cancel' => 'Appointment cancelled successfully.',
        'appointment_booked' => 'Appointment Booked successfully',
        'appointment_saved' => 'Appointment saved successfully.',
        'appointment_updated' => 'Appointment updated successfully.',
        'appointment_charge_must_be_greater_than_570' => 'Appointment Charge must be greater than 570',
        'appointment_approved_successfully' => 'Appointment Approved Successfully',
        'appointment_cancelled_successfully' => 'Appointment Cancelled Successfully',
        'retrieve' => 'Retrieved successfully',
        'bed_assign_save' => 'Bed Assign saved successfully.',
        'bed_assign_update' => 'Bed Assign updated successfully.',
        'bed_assign_delete' => 'Bed Assign deleted successfully.',
        'bed_saved' => 'Bed saved successfully.',
        'beds_saved' => 'Beds saved successfully.',
        'bed_retrieved' => 'Bed retrieved successfully.',
        'bed_updated' => 'Bed updated successfully.',
        'bed_cant_deleted' => 'Bed can\'t be deleted.',
        'bed_deleted' => 'Bed deleted successfully.',
        'bed_type_retrieved' => 'Bed Type retrieved successfully.',
        'bed_type_saved' => 'Bed Type saved successfully.',
        'bed_type_updated' => 'Bed Type updated successfully.',
        'bed_type_not_found' => 'Bed Type not found',
        'bed_type_cant_deleted' => 'Bed Type can\'t be deleted.',
        'bed_type_deleted' => 'Bed Type deleted successfully.',
        'bill_saved' => 'Bill saved successfully.',
        'bill_updated' => 'Bill updated successfully.',
        'bill_deleted' => 'Bill deleted successfully.',
        'bill_retrieved' => 'Details retrieved successfully.',
        'birth_report_saved' => 'Birth Report saved successfully.',
        'birth_report_updated' => 'Birth Report updated successfully.',
        'birth_report_retrieved' => 'Birth Report retrieved successfully.',
        'birth_report_deleted' => 'Birth Report deleted successfully.',
        'blood_group_saved' => 'Blood group saved successfully.',
        'blood_group_updated' => 'Blood group updated successfully.',
        'blood_bank_retrieved' => 'Blood Bank retrieved successfully.',
        'blood_bank_cant_deleted' => 'Blood Bank can\'t be deleted.',
        'blood_bank_updated' => 'Blood bank updated successfully.',
        'blood_bank_deleted' => 'Blood Bank deleted successfully.',
        'blood_donation_saved' => 'Blood Donation saved successfully.',
        'blood_donation_retrieved' => 'Blood Donation retrieved successfully.',
        'blood_donation_updated' => 'Blood Donation updated successfully.',
        'blood_donation_deleted' => 'Blood Donation deleted successfully.',
        'blood_donor_saved' => 'Blood Donor saved successfully.',
        'blood_donor_retrieved' => 'Blood Donor retrieved successfully.',
        'blood_donor_updated' => 'Blood Donor updated successfully.',
        'blood_donor_cant_delete' => 'Blood Donor can\'t be deleted.',
        'blood_donor_delete' => 'Blood Donor deleted successfully.',
        'blood_issue_saved' => 'Blood Issue saved successfully.',
        'blood_issue_updated' => 'Blood Issue updated successfully.',
        'blood_issue_retrieved' => 'Blood Issue retrieved successfully.',
        'blood_issue_deleted' => 'Blood Issue deleted successfully.',
        'blood_group_retrieved' => 'Blood Group retrieved successfully.',
        'medicine_brand_saved' => 'Medicine brand saved successfully.',
        'medicine_brand_updated' => 'Medicine brand updated successfully.',
        'medicine_brand_cant_deleted' => 'Medicine brand can\'t be deleted.',
        'medicine_brand_deleted' => 'Medicine brand deleted successfully.',
        'call_log_saved' => 'Call Log saved successfully.',
        'call_log_updated' => 'Call Log updated successfully.',
        'call_log_deleted' => 'Call Log deleted successfully.',
        'case_handler_saved' => 'Case Handler saved successfully.',
        'case_handler_updated' => 'Case Handler updated successfully.',
        'case_handler_cant_deleted' => 'Case Handler can\'t be deleted.',
        'case_handler_deleted' => 'Case Handler deleted successfully.',
        'notification_read' => 'Notification read successfully.',
        'all_notification_read' => 'All Notification read successfully.',
        'request_pending' => 'Your Manual Transaction Requests pending.',
        'manual_payment_approved' => 'Manual Payment Approved successfully.',
        'manual_payment_denied' => 'Manual Payment Denied successfully.',
        'payment_gateway_updated' => 'Payment gateway updated successfully.',
        'payment_saved' => 'Payment saved successfully.',
        'payment_updated' => 'Payment updated successfully.',
        'payment_deleted' => 'Payment deleted successfully.',
        'payment_retrieved' => 'Payment retrieved successfully.',
        'medicine_saved' => 'Medicine saved successfully.',
        'medicine_updated' => 'Medicine updated successfully.',
        'medicine_deleted' => 'Medicine deleted successfully.',
        'medicine_retrieved' => 'Medicine retrieved successfully.',
        'pathology_test_saved' => 'Pathology Test saved successfully.',
        'pathology_test_updated' => 'Pathology Test updated successfully.',
        'pathology_test_deleted' => 'Pathology Test deleted successfully.',
        'pathology_test_retrieved' => 'Pathology Test retrieved successfully.',
        'patient_admission_saved' => 'Patient Admission saved successfully.',
        'patient_admission_updated' => 'Patient Admission updated successfully.',
        'patient_admission_cant_deleted' => 'Patient Admission can\'t be deleted.',
        'patient_admission_deleted' => 'Patient Admission deleted successfully.',
        'patient_admission_retrieved' => 'Patient Admission retrieved successfully.',
        'Patient_saved' => 'Patient saved successfully.',
        'Patient_updated' => 'Patient updated successfully.',
        'Patient_cant_deleted' => 'Patient can\'t be deleted.',
        'Patient_deleted' => 'Patient deleted successfully.',
        'case_saved' => 'Case saved successfully.',
        'case_updated' => 'Case updated successfully.',
        'case_cant_deleted' => 'Case can\'t be deleted.',
        'case_deleted' => 'Case deleted successfully.',
        'case_retrieved' => 'Case retrieved successfully.',
        'notice_board_saved' => 'Notice Board saved successfully.',
        'notice_board_retrieved' => 'Notice Board retrieved successfully.',
        'notice_board_updated' => 'Notice Board updated successfully.',
        'notice_board_deleted' => 'Notice Board deleted successfully.',
        'medicine_category_saved' => 'Medicine category saved successfully.',
        'medicine_category_not_found' => 'Medicine Category not found',
        'medicine_category_retrieved' => 'Medicine category retrieved successfully.',
        'medicine_category_cant_deleted' => 'Medicine Category can\'t be deleted.',
        'medicine_category_deleted' => 'Medicine category deleted successfully.',
        'medicine_category_updated' => 'Medicine category updated successfully.',
        'Standard_charge_retrieved' => 'StandardCharge retrieved successfully.',
        'charge_saved' => 'Charge saved successfully.',
        'charge_retrieved' => 'Charge Retrieved Successfully.',
        'charge_updated' => 'Charge updated successfully.',
        'charge_deleted' => 'Charge deleted successfully.',
        'radiology_test_saved' => 'Radiology Test saved successfully.',
        'radiology_test_updated' => 'Radiology Test updated successfully.',
        'radiology_test_deleted' => 'Radiology Test deleted successfully.',
        'radiology_test_retrieved' => 'Radiology Test Retrieved Successfully.',
        'item_returned' => 'Item returned successfully.',
        'issued_item_saved' => 'Issued Item saved successfully.',
        'issued_item_deleted' => 'Issued Item deleted successfully.',
        'charge_category_saved' => 'Charge Category saved successfully.',
        'charge_category_not_found' => 'Charge Category not found',
        'charge_category_retrieved' => 'Charge Category Retrieved successfully.',
        'charge_category_updated' => 'Charge Category updated successfully.',
        'charge_category_cant_deleted' => 'Charge Category can\'t be deleted.',
        'charge_category_deleted' => 'Charge Category deleted successfully.',
        'radiology_category_saved' => 'Radiology Category saved successfully.',
        'radiology_category_retrieved' => 'Radiology Category Retrieved successfully.',
        'radiology_category_updated' => 'Radiology Category updated successfully.',
        'radiology_category_cant_deleted' => 'Radiology Category can\'t be deleted.',
        'radiology_category_deleted' => 'Radiology Category deleted successfully.',
        'item_category_saved' => 'Item Category saved successfully.',
        'item_category_retrieved' => 'Item Category Retrieved successfully.',
        'item_category_updated' => 'Item Category updated successfully.',
        'item_category_cant_deleted' => 'Item Category can\'t be deleted.',
        'item_category_deleted' => 'Item Category deleted successfully.',
        'pathology_category_saved' => 'Pathology Category saved successfully.',
        'pathology_category_retrieved' => 'Pathology Category Retrieved successfully.',
        'pathology_category_updated' => 'Pathology Category updated successfully.',
        'pathology_category_cant_deleted' => 'Pathology Category can\'t be deleted.',
        'pathology_category_deleted' => 'Pathology Category deleted successfully.',
        'live_status_retrieved' => 'Live Status retrieved successfully.',
        'live_consultation_saved' => 'Live Consultation saved successfully.',
        'live_consultation_retrieved' => 'Live Consultation Retrieved successfully.',
        'live_consultation_updated' => 'Live Consultation updated successfully.',
        'live_consultation_deleted' => 'Live Consultation deleted successfully.',
        'live_meeting_saved' => 'Live Meeting saved successfully.',
        'live_meeting_retrieved' => 'Live Meeting Retrieved successfully.',
        'live_meeting_updated' => 'Live Meeting updated successfully.',
        'live_meeting_deleted' => 'Live Meeting deleted successfully.',
        'user_zoom_credential_retrieved' => 'User Zoom Credential retrieved successfully.',
        'user_zoom_credential_saved' => 'User Zoom Credential saved successfully.',
        'item_not_found' => 'Items not found',
        'mail_sent' => 'Mail sent successfully.',
        'item_saved' => 'Item saved successfully.',
        'item_updated' => 'Item updated successfully.',
        'item_cant_deleted' => 'Item can\'t be deleted.',
        'item_deleted' => 'Item deleted successfully.',
        'lab_technician_saved' => 'Lab Technician saved successfully.',
        'lab_technician_updated' => 'Lab Technician updated successfully.',
        'lab_technician_cant_deleted' => 'Lab Technician can\'t be deleted.',
        'lab_technician_deleted' => 'Lab Technician deleted successfully.',
        'nurse_saved' => 'Nurse saved successfully.',
        'nurse_updated' => 'Nurse updated successfully.',
        'nurse_cant_deleted' => 'Nurse can\'t be deleted.',
        'nurse_deleted' => 'Nurse deleted successfully.',
        'Pharmacist_saved' => 'Pharmacist saved successfully.',
        'Pharmacist_updated' => 'Pharmacist updated successfully.',
        'Pharmacist_cant_deleted' => 'Pharmacist can\'t be deleted.',
        'Pharmacist_deleted' => 'Pharmacist deleted successfully.',
        'package_saved' => 'Package saved successfully.',
        'package_updated' => 'Package updated successfully.',
        'package_cant_deleted' => 'Package can\'t be deleted.',
        'package_deleted' => 'Package deleted successfully.',
        'item_stock_saved' => 'Item Stock saved successfully.',
        'item_stock_updated' => 'Item Stock updated successfully.',
        'item_stock_deleted' => 'Item Stock deleted successfully.',
        'diagnosis_category_saved' => 'Diagnosis Category saved successfully.',
        'diagnosis_category_not_found' => 'Diagnosis Category not found',
        'diagnosis_category_retrieved' => 'Diagnosis Category retrieved successfully.',
        'diagnosis_category_updated' => 'Diagnosis Category updated successfully.',
        'diagnosis_category_cant_deleted' => 'Diagnosis Category can\'t be deleted.',
        'diagnosis_category_deleted' => 'Diagnosis Category deleted successfully.',
        'death_report_saved' => 'Death Report saved successfully.',
        'death_report_retrieved' => 'Death Report retrieved successfully.',
        'death_report_updated' => 'Death Report updated successfully.',
        'death_report_deleted' => 'Death Report deleted successfully.',
        'department_saved' => 'Department saved successfully.',
        'department_retrieved' => 'Department retrieved successfully.',
        'department_updated' => 'Department updated successfully.',
        'department_deleted' => 'Department deleted successfully.',
        'doctor_department_saved' => 'Doctor Department saved successfully.',
        'doctor_department_not_found' => 'Doctor Department not found',
        'doctor_department_retrieved' => 'Doctor Department retrieved successfully.',
        'doctor_department_updated' => 'Doctor Department updated successfully.',
        'doctor_department_cant_deleted' => 'Doctor Department can\'t be deleted.',
        'doctor_department_deleted' => 'Doctor Department deleted successfully.',
        'patient_diagnosis_saved' => 'Patient diagnosis saved successfully.',
        'patient_diagnosis_updated' => 'Patient diagnosis updated successfully.',
        'patient_diagnosis_deleted' => 'Patient diagnosis deleted successfully.',
        'users_not_found' => 'Users not found',
        'user_saved' => 'User saved successfully.',
        'user_deleted' => 'User deleted Successfully.',
        'user_updated' => 'User updated Successfully.',
        'post_not_found' => 'Post not found',
        'post_saved' => 'Post saved successfully.',
        'post_deleted' => 'Post deleted successfully.',
        'post_state_updated' => 'Status updated successfully.',
        'doctor_save' => 'Doctor saved successfully.',
        'doctor_not_found' => 'Doctor not found',
        'doctor_update' => 'Doctor updated successfully.',
        'doctor_cant_deleted' => 'Doctor can\'t be deleted.',
        'doctor_delete' => 'Doctor deleted successfully.',
        'OPD_charge_saved' => 'Doctor OPD Charge saved successfully.',
        'OPD_charge_retrieved' => 'Doctor OPD Charge Retrieved successfully.',
        'OPD_charge_updated' => 'Doctor OPD Charge updated successfully.',
        'OPD_charge_deleted' => 'Doctor OPD Charge deleted successfully.',
        'operation_report_saved' => 'Operation Report saved successfully.',
        'operation_report_retrieved' => 'Operation Report Retrieved successfully.',
        'operation_report_updated' => 'Operation Report updated successfully.',
        'operation_report_deleted' => 'Operation Report deleted successfully.',
        'OPD_diagnosis_saved' => 'OPD Diagnosis saved successfully.',
        'OPD_diagnosis_retrieved' => 'OPD Diagnosis Retrieved successfully.',
        'OPD_diagnosis_updated' => 'OPD Diagnosis updated successfully.',
        'OPD_diagnosis_deleted' => 'OPD Diagnosis deleted successfully.',
        'OPD_timeline_saved' => 'OPD Timeline saved successfully.',
        'OPD_timeline_retrieved' => 'OPD Timeline Retrieved successfully.',
        'OPD_timeline_updated' => 'OPD Timeline updated successfully.',
        'OPD_timeline_deleted' => 'OPD Timeline deleted successfully.',
        'OPD_Patient_saved' => 'OPD Patient saved successfully.',
        'OPD_Patient_updated' => 'OPD Patient updated successfully.',
        'OPD_Patient_deleted' => 'OPD Patient deleted successfully.',
        'IPD_charge_saved' => 'IPD Charge saved successfully.',
        'IPD_charge_retrieved' => 'IPD Charge Retrieved successfully.',
        'IPD_charge_updated' => 'IPD Charge updated successfully.',
        'IPD_charge_deleted' => 'IPD Charge deleted successfully.',
        'IPD_diagnosis_saved' => 'IPD Diagnosis saved successfully.',
        'IPD_diagnosis_retrieved' => 'IPD Diagnosis Retrieved successfully.',
        'IPD_diagnosis_updated' => 'IPD Diagnosis updated successfully.',
        'IPD_diagnosis_deleted' => 'IPD Diagnosis deleted successfully.',
        'IPD_Patient_saved' => 'IPD Patient saved successfully.',
        'IPD_Patient_updated' => 'IPD Patient updated successfully.',
        'IPD_Patient_deleted' => 'IPD Patient deleted successfully.',
        'IPD_consultant_saved' => 'IPD Consultant Instruction saved successfully.',
        'IPD_consultant_retrieved' => 'IPD Consultant Instruction Retrieved successfully.',
        'IPD_consultant_updated' => 'IPD Consultant Instruction updated successfully.',
        'IPD_consultant_deleted' => 'IPD Consultant Instruction deleted successfully.',
        'IPD_Prescription_saved' => 'IPD Prescription saved successfully.',
        'IPD_Prescription_retrieved' => 'IPD Prescription Retrieved successfully.',
        'IPD_Prescription_updated' => 'IPD Prescription updated successfully.',
        'IPD_Prescription_deleted' => 'IPD Prescription deleted successfully.',
        'prescription_saved' => 'Prescription saved successfully.',
        'prescription_not_found' => 'Prescription not found',
        'prescription_retrieved' => 'Prescription Retrieved successfully.',
        'prescription_updated' => 'Prescription updated successfully.',
        'prescription_deleted' => 'Prescription deleted successfully.',
        'setting_updated' => 'Setting updated successfully.',
        'service_saved' => 'Service saved successfully.',
        'service_not_found' => 'Service not found',
        'service_updated' => 'Service updated successfully.',
        'service_cant_deleted' => 'Service Type can\'t be deleted.',
        'service_deleted' => 'Service deleted successfully.',
        'IPD_payment_saved' => 'IPD Payment saved successfully.',
        'IPD_payment_retrieved' => 'IPD Payment Retrieved successfully.',
        'IPD_payment_updated' => 'IPD Payment updated successfully.',
        'IPD_payment_deleted' => 'IPD Payment deleted successfully.',
        'IPD_timeline_saved' => 'IPD Timeline saved successfully.',
        'IPD_timeline_retrieved' => 'IPD Timeline Retrieved Successfully.',
        'IPD_timeline_updated' => 'IPD Timeline updated successfully.',
        'IPD_timeline_deleted' => 'IPD Timeline deleted successfully.',
        'document_saved' => 'Document saved successfully.',
        'document_retrieved' => 'Document Retrieved successfully.',
        'document_updated' => 'Document updated successfully.',
        'document_deleted' => 'Document deleted successfully.',
        'expense_saved' => 'Expense saved successfully.',
        'expense_retrieved' => 'Expense retrieved successfully.',
        'expense_updated' => 'Expense updated successfully.',
        'expense_deleted' => 'Expense deleted successfully.',
        'income_saved' => 'Income saved successfully',
        'income_retrieved' => 'Income retrieved successfully.',
        'income_updated' => 'Income updated successfully.',
        'income_deleted' => 'Income deleted successfully.',
        'visitor_saved' => 'Visitor saved successfully.',
        'visitor_updated' => 'Visitor updated successfully.',
        'visitor_deleted' => 'Visitor deleted successfully.',
        'vaccinated_patients_saved' => 'Vaccinated Patients saved successfully.',
        'vaccinated_patients_retrieved' => 'Vaccinated Patients retrieved successfully.',
        'vaccinated_patients_updated' => 'Vaccinated Patients updated successfully.',
        'vaccinated_patients_deleted' => 'Vaccinated Patients deleted successfully.',
        'vaccination_saved' => 'Vaccination saved successfully.',
        'vaccination_retrieved' => 'Vaccination retrieved successfully.',
        'vaccination_updated' => 'Vaccination updated successfully.',
        'vaccination_cant_deleted' => 'Vaccination can\'t be deleted',
        'vaccination_deleted' => 'Vaccination deleted successfully.',
        'invoice_saved' => 'Invoice saved successfully.',
        'invoice_updated' => 'Invoice updated successfully.',
        'invoice_deleted' => 'Invoice deleted successfully.',
        'insurance_saved' => 'Insurance saved successfully.',
        'invoice_id_already_exist' => 'Invoice id already exist',
        'insurance_updated' => 'Insurance updated successfully.',
        'insurance_cant_deleted' => 'Insurance Type can\'t be deleted.',
        'insurance_deleted' => 'Insurance deleted successfully.',
        'receptionist_saved' => 'Receptionist saved successfully.',
        'receptionist_updated' => 'Receptionist updated successfully.',
        'receptionist_cant_deleted' => 'Receptionist Type can\'t be deleted.',
        'receptionist_deleted' => 'Receptionist deleted successfully.',
        'schedule_saved' => 'Schedule saved successfully.',
        'schedule_updated' => 'Schedule updated successfully.',
        'schedule_cant_deleted' => 'Schedule Type can\'t be deleted.',
        'schedule_deleted' => 'Schedule deleted successfully.',
        'frontService_saved' => 'FrontService saved successfully.',
        'frontService_retrieved' => 'FrontService retrieved successfully.',
        'frontService_updated' => 'FrontService updated successfully.',
        'frontService_deleted' => 'FrontService deleted successfully.',
        'front_setting_updated' => 'Front Setting updated successfully.',
        'order_created' => 'Order Created Successfully.',
        'FAQs_created' => 'FAQs created successfully.',
        'FAQs_retrieved' => 'FAQs retrieved successfully.',
        'FAQs_updated' => 'FAQs updated successfully.',
        'FAQs_deleted' => 'FAQs deleted successfully.',
        'income_and_expense_retrieved' => 'Income and Expense report retrieved successfully.',
        'income_report_generate' => 'Income Report Generate successfully.',
        'hospital_saved' => 'Hospital saved successfully.',
        'hospital_schedule_saved' => 'Hospital Schedule saved successfully.',
        'hospital_update' => 'Hospital updated successfully.',
        'IPD_bill_saved' => 'IPD Bill saved successfully.',
        'document_type_saved' => 'Document Type saved successfully.',
        'document_type_not_found' => 'Document Type not found',
        'document_type_retrieved' => 'Document Type retrieved successfully.',
        'document_type_updated' => 'Document Type updated successfully.',
        'document_type_cant_deleted' => 'Document Type can\'t be deleted.',
        'document_type_deleted' => 'Document Type deleted successfully.',
        'subscription_plan_saved' => 'Subscription Plan created successfully.',
        'subscription_plan_retrieved' => 'Subscription Plan retrieved successfully.',
        'subscription_plan_updated' => 'Subscription Plan updated successfully.',
        'subscription_plan_cant_deleted' => 'Subscription Plan can\'t be deleted.',
        'subscription_plan_deleted' => 'Subscription Plan deleted successfully.',
        'employee_payroll_saved' => 'Employee Payroll saved successfully.',
        'employee_payroll_updated' => 'Employee Payroll updated successfully.',
        'employee_payroll_deleted' => 'Employee Payroll Deleted successfully.',
        'employee_list_not_found' => 'Employees List not found',
        'employee_payroll_retrieved' => 'Employee Payroll retrieved successfully.',
        'enquiry_send' => 'Enquiry send successfully.',
        'enquiry_delete' => 'Enquiry deleted successfully.',
        'testimonial_save' => 'Testimonial saved successfully.',
        'testimonial_retrieve' => 'Testimonials Retrieved Successfully.',
        'testimonial_update' => 'Testimonial updated successfully.',
        'testimonial_delete' => 'Testimonial deleted successfully.',
        'new_tenant_assigned' => 'New tenant assigned successfully',
        'password_update' => 'Password updated successfully.',
        'profile_update' => 'Profile updated successfully.',
        'data_retrieved' => 'Data Retrieved Successfully.',
        'subscription_created' => 'Subscription created successfully.',
        'subscription_updated' => 'Subscription updated successfully.',
        'subscription_retrieved' => 'Subscription retrieved successfully.',
        'postal_receive_saved' => 'Postal Receive saved successfully.',
        'postal_dispatch_saved' => 'Postal Dispatch saved successfully.',
        'postal_dispatch_deleted' => 'Postal Dispatch deleted successfully.',
        'postal_receive_retrieved' => 'Postal Receive retrieved successfully.',
        'postal_dispatch_retrieved' => 'Postal Dispatch retrieved successfully.',
        'postal_receive_update' => 'Postal Receive update successfully.',
        'postal_receive_deleted' => 'Postal Receive deleted successfully.',
        'postal_dispatch_update' => 'Postal Dispatch update successfully',
        'postal_deleted' => 'Postal deleted successfully.',
        'investigation_report_saved' => 'Investigation Report saved successfully.',
        'investigation_report_not_found' => 'Investigation Report not found',
        'investigation_report_updated' => 'Investigation Report updated successfully.',
        'investigation_report_deleted' => 'Investigation Report deleted successfully.',
        'sms_limit_over' => 'Your current plan sms limit is over.',
        'sms_send' => 'SMS send successfully.',
        'sms_delete' => 'SMS delete successfully',
        'user_list_not' => 'User List not found',
        'user_retrieved' => 'User retrieved successfully.',
        'language_update' => 'Language Updated Successfully.',
        'sms_retrieved' => 'SMS Retrieved',
        'email_verified' => 'Email Verified successfully.',
        'default_plan_changed' => 'Default plan changed successfully.',
        'session_created' => 'Session created successfully.',
        'your_payment_success' => 'Your Payment is successfully completed.',
        'your_payment_failed' => 'Your Payment is failed.',
        'cannot_switch' => 'Cannot switch to zero plan if trial is available / having a paid plan which is currently active',
        'some_doctors' => 'Some doctors have scheduled their days in given unchecked days, so are you sure you want to perform this operation?',
        'currency_not_supported_paypal' => 'This currency is not supported by PayPal for making payments.',
        'currency_not_supported_razorpay' => 'This currency is not supported by Razorpay for making payments.',
        'unable_to_process' => 'Unable to process the payment at the moment. Try again later.',
        'the_patient' => 'The patient is already registered with same vaccine and dose no.',
        'opd_diagnosis_report_generated' => 'Diagnosis Report generated Successfully.',
        'failed_to_redirect' => 'Failed to Redirect',
        'access_denied' => 'Access Denied',
        'patient_smart_card_deleted' => 'Patient Smart Card Deleted Successfully.',
        'smart_patient_card_template_already_in_use' => 'Smart Patient Card Template already in use.',
        'please_select_header_color' => 'Please select header color',
    ],

    'purchase_medicine' => [
        'purchase_number' => 'Purchase Number',
        'total' => 'Total',
        'discount' => 'Discount',
        'tax_amount' => 'Tax Amount',
        'net_amount' => 'Net Amount',
        'payment_mode' => 'Payment Mode',
        'payment_note' => 'Payment Note',
        'note' => 'Note',
        'purchase_medicine' => 'Purchase Medicine',
        'purchase_medicine_details' => 'Purchase Medicine Details',
        'purchase_medicine_overview' => 'Purchase Medicine Overview',
        'lot_no' => 'Lot no.',
        'tax' => 'Tax',
        'quantity' => 'Quantity',
        'amount' => 'Amount',
        'expiry_date' => 'Expiry Date',
        'other_details' => 'Other Details',
        'dose_duration' => 'Dose Duration',
    ],

    'used_medicine' => [
        'used_medicine' => 'Used Medicine',
        'used_quantity' => 'Used Quantity',
        'used_at' => 'Used At',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Medicine Bills',
        'medicine_bill' => 'Medicine Bill',
        'add_medicine_bill' => 'Add Medicine Bill',
        'edit_medicine_bill' => 'Edit Medicine Bill',
        'medicine_bill_details' => 'Medicine Bill details',
        'dose_interval' => 'Dose Interval',
        'available_quantity' => 'The available quantity of',
        'is' => 'is',
        'prescription_not_found' => 'Prescription not found.',
        'medicine_not_selected' => 'Please select at least one medicine.',
        'duplicate_medicine' => 'Cannot add duplicate medicines.',
        'payment_status' => 'Payment Status',
        'sale_price' => 'Sale Price',
        'select_medicine' => 'Select Medicine',
        'update_quantity' => 'Update quantity should be less than previous quantity.',
        'net_amount_not_empty' => 'Net amount can not be empty.',
        'net_amount_not_zero' => 'Net amount can not be zero.',
        'medicine_required' => 'Medicine field is required.',
        'bill_number' => 'Bill Number',
        'connect_with_zoom' => 'Connect With Zoom',
        'connected' => 'Connected',
    ],

    'new_change' => [
        'current_password_invalid' => 'Current password is invalid.',
        'captcha_verification_failed' => 'Captcha verification failed.',
        'paystack_created' => 'Paystack created successfully.',
        'unique_vehicle_number' => 'The vehicle number has already been taken.',
        'unique_patient' => 'The patient\'s name has already been taken.',
        'select_appointment_date' => 'Please select appointment date.',
        'select_time_slot' => 'Please select appointment time slot.',
        'pending_payment' => 'Pending Payment',
        'have_to_connect_zoom' => 'You have to connect with zoom.',
        'invalid_token' => 'Invalid access token.',
        'in_progress' => 'Sorry, you cannot delete this meeting since it\'s in progress.',
        'add_credential' => 'Please, add credentials for zoom meeting.',
        'already_in_use' => 'Your zoom credentials are already in use.',
        'all_required_fields' => 'Please fill all the required fields.',
        'password_not_match' => 'Password and Confirm password not match.',
        'subscribed_success' => 'Subscribed Successfully.',
        'not_have_account' => 'Don’t have an account',
        'google_captcha_required' => 'The Google reCaptcha field is required.',
        'captcha_failed' => 'Captcha verification failed',
        'case_required' => 'The case field is required.',
        'bed_required' => 'The bed field is required.',
        'best_resolution_profile' => 'Best resolution for this profile will be',
        'best_resolution_icon' => 'Best resolution for this icon will be',
        'best_resolution_image' => 'Best resolution for this image will be',
        'select_ipd_patient' => 'Select IPD Patient',
        'currency_update' => 'Currency updated successfully',
        'currency_store' => 'Currency saved successfully',
        'plan_price' => 'Plan Price',
        'new_plan' => 'New Plan',
        'pre_plan' => 'Remaining Balance of Prev. Plan',
        'payable_amount' => 'Payable Amount',
        'remaining_days' => 'Remaining days',
        'used_balance' => 'Used Balance',
        'current_plan' => 'Current Plan',
        'current_expired_plan' => 'Current Expired Plan',
        'sunday' => 'Sunday',
        'monday' => 'Monday',
        'tuesday' => 'Tuesday',
        'wednesday' => 'Wednesday',
        'thursday' => 'Thursday',
        'friday' => 'Friday',
        'saturday' => 'Saturday',
        'service_slider_store' => 'Service slider image created successfully.',
        'service_slider_update' => 'Service slider image updated successfully.',
        'captcha_key' => 'Google Captcha key',
        'captcha_secret' => 'Google Captcha Secret',
        'change_image' => 'Change  Image',
        'allow_img_text_extra' => 'Allowed file types: png, jpg, gif, jpeg, svg, webp.',
        'sms_limit' => 'Sms Limit',
        'enter_sms-limit' => 'Enter Sms Limit',
        'no_records_found' => 'No records founds.',

        'bed_distinct' => 'The Bed field has a duplicate value.',
        'bed_unique' => 'The Bed input has already been taken.',
        'name_unique' => 'The name has already been taken.',
        'charge_number' => 'The charge must be number.',
        'charge_regex' => 'The charge must be in a valid format.',
        'password_min' => 'Password must contain at least 6 characters.',
        'password_same' => 'The password and confirm password must be matched.',
        'bed_required' => 'The bed field is required.',
        'slug_unique' => 'The Hospital Slug has already been taken.',
        'service_image_required' => 'Service image slider field is required.',
        'email_subscribe' => 'The email has already subscribed.',
        'admission_required' => 'The Admission id field is required.',
        'one_patient' => 'Please select at least one patient.',
        'category_required' => 'The Category field is required.',
        'brand_required' => 'The Brand field is required.',
        'card_one_char' => 'The card one text secondary must not be greater than 90 characters',
        'back_to_main_site' => 'Back To Main Site',
        'added_at' => 'Added At',

        'pathology_units' => 'Pathology Units',
        'pathology_unit' => 'Pathology Unit',
        'add_unit' => 'New Pathology Unit',
        'edit_unit' => 'Edit Pathology Unit',
        'pathology_unit_not_found' => 'Pathology Unit not found',
        'pathology_unit_cant_deleted' => 'Pathology Unit can\'t be deleted.',
        'pathology_parameter_not_found' => 'Pathology Parameter not found',
        'pathology_parameter_cant_deleted' => 'Pathology Parameter can\'t be deleted.',
        'pathology_parameter' => 'Pathology Parameter',
        'pathology_parameters' => 'Pathology Parameters',
        'add_parameter' => 'New Pathology Parameter',
        'edit_parameter' => 'Edit Pathology Parameter',
        'parameter_name_required' => 'Parameter Name field is required.',
        'patient_result_required' => 'Patient Result field is required.',
        'parameter_name' => 'Parameter Name',
        'patient_result' => 'Patient Result',
        'select_parameter_name' => 'Select Parameter Name',
        'reference_range' => 'Reference Range',
        'select_unit' => 'Select Unit',
        'print_pathology_test' => 'Print Pathology Test',
        'pathology_test_report' => 'Pathology Test Report',
        'default_admin_not_delete' => 'Default SuperAdmin can\'t be deleted.',
        'notify_mail_for_patient_book' => 'Notify Mail For Patient booked appointment',
        'currency_setting_not_found' => 'Currency Setting not found',
        'default_currency_not_delete' => 'Can not be delete default currency',
        'time_invalid' => 'day start time is invalid',
        'hospital_not_delete' => 'Hospital Type can\'t be deleted.',
        'patient_invoice_bill' => 'Patient Invoice Bill',
        'patient_mail_send' => 'Patient invoice mail send successfully.',
        'is' => 'is',
        'staff_limit' => 'Maximum staff add limit is 10.',
        'medicine_bill_already_use' => 'This medicine is already used in medicine bills, are you sure want to delete it?',
        'not_in_use' => 'Not in use',
        'paystack_support_zar' => "Only 'ZAR','USD','GHS','NGN','KES' Currency is Allowed.",
        'payment_fail' => 'Payment failed for some reason',
        'paystack_token_expired' => 'The paystack token has expired. Please refresh the page and try again.',
        'paytm_support_indian' => 'Paytm only supported indian currency.',
        'medicine_purchase_success' => 'Medicine purchased successfully',
        'provide_stripe_key' => 'Please Provide a Stripe key.',
        'currency_not_delete' => 'Currency can\'t be deleted.',
        'admin_not_delete' => 'Default Admin can\'t be deleted.',
        'slug_unique' => 'The hospital slug has already been taken.',
        'subscription_mail' => 'Subscription Mail.',
        'hospital_register' => 'Notify Mail For New Hospital Registered',
        'appointment_with_doctor' => 'You have an appointment with Dr.',
        'doctor_appointments' => 'Doctor Appointments',
        'enquiry_mail' => 'Enquiry Mail',
        'consultancy_create' => 'New Live Consultation Created',
        'meeting_create' => 'New Live Meeting Created',
        'hello' => 'Hello',
        'dr.' => 'Dr.',
        'reminder' => 'This is just to remind you that your appointment with',
        'within_one_hour' => 'is within next one hour',
        'patient_problem' => 'Patient Problem',
        'appointment_time' => 'Appointment Time',
        'thanks_regards' => 'Thanks & Regards',
        'new_hospital_registerd' => 'A new hospital has been registered in your list of hospitals.',
        'hospital_contact' => 'Hospital Contact',
        'prescription_report' => 'Prescription Report',
        'years' => 'Years',
        'patient_diagnosis_test_report' => 'Patient Diagnosis Test Report',
        'diagnosis_report_id' => 'Patient Diagnosis Report ID',
        'no_ipd_patient_found' => 'No IPD Patient Found',
        'deduction_not_greater_than_salary' => 'Deductions cannot be greater than Basic salary + Allowance',
        'terms_condition_required' => 'The Terms & Conditions is required.',
        'privacy_policy' => 'The Privacy Policy is required.',
        'image_must_be' => 'The image must be a file of type: jpg, jpeg, png.',
        'field_not_contain_white_space' => 'field is not contain only white space',
        'document_must_be_file_type' => 'The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.',
        'select_code' => 'Select Code',
        'select_item' => 'Select Item',
        'discount_less_than_amount' => 'The discount should be less than the total amount.',
        'tax_less_100' => 'Taxes should be less than 100%.',
        'quantity_not_empty' => 'Quantity cannot be zero or empty.',
        'select_duration' => 'Select Duration',
        'select_dose_interval' => 'Select Dose Interval',
        'enter_lot_no' => 'Enter lot number .',
        'tax_not_empty' => 'The tax amount can not be zero or empty.',
        'quantity_greater_than_0' => 'Quantity should be greater than 0.',
        'enter_sale_price' => 'Enter sale price.',
        'enter_purchase_price' => 'Enter purchase price.',
        'enter_quantity' => 'Please enter quantity.',
        'select_charge' => 'Select Charge',
        'charchter_160' => 'The message may not be greater than 160 characters.',
        'enter_captcha_key' => 'Please enter Google captcha Key.',
        'enter_captcha_secret' => 'Please enter Google captcha Secret.',
        'paypal_client_id' => 'Please enter paypal client id.',
        'paypal_secret' => 'Please enter paypal secret.',
        'paypal_mode' => 'Please enter paypal mode.',
        'razor_pay_secret' => 'Please enter razorpay Secret.',
        'razorpay_key' => 'Please enter razorpay key.',
        'stripe_secret' => 'Please enter stripe Secret.',
        'stripe_key' => 'Please enter Stripe Secret.',
        'paystack_key' => 'Please enter paystack public Key.',
        'paystack_secret' => 'Please enter paystack secret Key.',
        'paytm_id' => 'Please enter paytm merchant Id.',
        'paytm_key' => 'Please enter paytm merchant Key.',
        'sending' => 'Sending...',
        'warning' => 'Warning !',
        'select_payment_gateway' => 'Select Payment Gateway',
        'upcoming_appointments' => 'Upcoming Appointments',
        'expired' => 'Expired',
        'not_expired' => 'Not Expired',
        'plan_expire_status' => 'Expire',
        'select_plan_expire_status' => 'Select Expire',
        'if_you_did_not_create_an_account' => 'If you did not create an account, no further action is required.',
        'verify_email_address' => 'Verify Email Address',
        'click_the_button_below_to_verify_your_email_address' => 'Please click the button below to verify your email address.',
        'trouble' => 'If you’re having trouble clicking the "Verify Email Address" button, copy and paste the URL below into your web browser',
    ],
    'holiday' => [
        'holiday' => 'Holiday',
        'add_holiday' => 'Add Holiday',
        'doctor_holiday' => 'Doctor Holidays',
        'service_category' => 'Service Category',
        'holiday_date' => 'Holiday Date',
        'reason' => 'Reason',
        'holiday_already_is_exist' => 'Holiday is already exist.',
        'doctor_holiday_create' => 'Doctor Holiday saved successfully.',
        'you_are_not_allow_to_record' => 'Seems, you are not allowed to access this record.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'Breaks',
        'lunch_break' => 'Break',
        'break_create' => 'Break saved successfully.',
        'break_update' => 'break updated successfully.',
        'add_break' => 'Add Break',
        'edit_break' => 'Edit Break',
        'break_already_is_exist' => 'Break is already exist.',
        'break_time_greater_than_zero' => 'Break From time must be greater than Zero',
        'break_to_time_greater_than_zero' => 'Break To time must be greater than Zero',
        'break_to_time_greater_than_from_time' => 'Break To time must be greater than Break From time.',
        'every_day' => 'Every Day',
        'single_day' => 'Single Day',
        'date_required' => 'Date field is required',
        'ipd_timeline' => 'IPD Timeline',
        'date_required' => 'Date field is required.',

        'professional_details' => 'Professional Details',
        'get_direction' => 'Get Direction',
        'filters' => 'Filters',
        'smart_card_template_saved' => 'Patient Smart Card Template saved successfully.',
        'smart_card_template_update' => 'Patient Smart Card Template updated successfully.',
        'smart_card_saved' => 'Patient Smart Card Saved successfully.',
        'smart_patient_card_template' => 'Patient Smart Card Templates',
        'new_smart_patient_card_template' => 'New Patient Smart Card Template',
        'edit_smart_patient_card_template' => 'Edit Patient Smart Card Template',
        'template_name' => 'Template Name',
        'header_color' => 'Header Color',
        'show_email' => 'Show Email',
        'show_phone' => 'Show Phone',
        'show_dob' => 'Show DOB',
        'show_blood_group' => 'Show Blood Group',
        'show_address' => 'Show Address',
        'show_patient_unique_id' => 'Show Patient Unique ID',
        'id' => 'ID',
        'generate_smart_patient_card' => 'New Patient Smart Card',
        'for_all_patient' => 'For All Patient',
        'only_one_patient' => 'Only One Patient',
        'remaining_patient' => 'Remaining Patient',
        'generate_smart_patient_cards' => 'Generate Patient Smart Cards',
        'card_template' => 'Patient Smart Card Template',
        'smart_patient_card' => 'Patient Smart Card',
        'template_required' => 'Template Name field is required.',
        'patient_required' => 'Patient field is required.',
        'qr_code_not_found' => 'QR code not found.',
        'dob' => 'DOB',
        'reset_filter' => 'Reset Filter',
        'appointment_exist_time' => 'Appointment is already exist at this time.',
        'appointment_exist_date' => 'Appointment is already exist at this Date.',
        'are_u_sure' => 'Are you sure?',
        'u_want_to_complete_this_payment' => 'You want to complete this payment!',
        'patient_unique_id' => 'Patient Unique ID',
        'patient_smart_cards' => 'Patient Smart Cards',
        'select_template' => 'Select Template',
        'print_discharge_slip' => 'Print Discharge Slip',
        'discharge_slip' => 'Discharge Slip',
        'bed_charge' => 'Bed Charge',
        'discharge' => 'Discharge',
        'not_dischared' => 'Not Discharged',
        'diagnosis_success' => 'Diagnosis Report status updated successfully.',
        'case_exist' => 'IPD Patient is already exists.',
        'payment_request_send' => 'Payment request sent successfully.',
        'select_payment_mode' => 'Select payment mode',
        'todays_appointments' => 'Today\'s Appointments',
        'total_meetings' => 'Total Meetings',
        'ipd_due_amount' => 'IPD Due Amount',
        'recent_appointments' => 'Recent Appointments',
    ],
    'custom_field' => [
        'manual_instruction' => 'Manual Instruction',
        'custom_field' => 'Custom Fields',
        'add_custom_field' => 'Add Custom Field',
        'edit_custom_field' => 'Edit Custom Field',
        'module_name' => 'Module Name',
        'field_type' => 'Field Type',
        'field_name' => 'Field Name',
        'grid' => 'Grid',
        'value' => 'Value',
        'seperated_by_comma' => 'Seperated by Comma',
        'is_reqired' => 'Is Reqired',
        'input' => 'Input',
        'textarea' => 'Textarea',
        'checkbox' => 'Checkbox',
        'number' => 'Number',
        'dropdown' => 'Dropdown',
        'multi_select' => 'Multi select',
        'date' => 'Date',
        'date_time' => 'Date & Time',
        'appointment' => 'Appointment',
        'ipd_patient' => 'IPD Patient',
        'opd_patient' => 'OPD Patient',
        'patient' => 'Patient',
        'value_must_be_greter_then' => 'Value must be greter then 1',
        'select_module' => 'Select Module',
        'select_field_type' => 'Select Field Type',
        'value_field_required' => 'The value field is required.',
        'toggle' => 'Toggle',
        'text' => 'Text',
        'grid_tooltip' => '(Bootstrap Column e.g. 6) - Max is 12',
        'manual_instruction' => 'Manual Instruction',
        'diagnosis_success' => 'Diagnosis Report status updated successfully.',
        'case_exist' => 'IPD Patient is already exists.',
        'payment_request_send' => 'Payment request sent successfully.',
    ],

    'phonepe' => [
        'phonepe' => 'PhonePe',
        'phonepe_merchant_id' => 'Phonepe Merchant ID',
        'phonepe_merchant_user_id' => 'Phonepe Merchant User ID',
        'phonepe_env' => 'Phonepe Env',
        'phonepe_salt_key' => 'Phonepe Salt Key',
        'phonepe_salt_index' => 'Phonepe Salt Index',
        'phonepe_merchant_transaction_id' => 'Phonepe Merchant Transaction ID',
        'currency_allowed' => 'Only INR Currency allowed',
    ],

    'flutterwave' => [
        'flutterwave' => 'FlutterWave',
        'set_flutterwave_credential' => 'Please Set your flutterwave Credentials.',
        'currency_allowed' => "Only 'GBP','CAD','XAF','CLP','COP','EGP','EUR','GHS','GNF','KES','MWK','MAD','NGN','RWF','SLL','STD','ZAR','TZS','UGX','USD','XOF','ZMW' Currency is Allowed.",
        'flutterwave_public_key' => 'FlutterWave Public Key',
        'flutterwave_secret_key' => 'FlutterWave Seceret Key',
    ],

    'google_meet' => [
        'connect_calendar' => 'Connect your google calendar',
        'connect_google_meet' => 'Connect Google Calendar',
        'disconnect_google_calendar' => 'Disconnect your google calendar',
        'sync_google_calendar' => 'Sync your google calendar',
        'validate_json_file' => 'Please set your google calendar credentials json file',
        'google_calendar_connect' => 'Google Calendar Connected Successfully',
        'google_calendar_add' => 'Calendar added successfully',
        'google_calendar_update' => 'Google calender updated successfully.',
        'disconnect_or_reconnect' => 'Please disconnect and reconnect your google calendar',
        'google_calendar_disconnect' => 'Google calender disconnected',
        'select_google_calendar' => 'Select your calendars (from Google Calendar) in which you want to create the events',
        'platform_type' => 'Platform Type',
        'opd_prescription' => 'OPD Prescription',
        'google_json_file' => 'Google JSON File',
        'upload_json_file' => 'Please upload your google calendar credentials JSON file',
        'upload_file' => 'Please upload a JSON file.',
        'invalid_json_format' => 'Invalid input format. Please upload JSON format file.',
        'json_file_saved_successfully' => 'Google Calendar JSON File Saved Successfully.',
        'upload_again_json_file' => 'The Google JSON file does not exist. Please again upload JSON File.',
    ],

    'schedule_weekday' => [
        'Monday' => 'Monday',
        'Tuesday' => 'Tuesday',
        'Wednesday' => 'Wednesday',
        'Thursday' => 'Thursday',
        'Friday' => 'Friday',
        'Saturday' => 'Saturday',
        'Sunday' => 'Sunday',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'MON',
        'TUE' => 'TUE',
        'WED' => 'WED',
        'THU' => 'THU',
        'FRI' => 'FRI',
        'SAT' => 'SAT',
        'SUN' => 'SUN',
    ],

    'open_ai' => [
        'open_ai' => 'Openai',
        'provide_prompt' => 'Please Provide Physical Information for Prompt.',
        'open_ai_key_not_found' => 'OpenAI API key not found.',
        'repsonse_retrive_successfully' => 'Response retrieved successfully.',
        'open_ai_key' => 'Open AI Key',
        'suggest_medicines' => 'Suggest Medicines',
        'suggested_medicines' => 'Suggested Medicines',
    ],

    'plan_frequency' => [
        '1' => 'Monthly',
        '2' => 'Yearly',
    ],

    'fields' => [
        'the' => 'The',
        'required' => 'field is required.',
        'unique' => 'The email has already been taken.',
        'min_char' => 'The password must be at least 8 characters.',
        'confirm' => 'The confirm Password confirmation does not match.',
    ],
];
