<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - German Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin_details' => 'Admin-Details',
    'admins' => 'Admins',
    'admin' => 'Administrator',
    'roles' => 'Rollen',
    'doctor_departments' => 'Arztabteilungen',
    'nurses' => 'Krankenschwestern',
    'doctors' => 'Ärztinnen',
    'patients' => 'Patientinnen',
    'lab_technicians' => 'Labortechniker',
    'receptionists' => 'Rezeptionistinnen',
    'pharmacists' => 'Apothekerinnen',
    'accountants' => 'Buchhalterinnen',
    'appointments' => 'Termine',
    'insurances' => 'Versicherungen',
    'investigation_reports' => 'Untersuchungsberichte',
    'death_reports' => 'Todesberichte',
    'birth_reports' => 'Geburtsberichte',
    'operation_reports' => 'Betriebsberichte',
    'medicine_categories' => 'Medizin Kategorien',
    'medicine_brands' => 'Medizinmarken',
    'medicines' => 'Medikamente',
    'cases' => 'Fälle',
    'case_handlers' => 'Fallbearbeiter',
    'bed_types' => 'Betttypen',
    'beds' => 'Betten',
    'bed_assigns' => 'Bett weist zu',
    'packages' => 'Pakete',
    'schedules' => 'Zeitpläne',
    'schedule_label' => 'Zeitplan',
    'services' => 'Dienstleistungen',
    'accounts' => 'Konten',
    'payments' => 'Zahlungen',
    'bills' => 'Rechnungen',
    'employee_payrolls' => 'Mitarbeiterabrechnungen',
    'documents' => 'Unterlagen',
    'document_types' => 'Dokumenttypen',
    'notice_boards' => 'Notiz Bretter',
    'settings' => 'die Einstellungen',
    'doctors_list' => 'Ärzte-Liste',
    'my_payrolls' => 'Meine Gehaltsabrechnungen',
    'blood_banks' => 'Blutbanken',
    'blood_donors' => 'Blutspender',
    'invoices' => 'Rechnungen',
    'patients_cases' => 'Patientenfälle',
    'patients_case_details' => 'Details zum Patientenfall',
    'account_manager' => 'Buchhalter',
    'bed_management' => 'Bettenverwaltung',
    'blood_bank' => 'Blutbank',
    'billing' => 'Abrechnung',
    'case_manager' => 'Fallmanager',
    'cms' => 'CMS',
    'department' => 'Abteilung',
    'departments' => 'Abteilungen',
    'hospital_activities' => 'Krankenhausaktivitäten',
    'advanced_payments' => 'Vorauszahlungen',
    'patient_admissions' => 'Patientenaufnahmen',
    'appointment_calendar' => 'Ernennen. Kalender',
    'bed_mgt' => 'Bettmanagement',
    'reports' => 'Berichte',
    'mail' => 'Mail',
    'enquiries' => 'Anfragen',
    'ambulances' => 'Ambulanzen',
    'ambulance_calls' => 'Krankenwagenanrufe',
    'prescriptions' => 'Rezepte',
    'hospital_charges' => 'Krankenhauskosten',
    'charge_categories' => 'Gebührenkategorien',
    'charges' => 'Gebühren',
    'radiologies' => 'Radiologie',
    'radiology_categories' => 'Radiologie Kategorie',
    'pathologies' => 'Pathologie',
    'pathology_categories' => 'Pathologie-Kategorie',
    'radiology_tests' => 'Radiologische Tests',
    'doctor_opd_charges' => 'Arzt OPD Gebühren',
    'pathology_tests' => 'Pathologie Tests',
    'expenses' => 'Kosten',
    'income' => 'Einkommen',
    'finance' => 'Finanzen',
    'inventory' => 'Inventar',
    'items_categories' => 'Artikel Kategorien',
    'items' => 'Artikel',
    'items_stocks' => 'Artikel Bestände',
    'issued_items' => 'Ausgestellte Artikel',
    'ipd_patients' => 'IPD-Patienten',
    'ipd_opd' => 'IPD/OPD',
    'ipd_diagnosis' => 'Diagnose',
    'ipd_consultant_register' => 'Anleitung des Beraters',
    'ipd_charges' => 'Gebühren',
    'ipd_prescription' => 'Rezepte',
    'ipd_timelines' => 'Zeitleisten',
    'opd_patients' => 'OPD-Patienten',
    'call_logs' => 'Anruflisten',
    'visitors' => 'Besucherinnen',
    'front_office' => 'Postversand',
    'postal_receive' => 'Postempfang',
    'postal_dispatch' => 'Postversand',
    'general' => 'Allgemeines',
    'sidebar_setting' => 'Seitenleisteneinstellungen',
    'testimonials' => 'Referenzen',
    'blood_donations' => 'Blutspenden',
    'blood_issues' => 'Blutprobleme',
    'live_consultations' => 'Live-Konsultationen',
    'vaccinations' => 'Impfungen',
    'vaccinated_patients' => 'Geimpfte Patienten',
    'users' => 'Benutzer',
    'posts' => 'Beiträge',
    'front_settings' => 'Fronteinstellungen',
    'about_us' => 'Über uns',
    'make_an_appointment' => 'Termin vereinbaren',
    'patient_appointment' => 'Patiententermin',
    'old_patient' => 'Alter Patient',
    'new_patient' => 'Neuer Patient',
    'available_slot' => 'Verfügbarer Slot',
    'contact_us' => 'Kontaktieren Sie uns',
    'live_meetings' => 'Live-Meetings',
    'hospital_schedule' => 'Krankenhausplan',
    'impersonate' => 'Imitieren',
    'subscription_plan' => 'Abonnementplan',
    'subscription_days_plan_not_found' => 'Wir konnten keine Abonnements für Tage finden',
    'subscription_month_plan_not_found' => 'Wir konnten keine Monatsabonnements finden',
    'subscription_year_plan_not_found' => 'Wir konnten keine Jahresabonnements finden',
    'subscription_plan_not_found' => 'Abonnementplan nicht gefunden',
    'month' => 'Monat',
    'year' => 'Jahr',
    'day' => 'Tag',
    'view_all' => 'Alle ansehen',
    'hospitals' => 'Krankenhäuser',
    'hospitals_type' => 'Krankenhaustyp',
    'hospital' => 'Krankenhaus',
    'hospital_details' => 'Krankenhausdetails',
    'overview' => 'Abstrakt',
    'billings' => 'Abrechnungen',
    'billing_detail' => 'Rechnungsdetails',
    'our_hospitals' => 'Unsere Krankenhäuser',
    'front_cms_services' => 'Front-CMS-Dienste',
    'hospital_schedules' => 'Hospital Schedules',
    'plan_expire_notifications' => 'Plan Expire Notification (in Days)',
    'facebook_url' => 'Facebook URL',
    'twitter_url' => 'Twitter-URL',
    'instagram_url' => 'Instagram-URL',
    'linkedIn_url' => 'LinkedIn-URL',
    'file_name' => 'Dateiname',
    'short_description' => 'kurze Beschreibung',
    'icon' => 'Symbol',
    'valid' => 'Gültig',
    'paytm' => 'Paytm',
    'appointment_charge' => 'Termingebühr',
    'manual_billing_payments' => 'Manuelle Rechnungszahlungen',
    'faq' => 'FAQ',
    'paid' => 'Bezahlt',
    'unpaid' => 'Unbezahlt',
    'hospital_type' => 'Krankenhaustyp',
    'minutes' => 'Minuten',
    'hours' => 'Stunden',


    'language' => [
        'Arabic' => 'Arabisch',
        'Chinese' => 'Chinesisch',
        'English' => 'Englisch',
        'French' => 'Französisch',
        'German' => 'Deutsch',
        'Portuguese' => 'Portugiesisch',
        'Russian' => 'Russisch',
        'Spanish' => 'Spanisch',
        'Turkish' => 'Türkisch',
    ],
    //POST KEY
    'post' => [
        'name' => 'Name',
        'description' => 'Beschreibung',
        'new_post' => 'Neuer Beitrag',
        'edit_post' => 'Beitrag bearbeiten',
        'post_details' => 'Beitragsdetails',
        'image' => 'Bild',
        'status' => 'Status',
    ],

    'admin_user' => [
        'new_admin' => 'Neuer Administrator',
        'admin_saved_successfully' => 'Admin erfolgreich gespeichert',
        'admin_updated_successfully' => 'Admin erfolgreich aktualisiert',
        'admin_deleted_successfully' => 'Admin erfolgreich gelöscht',
    ],

    //roles
    'role' => [
        'new_role' => 'Neue Rolle',
        'edit_role' => 'Rolle bearbeiten',
        'admin' => 'Administrator',
        'doctor' => 'Arzt',
        'patient' => 'Geduldig',
        'nurse' => 'Krankenschwester',
        'receptionist' => 'Rezeptionist',
        'pharmacist' => 'Apotheker',
        'accountant' => 'Buchhalter',
        'case_manager' => 'Fallmanager',
        'lab_technician' => 'Labortechniker',
    ],

    //filters
    'filter' => [
        'all' => 'Alle',
        'active' => 'Aktiv',
        'deactive' => 'Deaktiv',
        'inactive' => 'Inaktiv',
    ],

    //user keys
    'user' => [
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'name' => 'Name',
        'email' => 'Email',
        'phone' => 'Telefon',
        'designation' => 'Bezeichnung',
        'gender' => 'Geschlecht',
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'qualification' => 'Qualifikation',
        'dob' => 'Geburtsdatum',
        'blood_group' => 'Blutgruppe',
        'select_blood_group' => 'Wählen Sie Blutgruppe',
        'password' => 'Passwort',
        'password_confirmation' => 'Kennwort bestätigen',
        'address1' => 'Adresse 1',
        'address2' => 'Adresse 2',
        'city' => 'Stadt',
        'zip' => 'Postleitzahl',
        'address_details' => 'Adressen Details',
        'address_not_found' => 'Keine Adressdaten gefunden',
        'education' => 'Bildung',
        'status' => 'Status',
        'edit_profile' => 'Profil bearbeiten',
        'change_password' => 'Passwort ändern',
        'logout' => 'Ausloggen',
        'new_user' => 'Neuer Benutzer',
        'edit_user' => 'Benutzer bearbeiten',
        'user_details' => 'Nutzerdetails',
        'email_verified' => 'Email überprüft',
        'email_not_verified' => 'E-Mail nicht bestätigt',
        'back_to_admin' => 'Zurück zu höchster Vorgesetzter',
        'hospital_slug' => 'Krankenhausschnecke',
        'enter_hospital_name' => 'Geben Sie den Krankenhausnamen ein',
        'enter_hospital_slug' => 'Geben Sie Hospital Slug ein',
        'enter_email' => 'Email eingeben',
        'select_donor_name' => 'Spendernamen auswählen',
        'select_patient_name' => 'Patientenname auswählen',
    ],

    //common keys
    'common' => [
        'default_country_code' => 'Standard-Ländercode',
        'profile' => 'Profil',
        'status' => 'Status',
        'action' => 'Aktion',
        'save' => 'speichern',
        'cancel' => 'Stornieren',
        'post_image' => 'Beitragsbild',
        'canceled' => 'Abgesagt',
        'confirm' => 'Bestätigen',
        'back' => 'Zurück',
        'created_on' => 'Erstellt am',
        'updated_on' => 'Aktualisiert am',
        'last_updated' => 'Zuletzt aktualisiert',
        'n/a' => 'N / A',
        'new' => 'Neu',
        'total' => 'Gesamt',
        'add' => 'Hinzufügen',
        'active' => 'Aktiv',
        'deactive' => 'Deaktiviert',
        'name' => 'Name',
        'edit' => 'Bearbeiten',
        'delete' => 'Löschen',
        'view' => 'Aussicht',
        'view_attachment' => 'Anhang ansehen',
        'de_active' => 'Deaktivieren',
        'description' => 'Beschreibung',
        'created_at' => 'Erstellt am',
        'updated_at' => 'Zuletzt aktualisiert',
        'is_available' => 'Ist verfügbar',
        'choose' => 'Wählen',
        'yes' => 'Ja',
        'no' => 'Nein',
        'address' => 'Adresse',
        'export_to_excel' => 'Nach Excel exportieren',
        'reset' => 'Zurücksetzen',
        'actions' => 'Aktionen',
        'search' => 'Suche',
        'no_matching_records_found' => 'Keine übereinstimmenden Aufzeichnungen gefunden',
        'no_data_available' => 'Keine Daten in der Tabelle verfügbar',
        'status_updated_successfully' => 'Status erfolgreich aktualisiert.',
        'saved_successfully' => 'Erfolgreich gespeichert.',
        'updated_successfully' => 'Erfolgreich geupdated',
        'deleted_successfully' => 'Erfolgreich gelöscht',
        'filter_options' => 'Filteroptionen',
        'are_you_sure_want_to_delete_this' => 'Möchten Sie dies wirklich löschen? ',
        'deleted' => 'Gelöscht',
        'has_been_deleted' => 'wurde gelöscht.',
        'cant_be_deleted' => 'kann nicht gelöscht werden',
        'ok' => 'OK',
        'custom' => 'Brauch',
        'apply' => 'anwenden',
        'from' => 'aus',
        'to' => 'Zu',
        'invalid_number' => 'Ungültige Nummer',
        'invalid_country_code' => 'Ungültiger Ländercode',
        'too_short' => 'Zu kurz',
        'too_long' => 'Zu lang',
        'undefined' => 'nicht definiert',
        'not_found' => 'nicht gefunden',
        'select_status' => 'Staat wählen',
        'showing' => 'Show',
        'of' => 'von',
        'results' => 'Ergebnis',
        'show' => 'Programm',
        'previous' => 'Vorherige',
        'next' => 'Nächste',
        'allow_img_text' => ' Erlaubte Dateitypen: png, jpg, jpeg, svg. ',
        'default_plan' => 'Standardplan',
        'select_type' => 'Art auswählen',
        'select_type_number' => 'Wähle ein Modell',
        'this_action_is_not_allowed_for_default_record' => 'Diese Aktion ist für den Standarddatensatz nicht zulässig.',
        'please_enter_valid_facebook_url' => 'Bitte geben Sie eine gültige Facebook-URL ein.',
        'please_enter_valid_twitter_url' => 'Bitte geben Sie eine gültige Twitter-URL ein.',
        'please_enter_valid_linkedin_url' => 'Bitte geben Sie eine gültige LinkedIn-URL ein.',
        'please_enter_valid_Instagram_url' => 'Bitte geben Sie eine gültige Instagram-URL ein',
        'select_payment' => 'Wählen Sie Zahlungsstatus aus',
        'logged_in_successfully' => 'Erfolgreich eingeloggt.',
        'logout_successfully' => 'Abmelden erfolgreich.',
        'we_have_your_password_resetk_link' => 'Wir haben Ihren Link zum Zurücksetzen Ihres Passworts per E-Mail verschickt!',
        'we_cant_find_user' => 'Wir können keinen Benutzer mit dieser E-Mail-Adresse finden',
        'this_password_reset_token_is_invalid' => 'Dieses Passwort-Reset-Token ist ungültig',
        'password_reset_successfully' => 'Passwort erfolgreich zurückgesetzt',
        'please_enter_correct_old_password' => 'Bitte geben Sie das korrekte alte Passwort ein',
        'password_updated' => 'Ihr Passwort wurde erfolgreich aktualisiert.',
        'doctor_scheduled' => 'Arzttermin vereinbart',
        'patient_registered_successfully' => 'Der Patient wurde erfolgreich registriert',
        'appointment_confirmed_successfully' => 'Termin erfolgreich bestätigt',
        'bed_assigned_successfully' => 'Bett erfolgreich zugewiesen',
        'username_and_password_required' => 'Benutzername und Passwort erforderlich',
        'meeting_finished_or_cancelled' => 'Diese Besprechung ist beendet oder abgesagt',
        'something_want_wrong' => 'Etwas ist schief gelaufen',
        'invalid_username_password' => 'ungültiger Benutzername oder Passwort',
        'appointment_transaction' => 'Termintransaktion',
        'no_data_found' => 'Keine Daten gefunden',
        'is_already_exists' => 'Ist bereits vorhanden.',
        'close' => 'Schließen',
    ],

    'months' => [
        'jan' => 'Januar',
        'feb' => 'Februar',
        'mar' => 'Marsch',
        'apr' => 'April',
        'may' => 'Kann',
        'jun' => 'Juni',
        'jul' => 'Juli',
        'aug' => 'August',
        'sep' => 'September',
        'oct' => 'Oktober',
        'nov' => 'November',
        'dec' => 'Dezember',
    ],

    'weekdays' => [
        'sun' => 'SONNE',
        'mon' => 'MO',
        'tue' => 'DI',
        'wed' => 'HEIRATEN',
        'thu' => 'DO',
        'fri' => 'FR',
        'sat' => 'SA',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'Rezeptionistin',
        'receptionists' => 'Rezeptionistinnen',
        'receptionist_details' => 'Details zur Rezeption',
        'new_receptionist' => 'Neue Rezeptionistin',
        'edit_receptionist' => 'Empfangsdame bearbeiten',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'Versicherung',
        'insurances' => 'Versicherungen',
        'insurance_details' => 'Versicherungsdetails',
        'new_insurance' => 'Neue Versicherung',
        'edit_insurance' => 'Versicherung bearbeiten',
        'service_tax' => 'Servicesteuer',
        'insurance_no' => 'Versicherung Nr',
        'insurance_code' => 'Versicherungscode',
        'hospital_rate' => 'Krankenhauspreis',
        'discount' => 'Rabatt',
        'remark' => 'Anmerkung',
        'disease_details' => 'Krankheitsdetails',
        'diseases_name' => 'Name der Krankheit',
        'diseases_charge' => 'Krankheitsgebühr',
        'total_amount' => 'Gesamtmenge',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'Arztabteilungen',
        'doctor_department' => 'Arztabteilung',
        'doctor_department_details' => 'Details der Arztabteilung',
        'new_doctor_department' => 'Neue Arztabteilung',
        'edit_doctor_department' => 'Arztabteilung bearbeiten',
        'title' => 'Titel',
        'description' => 'Beschreibung',
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'Untersuchungsberichte',
        'investigation_report' => 'Untersuchungsbericht',
        'new_investigation_report' => 'Neuer Untersuchungsbericht',
        'investigation_report_details' => 'Untersuchungsbericht Details',
        'edit_investigation_report' => 'Untersuchungsbericht bearbeiten',
        'patient' => 'Geduldig',
        'date' => 'Datum',
        'title' => 'Titel',
        'doctor' => 'Ärztin',
        'description' => 'Beschreibung',
        'attachment' => 'Anhang',
        'solved' => 'Gelöst',
        'not_solved' => 'Nicht gelöst',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'Neuer Apotheker',
        'edit_pharmacist' => 'Apotheker bearbeiten',
        'pharmacists' => 'Apothekerinnen',
        'pharmacist_details' => 'Apotheker Details',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'Todesbericht',
        'death_reports' => 'Todesberichte',
        'new_death_report' => 'Neuer Todesbericht',
        'edit_death_report' => 'Todesbericht bearbeiten',
        'death_report_details' => 'Details zum Todesbericht',
        'patient_name' => 'Patientenname',
        'case_id' => 'Fall-ID',
        'doctor_name' => 'Name des Arztes',
        'date' => 'Datum',
        'description' => 'Beschreibung',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'Geburtsbericht',
        'birth_reports' => 'Geburtsberichte',
        'birth_report_details' => 'Geburtsbericht Details',
        'new_birth_report' => 'Neuer Geburtsbericht',
        'edit_birth_report' => 'Geburtsbericht bearbeiten',
        'patient_name' => 'Patientenname',
        'case_id' => 'Fall-ID',
        'doctor_name' => 'Name des Arztes',
        'date' => 'Datum',
        'description' => 'Beschreibung',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'Neuer Buchhalter',
        'edit_accountant' => 'Buchhalter bearbeiten',
        'accountants' => 'Buchhalterinnen',
        'accountant_details' => 'Buchhalter Details',
        'credit' => 'Anerkennung',
        'debit' => 'Lastschrift',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'Mitarbeiterabrechnung',
        'employee_payrolls' => 'Mitarbeiterabrechnungen',
        'employee_payroll_details' => 'Angaben zur Mitarbeiterabrechnung',
        'new_employee_payroll' => 'Neue Mitarbeiterabrechnung',
        'edit_employee_payroll' => 'Mitarbeiterabrechnung bearbeiten',
        'sr_no' => 'Sr. Nr',
        'payroll_id' => 'Gehaltsabrechnungs-ID',
        'month' => 'Monat',
        'year' => 'Jahr',
        'role' => 'Rolle',
        'employee' => 'Mitarbeiterin',
        'basic_salary' => 'Grundgehalt',
        'allowance' => 'Beihilfe',
        'deductions' => 'Abzüge',
        'net_salary' => 'Nettogehalt',
        'paid' => 'Bezahlt',
        'not_paid' => 'Nicht bezahlt',
        'unpaid' => 'Unbezahlt',
        'employee_name' => 'Mitarbeitername',
        'select_employee' => 'Wählen Sie Mitarbeiter aus',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'Betriebsbericht',
        'operation_reports' => 'Betriebsberichte',
        'operation_report_details' => 'Details zum Betriebsbericht',
        'new_operation_report' => 'Neuer Betriebsbericht',
        'edit_operation_report' => 'Betriebsbericht bearbeiten',
        'patient_name' => 'Patientenname',
        'case_id' => 'Fall-ID',
        'doctor_name' => 'Name des Arztes',
        'date' => 'Datum',
        'description' => 'Beschreibung',
    ],

    // accounts keys
    'account' => [
        'account' => 'Konto',
        'accounts' => 'Konten',
        'account_details' => 'Kontodetails',
        'new_account' => 'Neues Konto',
        'edit_account' => 'Konto bearbeiten',
        'name' => 'Name',
        'description' => 'Beschreibung',
        'type' => 'Art',
        'status' => 'Status',
        'payments' => 'Zahlungen',
    ],

    // invoices keys
    'invoice' => [
        'send_mail' => 'E-Mail senden',
        'invoice_id' => 'Rechnungs-ID',
        'invoice' => 'Rechnung',
        'invoices' => 'Rechnungen',
        'invoice_details' => 'Rechnungs-Details',
        'new_invoice' => 'Neue Rechnung',
        'edit_invoice' => 'Rechnung bearbeiten',
        'patient' => 'Geduldig',
        'invoice_date' => 'Rechnungsdatum',
        'amount' => 'Menge',
        'patient_id' => 'Patienten ID',
        'discount' => 'Rabatt',
        'account_name' => 'Kontobezeichnung',
        'description' => 'Beschreibung',
        'qty' => 'Menge',
        'price' => 'Preis',
        'add' => 'Hinzufügen',
        'sub_total' => 'Zwischensumme',
        'total' => 'Gesamtmenge',
        'edit' => 'Bearbeiten',
        'hospital_address' => 'Krankenhausadresse',
        'paid' => 'Bezahlt',
        'not_paid' => 'Nicht bezahlt',
        'print_invoice' => 'Rechnung drucken',
    ],

    //nurses
    'nurse' => [
        'new_nurse' => 'Neue Krankenschwester',
        'edit_nurse' => 'Krankenschwester bearbeiten',
        'nurse_details' => 'Krankenschwester Details',
        'phone_no' => 'Telefonnummer',
        'birth_date' => 'Geburtsdatum',
        'choose' => 'Wählen',
    ],

    //patient
    'patient' => [
        'new_patient' => 'Neuer Patient',
        'edit_patient' => 'Patient bearbeiten',
        'patient_details' => 'Patientendetails',
        'total_cases' => 'Fälle insgesamt',
        'total_admissions' => 'Gesamtzulassungen',
        'total_appointments' => 'Termine insgesamt',
    ],

    // payments keys
    'payment' => [
        'payment' => 'Zahlung',
        'payments' => 'Zahlungen',
        'payment_details' => 'Zahlungsdetails',
        'new_payment' => 'Neue Zahlung',
        'edit_payment' => 'Zahlung bearbeiten',
        'account_name' => 'Kontobezeichnung',
        'payment_date' => 'Zahlungsdatum',
        'pay_to' => 'Zahlen an',
        'amount' => 'Menge',
        'account' => 'Konto',
        'description' => 'Beschreibung',
        'payment_reports' => 'Zahlungsberichte',
        'your_payment_is_successfully_completed' => 'Ihre Zahlung wurde erfolgreich abgeschlossen',
        'payment_failed' => 'Entschuldigung! Die Zahlung ist fehlgeschlagen. Versuchen Sie es nach einiger Zeit erneut',
    ],

    //    transaction filter
    'transaction_filter' => [
        'manual' => 'Manual',
        'razorpay' => 'Razorpay',
        'paypal' => 'Paypal',
        'stripe' => 'Stripe',
        'paystack' => 'PayStack',
        'paytm' => 'Paytm',
        'cash' => 'Cash',
        'cheque' => 'Cheque',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'Vorauszahlung',
        'advanced_payments' => 'Vorauszahlungen',
        'advanced_payment_details' => 'Vorauszahlungsdetails',
        'new_advanced_payment' => 'Neue Vorauszahlung',
        'edit_advanced_payment' => 'Vorauszahlung bearbeiten',
        'patient' => 'Geduldig',
        'receipt_no' => 'Quittungsnr',
        'amount' => 'Menge',
        'date' => 'Datum',
        'patient_name' => 'Patientenname',
    ],

    // beds keys
    'bed' => [
        'bed' => 'Neues Bett',
        'beds' => 'Betten',
        'bed_details' => 'Bettdetails',
        'new_bed' => 'Neues Bett',
        'edit_bed' => 'Bett bearbeiten',
        'new_bulk_bed' => 'Neues Großbett',
        'name' => 'Name',
        'bed_type' => 'Betttyp',
        'charge' => 'Aufladen',
        'available' => 'Verfügbar',
        'not_available' => 'Nicht verfügbar',
        'description' => 'Beschreibung',
        'add' => 'Hinzufügen',
        'bed_id' => 'Bett Id',
        'select_bed_type' => 'Betttyp auswählen',
        'select_bed' => 'Bett auswählen',
        'choose_bed' => 'Bett auswählen',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'Betttyp',
        'bed_types' => 'Betttypen',
        'bed_type_details' => 'Betttyp Details',
        'new_bed_type' => 'Neuer Betttyp',
        'edit_bed_type' => 'Betttyp bearbeiten',
        'title' => 'Titel',
        'description' => 'Beschreibung',
    ],

    'doctor' => [
        'new_doctor' => 'Neuer Doktor',
        'edit_doctor' => 'Doktor bearbeiten',
        'doctor_details' => 'Arzt Details',
        'specialist' => 'Spezialistin',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'Bett zuweisen',
        'bed_assigns' => 'Bett weist zu',
        'bed_assign_details' => 'Bed Assign Details',
        'new_bed_assign' => 'Neues Bett zuweisen',
        'edit_bed_assign' => 'Bett zuweisen zuweisen',
        'patient_name' => 'Patientenname',
        'bed_name' => 'Bettname',
        'case_id' => 'Fall-ID',
        'assign_date' => 'Datum zuweisen',
        'discharge_date' => 'Entlassungsdatum',
        'bed' => 'Bett',
        'description' => 'Beschreibung',
        'assigned' => 'Zugewiesen',
        'not_assigned' => 'Nicht zugeordnet',
        'ipd_patient_id' => 'IPD-Patienten-ID',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'Das Datum der Bettenzuweisung sollte nicht kleiner sein als das Geburtsdatum des Patienten.',
    ],

    // packages keys
    'package' => [
        'package' => 'Paket',
        'packages' => 'Pakete',
        'package_details' => 'Paketdetails',
        'new_package' => 'Neues Paket',
        'edit_package' => 'Paket bearbeiten',
        'name' => 'Name',
        'description' => 'Beschreibung',
        'discount' => 'Rabatt',
        'total_amount' => 'Gesamtmenge',
        'service' => 'Bedienung',
        'qty' => 'Menge',
        'rate' => 'Bewertung',
        'amount' => 'Menge',
        'select_service' => 'Wählen Sie Service',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'Rechnung drucken',
        'bill_id' => 'Regnings id',
        'bill' => 'Rechnung',
        'bills' => 'Rechnungen',
        'bill_details' => 'Rechnungsdetails',
        'new_bill' => 'Neue Rechnung',
        'edit_bill' => 'Rechnung bearbeiten',
        'patient' => 'Geduldig',
        'bill_date' => 'Rechnungsdatum',
        'amount' => 'Menge',
        'admission_id' => 'Zulassungsausweis',
        'patient_name' => 'Patientenname',
        'patient_email' => 'Patienten-E-Mail',
        'patient_cell_no' => 'Patientenzelle Nr',
        'patient_gender' => 'Geschlecht des Patienten',
        'patient_dob' => 'Patienten DOB',
        'doctor_name' => 'Name des Arztes',
        'admission_date' => 'Aufnahmedatum',
        'discharge_date' => 'Entlassungsdatum',
        'package_name' => 'Paketnamen',
        'insurance_name' => 'Versicherungsname',
        'total_days' => 'Die Summe an Tagen',
        'policy_no' => 'Richtlinie Nr',
        'item_name' => 'Artikelname',
        'qty' => 'Menge',
        'price' => 'Preis',
        'add' => 'Hinzufügen',
        'total_amount' => 'Gesamtmenge',
        'edit' => 'Bearbeiten',
        'cell_no' => 'Zelle Nr',
        'bill_summary' => 'Rechnungszusammenfassung',
        'generate_bill' => 'Rechnung erstellen',
        'update_bill' => 'Rechnung aktualisieren',
        'calculate' => 'Berechnung',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'Blutspender',
        'blood_donors' => 'Blutspender',
        'blood_donor_details' => 'Blutspender Details',
        'new_blood_donor' => 'Neuer Blutspender',
        'edit_blood_donor' => 'Blutspender bearbeiten',
        'name' => 'Name',
        'age' => 'Alter',
        'gender' => 'Geschlecht',
        'blood_group' => 'Blutgruppe',
        'donation_date' => 'Spendendatum',
        'last_donation_date' => 'Letztes Spendendatum',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'Blutbank',
        'blood_banks' => 'Blutbanken',
        'blood_bank_details' => 'Details zur Blutbank',
        'new_blood_group' => 'Neue Blutgruppe',
        'edit_blood_group' => 'Blutgruppe bearbeiten',
        'blood_group' => 'Blutgruppe',
        'remained_bags' => 'Verbleibende Taschen',
    ],

    //Case
    'case' => [
        'case' => 'Fall',
        'case_date' => 'Falldatum',
        'new_case' => 'Neuer Fall',
        'edit_case' => 'Fall bearbeiten',
        'case_details' => 'Falldetails',
        'phone' => 'Telefon',
        'fee' => 'Gebühr',
        'patient' => 'Geduldig',
        'doctor' => 'Ärztin',
        'case_id' => 'Fall-ID',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'select_case' => 'Fall auswählen',
    ],

    //services
    'service' => [
        'new_service' => 'Neuer Service',
        'edit_service' => 'Service bearbeiten',
        'service_details' => 'Servicedetails',
        'quantity' => 'Menge',
        'rate' => 'Bewertung',
        'given' => 'Gegeben',
        'not_given' => 'Nicht angegeben',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'Neuer Termin',
        'edit_appointment' => 'Termin bearbeiten',
        'appointment_details' => 'Termindetails',
        'calendar_view' => 'Kalenderansicht',
        'patient_name' => 'Patientenname',
        'doctor_name' => 'Name des Arztes',
        'department_name' => 'Abteilungsname',
        'date' => 'Datum',
        'doctor_department' => 'Arztabteilung',
        'doctor_department_name' => 'Name der Arztabteilung',
        'doctor' => 'Ärztin',
        'description' => 'Beschreibung',
        'patient' => 'Geduldig',
        'appointment_calendar' => 'Terminkalender',
        'appointment_list' => 'Terminliste',
        'completed' => 'Abgeschlossen',
        'pending' => 'steht aus',
        'available_slot' => 'Verfügbarer Slot',
        'no_available' => 'Nicht verfügbar',
        'today' => 'Heute',
        'month' => 'Monat',
        'week' => 'Woche',
        'day' => 'Tag',
        'opd_date' => 'Opd-Datum',
        'yesterday' => 'Gestern',
        'this_week' => 'In dieser Woche',
        'last_7_days' => 'Letzten 7 Tage',
        'last_30_days' => 'Letzte 30 Tage',
        'this_month' => 'Diesen Monat',
        'last_month' => 'Im vergangenen Monat',
        'custom' => 'Brauch',
        'start_date' => 'Startdatum',
        'end_date' => 'Enddatum',
        'change_status' => 'Status ändern',
        'are_you_sure_want_to_change' => 'Möchten Sie wirklich wechseln?',
        'changed_appointment' => 'Termin geändert',
        'has_been_changed' => 'wurde geändert.',
        'are_you_sure_want_to_cancel' => 'Sind Sie sicher, dass sie abbrechen wollen',
        'has_been_cancelled' => 'wurde abgebrochen.',
        'please_select_doctor' => 'Bitte Arzt auswählen',
        'doctor_schedule_not_available_on_this_date' => 'Arztplan an diesem Datum nicht verfügbar.',
        'patient_not_exists_or_status_is_not_active' => 'Patient existiert nicht oder Status ist nicht aktiv.',
        'please_select_appointment_time_slot' => 'Bitte wählen Sie den Termintermin aus',
        'time' => 'Zeit',
    ],

    'case_handler' => [
        'new_case_handler' => 'Neuer Case Handler',
        'edit_case_handler' => 'Fallbearbeiter bearbeiten',
        'case_handler_detail' => 'Details zur Fallbearbeitung',
    ],

    'lab_tech' => [
        'new_lab_tech' => 'Neuer Labortechniker',
        'edit_lab_tech' => 'Labortechniker bearbeiten',
        'lab_tech_detail' => 'Details zum Labortechniker',
    ],

    'doc_type' => [
        'new_doc_type' => 'Neuer Dokumenttyp',
        'edit_doc_type' => 'Dokumenttyp bearbeiten',
        'name' => 'Name',
    ],

    'document' => [
        'document' => 'Dokumentieren',
        'new_document' => 'Neues Dokument',
        'edit_document' => 'Dokument bearbeiten',
        'title' => 'Titel',
        'document_type' => 'Dokumentenart',
        'document_type_details' => 'Dokumenttypdetails',
        'patient' => 'Geduldig',
        'download' => 'Herunterladen',
        'select_patient' => 'Wählen Sie Patient',
        'select_document_type' => 'Wählen Sie Dokumenttyp',
        'document_detail' => 'Dokumentdetails',
        'notes' => 'Anmerkungen',
        'attachment' => 'Anhang',
        'select_account' => 'Konto auswählen',
        'in_percentage' => 'Prozentsatz',
        'select_admission_id' => 'Registrierungsnummer auswählen',
        'change_attachment' => 'Anhang ändern',
        'document_file_size' => 'Das Dokument muss folgende Dateitypen haben: jpeg, jpg, png, pdf, doc, docx., mp3, mp4',
        'uploaded_by' => 'Hochgeladen von',
    ],

    'patient_admission' => [
        'patient_admission' => 'Patientenaufnahme',
        'new_patient_admission' => 'Neue Patientenaufnahme',
        'edit_patient_admission' => 'Patientenaufnahme bearbeiten',
        'details' => 'Details zur Patientenaufnahme',
        'patient' => 'Geduldig',
        'patient_name' => 'Patientenname',
        'doctor' => 'Ärztin',
        'doctor_name' => 'Name des Arztes',
        'admission_date' => 'Aufnahmedatum',
        'discharge_date' => 'Entlassungsdatum',
        'package' => 'Paket',
        'package_name' => 'Paketnamen',
        'insurance' => 'Versicherung',
        'insurance_name' => 'Versicherungsname',
        'policy_no' => 'Richtlinie Nr',
        'bed' => 'Bett',
        'agent_name' => 'Agentenname',
        'guardian_name' => 'Name des Wächters',
        'guardian_relation' => 'Wächterbeziehung',
        'guardian_contact' => 'Guardian Kontakt',
        'guardian_address' => 'Wächteradresse',
        'patient_admission_id' => 'ID der Patientenaufnahme',
        'select_package' => 'Paket auswählen',
        'select_insurance' => 'Versicherung auswählen',
    ],

    'setting' => [
        'paystack' => 'Gehaltsstapel',
        'paystack_public_key' => 'Öffentlicher Gehaltsstapel-Schlüssel',
        'paystack_secret_key' => 'Gehaltsstapel-Geheimschlüssel',
        'paytm' => 'Paytm',
        'paytm_merchant_id' => 'Paytm-Händler-ID',
        'paytm_merchant_key' => 'Paytm-Händlerschlüssel',
        'app_name' => 'App Name',
        'company_name' => 'Firmenname',
        'app_logo' => 'App Logo',
        'currency' => 'Aktuelle Währung',
        'address' => 'Krankenhausadresse',
        'hospital_email' => 'Krankenhaus-E-Mail',
        'hospital_phone' => 'Telefon des Krankenhauses',
        'hospital_from_day' => 'Krankenhaus von Tag',
        'hospital_from_time' => 'Krankenhaus von Zeit',
        'about_us' => 'Über uns',
        'image_validation' => 'Das Bild muss 90 x 60 Pixel groß sein.',
        'favicon' => 'Favicon',
        'favicon_validation' => 'Das Bild muss 34 x 34 Pixel groß sein.',
        'social_details' => 'Soziale Details',
        'enable_google_reCAPTCHA' => 'Google reCAPTCHA aktivieren',
        'change_logo' => 'Logo ändern',
        'change_favicon' => 'Favicon ändern',
        'stripe' => 'Streifen',
        'stripe_key' => 'Stripe-Schlüssel',
        'stripe_secret' => 'Stripe-Geheimnis',
        'paypal_secret' => 'Paypal-Geheimnis',
        'paypal_client_id' => 'Paypal-Kunden-ID',
        'paypal_mode' => 'Paypal-Modus',
        'paypal' => 'Paypal',
        'paypal_key' => 'Paypal-Schlüssel',
        'razorpay_key' => 'Razorpay-Schlüssel',
        'razorpay_secret' => 'Razorpay-Geheimnis',
        'razorpay' => 'Razorpay',
        'payment_gateway' => 'Zahlungs-Gateways',
    ],

    'currency' => [
        'currencies' => 'Währungen',
        'new_currency' => 'Neue Währung',
        'edit_currency' => 'Währung bearbeiten',
        'currency_name' => 'Währungsname',
        'currency_code' => 'Währungscode',
        'currency_icon' => 'Währungssymbol',
        'add_currency_code_as_per_three_letter_iso_code' => 'Fügen Sie den Währungscode gemäß dem dreistelligen ISO-Code hinzu',
        'you_can_find_out_here' => 'das erfährst du hier',
    ],

    'schedule' => [
        'new' => 'Neue Terminplanung',
        'edit' => 'Zeitplan bearbeiten',
        'details' => 'Zeitplandetails',
        'doctor_name' => 'Name des Arztes',
        'select_doctor_name' => 'Wählen Sie den Namen des Arztes',
        'per_patient_time' => 'Pro Patientenzeit',
        'serial_visibility' => 'Serielle Sichtbarkeit',
        'select_serial_visibility' => 'Wählen Sie Serielle Sichtbarkeit',
        'available_on' => 'Verfügbar auf',
        'available_from' => 'Verfügbar ab',
        'available_to' => 'Verfügbar für',
        'sequential' => 'Sequentiell',
        'timestamp' => 'Zeitstempel',
    ],

    'notice_board' => [
        'new' => 'Neues Schwarzes Brett',
        'edit' => 'Anschlagtafel bearbeiten',
        'details' => 'Anschlagtafel Details',
        'title' => 'Titel',
        'description' => 'Beschreibung',
        'created_at' => 'hergestellt in',
    ],

    'my_payroll' => [
        'my_payrolls' => 'Meine Gehaltsabrechnungen',
        'basic_salary' => 'Grundgehalt',
        'allowance' => 'Beihilfe',
        'deductions' => 'Abzüge',
        'net_salary' => 'Nettogehalt',
    ],

    'medicine' => [
        'medicine' => 'Medizin',
        'medicine_category' => 'Medizin Kategorie',
        'medicine_category_details' => 'Details zur Medikamentenkategorie',
        'medicines' => 'Medikamente',
        'medicine_details' => 'Medizin Details',
        'new_medicine' => 'Neue Medizin',
        'new_medicine_category' => 'Neue Medizin Kategorie',
        'edit_medicine_category' => 'Kategorie Medizin bearbeiten',
        'edit_medicine' => 'Medizin bearbeiten',
        'name' => 'Name',
        'brand' => 'Marke',
        'selling_price' => 'Verkaufspreis',
        'buying_price' => 'Kaufpreis',
        'category' => 'Kategorie',
        'salt_composition' => 'Salzzusammensetzung',
        'side_effects' => 'Nebenwirkungen',
        'description' => 'Beschreibung',
        'category_id' => 'Kategorie ID',
        'brand_name' => 'Markenname',
        'medicine_brands_details' => 'Details zur Medizinmarke',
        'new_brand' => 'Neue Marke',
        'new_medicine_brand' => 'Neue Medizinmarke',
        'edit_medicine_brand' => 'Medizinmarke bearbeiten',
        'medicine_brands' => 'Arzneimittelmarken',
        'select_category' => 'Kategorie wählen',
        'select_brand' => 'Marke auswählen',
        'is_active' => 'aktiv',
    ],

    'profile' => [
        'change_language' => 'Sprache ändern',
        'language' => 'Sprache',
        'edit_profile' => 'Profil bearbeiten',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'email' => 'Email',
        'phone' => 'Telefon',
        'profile' => 'Profil',
        'change_Profile' => 'Konfigurationsdatei ändern',
        'full_name' => 'vollständiger Name',
        'type' => 'Typ',
    ],

    'dashboard' => [
        'dashboard' => 'Instrumententafel',
        'total_invoices' => 'Rechnungsbetrag',
        'total_bills' => 'Rechnungsbetrag',
        'total_payments' => 'Zahlungsbetrag',
        'total_advance_payments' => 'Vorauszahlungsbetrag',
        'notice_boards' => 'Notiz Bretter',
        'title' => 'Titel',
        'doctors' => 'Ärztinnen',
        'available_beds' => 'Verfügbare Betten',
        'patients' => 'Patientinnen',
        'income_and_expense_report' => 'Einnahmen- und Ausgabenbericht',
        'income_and_expense_reports' => 'Einnahmen- und Ausgabenberichte',
        'no_enquiries_yet' => 'Noch keine Anfragen',
        'no_notice_yet' => 'Noch keine Ankündigung',
        'total_hospitals' => 'Krankenhäuser insgesamt',
        'total_subscription_plans' => 'Abonnementpläne insgesamt',
        'total_subscribers' => 'Abonnenten insgesamt',
        'total_enquiries' => 'Anfragen insgesamt',
        'total_revenue' => 'Gesamtumsatz',
        'total_active_hospital_plan' => 'Gesamte aktive Krankenhauspläne',
        'total_expired_hospital_plan' => 'Insgesamt abgelaufene Krankenhauspläne',
        'income_report' => 'Einkommensübersicht',
        'please_select_rang_picker' => 'Bitte Rang Picker auswählen',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'Name',
        'email' => 'Email',
        'contact' => 'Kontakt',
        'type' => 'Art',
        'message' => 'Botschaft',
        'viewed_by' => 'Gesehen von',
        'enquiry_details' => 'Anfragedetails',
        'read' => 'Lesen',
        'unread' => 'Ungelesen',
        'not_viewed' => 'Nicht angezeigt',
        'received_on' => 'Eingegangen am',
        'send_enquiry' => 'Anfrage absenden',
        'general_enquiry' => 'Allgemeine Anfrage',
        'residential_care' => 'Wohnen und Pflege',
        'feedback/suggestions' => 'Feedback / Vorschläge',

    ],

    'email' => [
        'to' => 'Zu',
        'subject' => 'Gegenstand',
        'message' => 'Botschaft',
        'attachment' => 'Anhänge',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'Krankenwagen',
        'ambulances' => 'Ambulanzen',
        'ambulance_details' => 'Krankenwagen Details',
        'vehicle_number' => 'Fahrzeugnummer',
        'vehicle_model' => 'Fahrzeugmodell',
        'year_made' => 'Jahr gemacht',
        'driver_name' => 'Fahrername',
        'driver_license' => 'Führerschein',
        'driver_contact' => 'Fahrerkontakt',
        'note' => 'Note',
        'vehicle_type' => 'Fahrzeugtyp',
        'is_available' => 'Ist verfügbar',
        'new_ambulance' => 'Neuer Krankenwagen',
        'edit_ambulance' => 'Krankenwagen bearbeiten',
        'select_ambulance' => 'Wählen Sie ein Krankenwagen',
        'owned' => 'Besitz',
        'contractual' => 'Vertraglich',


    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'Krankenwagenanruf',
        'ambulance_calls' => 'Krankenwagenanrufe',
        'ambulance_call_details' => 'Details zum Krankenwagenanruf',
        'vehicle_model' => 'Fahrzeugmodell',
        'patient' => 'Geduldig',
        'driver_name' => 'Fahrername',
        'date' => 'Datum',
        'amount' => 'Menge',
        'new_ambulance_call' => 'Neuer Krankenwagenanruf',
        'edit_ambulance_call' => 'Krankenwagenanruf bearbeiten',
        'select_ambulance' => 'Krankenwagen auswählen',
    ],

    // prescription keys
    'prescription' => [
        'prescription' => 'Rezept',
        'prescriptions' => 'Rezepte',
        'prescription_details' => 'Rezeptdetails',
        'new_prescription' => 'Neues Rezept',
        'edit_prescription' => 'Rezept bearbeiten',
        'patient' => 'Geduldig',
        'doctor' => 'Arzt',
        'food_allergies' => 'Essensallergien',
        'tendency_bleed' => 'Tendenz bluten',
        'heart_disease' => 'Herzkrankheit',
        'high_blood_pressure' => 'Bluthochdruck',
        'diabetic' => 'Diabetikerin',
        'surgery' => 'Chirurgie',
        'accident' => 'Unfall',
        'others' => 'Andere',
        'medical_history' => 'Krankengeschichte',
        'current_medication' => 'Derzeitige Medikamente',
        'female_pregnancy' => 'Weibliche Schwangerschaft',
        'breast_feeding' => 'Stillen',
        'health_insurance' => 'Krankenversicherung',
        'low_income' => 'Niedriges Einkommen',
        'reference' => 'Referenz',
        'physical_information' => 'physikalische Informationen',
        'new_medicine' => 'neue Medizin',
        'plus_rate' => 'Impuls Tarif',
        'temperature' => 'Temperatur',
        'problem_description' => 'Problembeschreibung',
        'test' => 'Prüfung',
        'advice' => 'Rat',
        'next_visit' => 'nächster Besuch',
        'time' => 'Zeit',
        'comment' => 'Kommentar',
        'problem' => 'Problem',
        'rx' => 'Empfang',
        'medicine_name' => 'Medizinname',
        'duration' => 'Dauer',
        'days' => 'Tage',
        'after_meal' => 'Nach dem Essen',
        'before_meal' => 'Vor dem Essen',
        'fill_physical_information' => 'Geben Sie alle Details zu physischen Informationen ein',
        'data_retrive_from_openai' => 'Daten erfolgreich von OpenAI abrufen',
    ],

    'charge_category' => [
        'charge_categories' => 'Gebührenkategorien',
        'new_charge_category' => 'Neue Gebührenkategorie',
        'edit_charge_category' => 'Gebührenkategorie bearbeiten',
        'charge_type' => 'Ladungsart',
        'charge_category_details' => 'Details zur Gebührenkategorie',
        'select_charge_type' => 'Kategorietyp auswählen',
    ],

    //    charge filter
    'charge_filter' => [
        'investigation' => 'Ermittlung',
        'procedure' => 'Verfahren',
        'supplier' => 'Anbieter',
        'operation_theater' => 'Operationstheater',
        'others' => 'Andere',
    ],

    'charge' => [
        'new_charge' => 'Neue Gebühr',
        'edit_charge' => 'Gebühr bearbeiten',
        'charge_details' => 'Gebührendetails',
        'charge_category' => 'Gebührenkategorie',
        'standard_charge' => 'Normaltarif',
        'code' => 'Code',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'Name',
        'radiology_categories' => 'Neu',
        'new_radiology_category' => 'Neu Radiologie Kategorie',
        'edit_radiology_category' => 'Bearbeiten Radiologie Kategorie',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'Pathologiekategorien',
        'new_pathology_category' => 'Neue Pathologiekategorie',
        'edit_pathology_category' => 'Pathologiekategorie bearbeiten',
        'name' => 'Name',
        'select_charge_category' => 'Gebührenkategorie wählen',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'Radiologische Tests',
        'new_radiology_test' => 'Neuer Radiologietest',
        'edit_radiology_test' => 'Radiologie-Test bearbeiten',
        'radiology_test_details' => 'Details zum Radiologietest',
        'test_name' => 'Prüfung Name',
        'short_name' => 'Kurz Name',
        'test_type' => 'Prüfung Art',
        'category_name' => 'Kategoriename',
        'subcategory' => 'Unterkategorie',
        'report_days' => 'Tage melden',
        'charge_category' => 'Gebührenkategorie',
        'standard_charge' => 'Normaltarif',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'new_doctor_opd_charge' => 'Neue Doktor-OPD-Gebühr',
        'edit_doctor_opd_charge' => 'Bearbeiten Sie die OPD-Gebühr für den Arzt',
        'new_opd_charge' => 'Neue OPD Gebühr',
        'doctor_name' => 'Name des Arztes',
        'standard_charge' => 'Arzt-OPD-Gebühr',
        'doctor' => 'Arzt',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'Pathologie Tests',
        'new_pathology_test' => 'Neu Pathologie Prüfung',
        'edit_pathology_test' => 'Bearbeiten Pathologie Prüfung',
        'pathology_test_details' => 'Pathologie Prüfung Details',
        'test_name' => 'Prüfung Name',
        'short_name' => 'Kurz Name',
        'test_type' => 'Prüfung Art',
        'category_name' => 'Kategorie Name',
        'unit' => 'Einheit',
        'subcategory' => 'Unterkategorie',
        'method' => 'Methode',
        'report_days' => 'Tage melden',
        'charge_category' => 'Gebührenkategorie',
        'standard_charge' => 'Normaltarif',

    ],

    //    expense filter
    'expense_filter' => [
        'building_rent' => 'Gebäudemiete',
        'equipments' => 'Ausrüstungen',
        'electricity_bill' => 'Stromrechnung',
        'telephone_bill' => 'Telefonrechnung',
        'power_generator_fuel_charge' => 'Kraftstoffladung des Stromgenerators',
        'tea_expense' => 'Kosten für Tee',
    ],

    //expenses keys
    'expense' => [
        'new_expense' => 'Neue Ausgaben',
        'edit_expense' => 'Kosten bearbeiten',
        'expense_head' => 'Kosten Kopf',
        'name' => 'Name',
        'date' => 'Datum',
        'invoice_number' => 'Rechnungsnummer',
        'amount' => 'Menge',
        'attachment' => 'Anhang',
        'description' => 'Beschreibung',
        'choose' => 'Wählen',
        'download' => 'Herunterladen',
        'expense_details' => 'Aufwandsdetails',
        'select_expense_head' => 'Wählen Sie Expense Head',
        'document_error' => 'Das Dokument muss eine Dateityp sein: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //    income filter
    'income_filter' => [
        'canteen_rate' => 'Mensa Miete',
        'hospital_charges' => 'Krankenhausgebühren',
        'special_campaign' => 'Sonderaktion',
        'vehicle_stand_charge' => 'Fahrzeugstandplatzgebühr',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'Einkommen',
        'new_income' => 'Neues Einkommen',
        'edit_income' => 'Einkommen bearbeiten',
        'income_head' => 'Einkommensleiter',
        'name' => 'Name',
        'date' => 'Datum',
        'invoice_number' => 'Rechnungsnummer',
        'amount' => 'Menge',
        'attachment' => 'Anhang',
        'description' => 'Beschreibung',
        'choose' => 'Wählen',
        'download' => 'Herunterladen',
        'income_details' => 'Einkommensdetails',
        'select_income_head' => 'Wählen Sie Income Head',
        'document_error' => 'Das Dokument muss eine Dateityp sein: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Bettstatus',
        'assigned_beds' => 'Zugewiesene Betten',
        'available_beds' => 'Verfügbare Betten',
        'bed_name' => 'Bettname',
        'patient_name' => 'Patienten name',
        'phone' => 'Telefon',
        'admission_date' => 'Aufnahmedatum',
        'gender' => 'Geschlecht',
    ],

    //Messages keys
    'message' => [
        'message' => 'Botschaft',
        'messages' => 'Mitteilungen',
        'send_to' => 'Senden an',
        'subject' => 'Gegenstand',
        'new_message' => 'Neue Nachricht',
        'messages_details' => 'Nachrichtendetails',
        'sender_name' => 'Absender',
        'date' => 'Datum',
        'select_user' => 'Wähle den Benutzer',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'SMS',
        'new_sms' => 'Neue SMS',
        'send_to' => 'Senden an',
        'phone_number' => 'Telefonnummer',
        'send_by' => 'Gesendet von',
        'message' => 'Botschaft',
        'sms_details' => 'SMS-Details',
        'date' => 'Datum',
        'send' => 'Senden',
        'role' => 'Rolle',
        'send_sms_by_number_directly' => 'Senden Sie SMS direkt nach Nummer',
        'only_user_with_registered_phone_will_display' => '(Es werden nur Benutzer mit einem registrierten Telefon angezeigt.)',
        'sms_mail' => 'SMS/Mail',
        'select_role' => 'Rolle auswählen',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'Diagnose',
        'diagnosis_test' => 'Diagnosetests',
        'patient_diagnosis_test' => 'Patientendiagnosetests',
        'report_number' => 'Berichtsnummer',
        'patient' => 'Geduldig',
        'doctor' => 'Arzt',
        'created_at' => 'Hergestellt in',
        'action' => 'Aktion',
        'new_patient_diagnosis_test' => 'Neuer Patientendiagnosetest',
        'edit_patient_diagnosis_test' => 'Patientendiagnosetest bearbeiten',
        'create_patient_diagnosis_test' => 'Erstellen Sie einen Patientendiagnosetest',
        'patient_diagnosis_test_details' => 'Details zum Patientendiagnosetest',
        'diagnosis_category' => 'Diagnosekategorie',
        'add_other_diagnosis_property' => 'Fügen Sie eine andere Diagnoseeigenschaft hinzu',
        'other_diagnosis_property' => 'Andere Diagnoseeigenschaft',
        'diagnosis_property_name' => 'Name der Diagnoseeigenschaft',
        'diagnosis_property_value' => 'Diagnoseeigenschaftswert',
        'patient_name' => 'Patientenname',
        'doctor_name' => 'Name des Arztes',
        'age' => 'Alter',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'average_glucose' => 'Durchschnittliche Glukose',
        'fasting_blood_sugar' => 'Blutzucker nüchtern',
        'urine_sugar' => 'Urin Zucker',
        'blood_pressure' => 'Blutdruck',
        'diabetes' => 'Diabetes',
        'cholesterol' => 'Cholesterin',
        'print_diagnosis_test' => 'Diagnosetest drucken',
        'select_diagnosis_cat' => 'Diagnosekategorie auswählen',
        'patient_unique' => 'Der Name des Patienten ist bereits vergeben.',
        'report_generated' => 'Bericht generiert',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'Diagnosekategorie',
        'diagnosis_category_details' => 'Details zur Diagnosekategorie',
        'diagnosis_categories' => 'Diagnosekategorie',
        'new_diagnosis_category' => 'Neue Diagnosekategorie',
        'description' => 'Beschreibung',
        'category_name' => 'Kategoriename',
        'diagnosis_category_details' => 'Details zur Diagnosekategorie',
        'edit_diagnosis_category' => 'Diagnosekategorie bearbeiten',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'Artikel kategorie',
        'item_categories' => 'Artikel kategorien',
        'new_item_category' => 'Neue Artikel kategorie',
        'edit_item_category' => 'Artikel kategorie bearbeiten',
        'name' => 'Name',
    ],

    'item' => [
        'item' => 'Artikel',
        'items' => 'Artikel',
        'new_item' => 'Neu Artikel',
        'edit_item' => 'Bearbeiten Artikel',
        'item_details' => 'Artikel Einzelheiten',
        'name' => 'Name',
        'item_category' => 'Artikel Kategorie',
        'unit' => 'Einheit',
        'description' => 'Beschreibung',
        'available_quantity' => 'Verfügbar Menge',
        'select_item_category' => 'Artikelkategorie auswählen',
    ],

    'item_stock' => [
        'item_stock' => 'Artikel Lager',
        'item_stocks' => 'Artikel Bestände',
        'new_item_stock' => 'Neu Artikel Lager',
        'edit_item_stock' => 'Bearbeiten Artikel Lager',
        'item_stock_details' => 'Artikel Lager Details',
        'item_category' => 'Artikel Kategorie',
        'item' => 'Artikel',
        'supplier_name' => 'Lieferant Name',
        'store_name' => 'Geschäft Name',
        'quantity' => 'Menge',
        'purchase_price' => 'Kaufpreis',
        'description' => 'Beschreibung',
        'attachment' => 'Anhang',
    ],

    'issued_item' => [
        'issued_item' => 'Ausgestelltes Objekt',
        'issued_items' => 'Ausgestellte Artikel',
        'new_issued_item' => 'Neu ausgegebener Artikel',
        'edit_issued_item' => 'Ausgestelltes Element bearbeiten',
        'issued_item_details' => 'Details zu ausgegebenen Artikeln',
        'department_id' => 'Benutzertyp',
        'user_id' => 'Ausgabe an',
        'issued_by' => 'Problem durch',
        'issued_for' => 'Ausgabe für',
        'issued_date' => 'Ausgabedatum',
        'return_date' => 'Rückflugdatum',
        'item_category' => 'Artikelkategorie',
        'item' => 'Artikel',
        'quantity' => 'Menge',
        'description' => 'Beschreibung',
        'available_quantity' => 'verfügbare Anzahl',
        'item_return' => 'Artikel zurückgeben',
        'item_returned' => 'Ist zurückgekommen',
        'select_user_type' => 'Benutzertyp auswählen',
        'qty_cannot_be_zero' => 'Die Menge kann nicht null sein.',
        'qty_must_be_less_than_available_qty' => 'Die Menge muss kleiner als die verfügbare Menge sein.',
        'are_you_sure_want_to_return_this_item' => 'Möchten Sie diesen Artikel wirklich zurückgeben',
    ],

    'ipd_patient' => [
        'ipd_patient' => 'IPD Patient',
        'ipd_patients' => 'IPD Patients',
        'new_ipd_patient' => 'Neuer IPD Patient',
        'edit_ipd_patient' => 'IPD-Patienten bearbeiten',
        'ipd_patient_details' => 'IPD Patient Einzelheiten',
        'patient_id' => 'Geduldig',
        'ipd_number' => 'IPD Nr',
        'height' => 'Höhe',
        'weight' => 'Gewicht',
        'bp' => 'Blutdruck',
        'symptoms' => 'Symptome',
        'notes' => 'Anmerkungen',
        'admission_date' => 'Aufnahmedatum',
        'case_id' => 'Fall',
        'is_old_patient' => 'Ist alter Patient',
        'doctor_id' => 'Arzt',
        'bed_type_id' => 'Betttyp',
        'bed_id' => 'Bett',
        'bill_status' => 'Rechnungsstatus',
        'discharged' => 'Entlassen',
        'discharge_patient' => 'Patient entlassen',
        'please_select_applied_date' => 'Bitte wählen Sie das Bewerbungsdatum aus',
        'please_select_instruction_date' => 'Bitte wählen Sie das Unterrichtsdatum aus',
        'please_enter_instruction' => 'Bitte geben Sie die Anweisung ein',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'Diagnose hinzufügen',
        'edit_ipd_diagnosis' => 'Diagnose bearbeiten',
        'report_type' => 'Berichtstyp',
        'report_date' => 'Berichtsdatum',
        'document' => 'Dokument',
        'description' => 'Beschreibung',
    ],

    'ipd_patient_consultant_register' => [
        'new_consultant_register' => 'Berateranweisung hinzufügen',
        'edit_consultant_register' => 'Berateranweisung bearbeiten',
        'applied_date' => 'Angewandtes Datum',
        'doctor_id' => 'Arzt',
        'instruction' => 'Anweisung',
        'instruction_date' => 'Anweisungsdatum',
    ],

    'ipd_patient_charges' => [
        'new_charge' => 'Gebühren hinzufügen',
        'edit_charge' => 'Gebühren bearbeiten',
        'date' => 'Datum',
        'charge_type_id' => 'Ladungsart',
        'charge_category_id' => 'Gebührenkategorie',
        'charge_id' => 'Code',
        'standard_charge' => 'Standardgebühr',
        'applied_charge' => 'Angewandte Gebühr',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD Nr',
        'header_note' => 'Header Hinweis',
        'footer_note' => 'Fußzeile Hinweis',
        'new_prescription' => 'Rezept hinzufügen',
        'edit_prescription' => 'Rezept bearbeiten',
        'prescription_details' => 'Rezeptdetails',
        'category_id' => 'Medizin Kategorie',
        'medicine_id' => 'Medizin',
        'dosage' => 'Dosierung',
        'instruction' => 'Anweisung',
        'print_prescription' => 'Rezept drucken',
    ],

    'ipd_patient_timeline' => [
        'new_ipd_timeline' => 'Timeline hinzufügen',
        'edit_ipd_timeline' => 'Timeline bearbeiten',
        'title' => 'Titel',
        'date' => 'Datum',
        'description' => 'Beschreibung',
        'document' => 'Dokument',
        'visible_to_person' => 'Für die Person sichtbar',
        'no_timeline_found' => 'Keine Zeitleiste gefunden',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'Ipd-Zahlung hinzufügen',
        'edit_ipd_payment' => 'IPD-Zahlung bearbeiten',
        'select_payment_mode' => 'Wählen Sie Zahlungsmodus',
        'payment_mode' => 'Zahlungsart',
        'make_payment' => 'Zahlung leisten',
    ],

    'ipd_bill' => [
        'paid_amount' => 'Bezahlte Menge',
        'total_charges' => 'Gesamte Gebühren',
        'gross_total' => 'Bruttosumme',
        'discount_in_percentage' => 'Rabatt in Prozent',
        'discount_in_number' => 'Discount In Number',
        'tax_in_percentage' => 'Steuer in Prozent',
        'tax_in_number' => 'Steuernummer',
        'other_charges' => 'Zusatzgebühren',
        'net_payable_amount' => 'Nettobetrag',
    ],

    'opd_patient' => [
        'opd_patient' => 'OPD Patient',
        'opd_patients' => 'OPD Patients',
        'new_opd_patient' => 'Neu OPD Patient',
        'edit_opd_patient' => 'Bearbeiten OPD Patient',
        'opd_patient_details' => 'OPD Patienten details',
        'opd_number' => 'OPD Nein',
        'appointment_date' => 'Termin',
        'visits' => 'Besuche',
        'revisits' => 'Wiederholen',
        'total_visits' => 'Gesamtzahl der Besuche',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'Opd Payment hinzufügen',
        'edit_opd_payment' => 'Opd Payment bearbeiten',
        'payment_mode' => 'Zahlungsart',
        'make_payment' => 'Zahlung leisten',
        'choose_payment' => 'Zahlung auswählen',
    ],

    'call_log' => [
        'new' => 'Neues Anrufprotokoll',
        'edit' => 'Anrufliste bearbeiten',
        'name' => 'Name',
        'phone' => 'Telefon',
        'received_on' => 'Eingegangen am',
        'follow_up_date' => 'Follow-up-Termin',
        'note' => 'Hinweis',
        'call_type' => 'Anrufart',
        'incoming' => 'Eingehend',
        'outgoing' => 'Ausgehend',
    ],

    //    visitor filter
    'visitor_filter' => [
        'visit' => 'Besuch',
        'enquiry' => 'Anfrage',
        'seminar' => 'Seminar',
    ],

    'visitor' => [
        'new' => 'Neuer Besucher',
        'edit' => 'Besucher bearbeiten',
        'name' => 'Name',
        'purpose' => 'Zweck',
        'phone' => 'Telefon',
        'id_card' => 'Ausweis',
        'number_of_person' => 'Anzahl von Personen',
        'date' => 'Datum',
        'in_time' => 'Rechtzeitig',
        'out_time' => 'aus der Zeit',
        'note' => 'Hinweis',
        'select_purpose' => 'Zweck auswählen'
    ],

    'postal' => [
        'new_receive' => 'Neu empfangen',
        'new_dispatch' => 'Neuer Versand',
        'dispatch' => 'Versand',
        'receive' => 'Erhalten',
        'edit_receive' => 'Empfangen bearbeiten',
        'edit_dispatch' => 'Versand bearbeiten',
        'to_title' => 'Zum Titel',
        'from_title' => 'Aus dem Titel',
        'reference_no' => 'Referenznummer',
        'date' => 'Datum',
        'address' => 'Adresse',
    ],

    'testimonial' => [
        'new_testimonial' => 'Neu Zeugnis',
        'edit_testimonial' => 'Testimonial bearbeiten',
        'name' => 'Name',
        'description' => 'Beschreibung',
        'position' => 'Position',
        'show_testimonial' => 'Erfahrungsbericht anzeigen',
        'profile_error' => 'Das Dokument muss eine Datei vom Typ sein: jpeg, jpg, png.',
    ],

    'blood_donation' => [
        'new_blood_donation' => 'Neue Blutspende',
        'edit_blood_donation' => 'Blutspende bearbeiten',
        'donor_name' => 'Name des Spenders',
        'bags' => 'Taschen',
    ],

    'blood_issue' => [
        'new_blood_issue' => 'Neues Blutproblem',
        'edit_blood_issue' => 'Blutproblem bearbeiten',
        'issue_date' => 'Ausgabedatum',
        'patient_name' => 'Patientenname',
        'doctor_name' => 'Name des Arztes',
        'donor_name' => 'Name des Spenders',
        'amount' => 'Menge',
        'remarks' => 'Bemerkungen',
    ],

    'notification' => [
        'notifications' => 'Benachrichtigungen',
        'mark_all_as_read' => 'Markiere alle als gelesen',
        'you_don`t_have_any_new_notification' => 'Sie haben keine neue Benachrichtigung',
    ],

    //    live_consultation_filter
    'live_consultation_filter' => [
        'awaited' => 'Erwartet',
        'cancelled' => 'Abgesagt',
        'finished' => 'Fertig',
    ],

    'live_consultation' => [
        'new_live_consultation' => 'Neue Live-Beratung',
        'consultation_title' => 'Konsultationstitel',
        'consultation_date' => 'Konsultationsdatum',
        'consultation_duration_minutes' => 'Konsultationsdauer Minuten',
        'client_video' => 'Client Video',
        'host_video' => 'Host-Video',
        'enable' => 'aktivieren',
        'disabled' => 'Behindert',
        'Type' => 'Art',
        'type_number' => 'Nummer eingeben',
        'created_by' => 'Erstellt von',
        'created_for' => 'Hergestellt für',
        'edit_live_meeting' => 'Live-Meeting bearbeiten',
        'join_now' => 'Jetzt beitreten',
        'new_live_meeting' => 'Neues Live-Meeting',
        'staff_list' => 'Mitarbeiterliste',
        'add_credential' => 'Anmeldedaten hinzufügen',
        'edit_live_consultation' => 'Live-Beratung bearbeiten',
        'duration' => 'Dauer (in Minuten)',
        'zoom_api_key' => 'Zoom-API-Schlüssel',
        'zoom_api_secret' => 'Zoom-API-Geheimnis',
        'how_to_generate_Oauth_credentials' => 'So generieren Sie OAuth-Anmeldeinformationen',
        'select_platform' => 'Plattform auswählen'
    ],

    'vaccination' => [
        'vaccinations' => 'Impfungen',
        'new_vaccination' => 'Neue Impfung',
        'edit_vaccination' => 'Impfung bearbeiten',
        'name' => 'Name',
        'manufactured_by' => 'Hergestellt von',
        'brand' => 'Marke',
        'vaccinated' => 'Geimpft',
        'select_vaccination' => 'Impfung auswählen',
    ],

    'vaccinated_patient' => [
        'patient' => 'Geduldig',
        'vaccination' => 'Impfung',
        'vaccination_name' => 'Impfname',
        'serial_no' => 'Seriennummer',
        'does_no' => 'Dosis Nr',
        'dose_given_date' => 'Dosis gegebenes Datum',
        'description' => 'Beschreibung',
        'add_vaccinate_patient' => 'Impfpatienten hinzufügen',
        'new_vaccinate_patient' => 'Neuer Impfpatient',
        'edit_vaccinate_patient' => 'Impfpatienten bearbeiten',
        'vaccine' => 'Impfstoff',
        'vaccinate_patient' => 'Patienten impfen',
    ],

    'front_setting' => [
        'front_setting_details' => 'Details zur vorderen Einstellung',
        'about_us_details' => 'Über uns Details',
        'appointment_details' => 'Termindetails',
        'terms_condition_details' => 'AGB-Details',
        'about_us_title' => 'Titel',
        'about_us_mission' => 'Mission',
        'about_us_image' => 'Bild',
        'about_us_description' => 'Beschreibung',
        'home_page_image' => 'Homepage-Bild',
        'home_page_title' => 'Titel der Startseite',
        'home_page_description' => 'Homepage-Beschreibung',
        'home_page_box_title' => 'Titel der Homepage-Box',
        'home_page_box_description' => 'Beschreibung des Startseitenfelds',
        'home_page_experience' => 'Homepage-Erfahrung',
        'home_page_step_1_title' => 'Startseite Schritt 1 Titel',
        'home_page_step_1_description' => 'Startseite Schritt 1 Beschreibung',
        'home_page_step_2_title' => 'Startseite Schritt 2 Titel',
        'home_page_step_2_description' => 'Startseite Schritt 2 Beschreibung',
        'home_page_step_3_title' => 'Startseite Schritt 3 Titel',
        'home_page_step_3_description' => 'Startseite Schritt 3 Beschreibung',
        'home_page_step_4_title' => 'Startseite Schritt 4 Titel',
        'home_page_step_4_description' => 'Startseite Schritt 4 Beschreibung',
        'terms_conditions' => 'Allgemeine Geschäftsbedingungen',
        'privacy_policy' => 'Datenschutzrichtlinie',
        'home_page_certified_doctor_image' => 'Bild der Homepage des zertifizierten Arztes',
        'home_page_certified_doctor_text' => 'Startseite zertifizierter Arzt Text',
        'home_page_certified_doctor_title' => 'Startseite Titel des zertifizierten Arztes',
        'home_page_certified_doctor_description' => 'Homepage Beschreibung des zertifizierten Arztes',
        'home_page_certified_box_title' => 'Titel der zertifizierten Box der Startseite',
        'home_page_certified_box_description' => 'Beschreibung der Startseite der zertifizierten Box',
    ],

    'change_password' => [
        'change_password' => 'Kennwort ändern',
        'current_password' => 'Jetziges Passwort',
        'new_password' => 'Neues Kennwort',
        'confirm_password' => 'Kennwort bestätigen',
        'enter_your_current_password' => 'Geben Sie Ihr aktuelles Passwort ein',
        'enter_a_new_password' => 'Geben Sie ein neues Passwort ein',
        'confirm_your_new_password' => 'Bestätigen Sie Ihr neues Passwort',
    ],

    'web_home' => [
        'home' => 'Heim',
        'services' => 'Dienstleistungen',
        'doctors' => 'Ärztinnen',
        'about_us' => 'Über uns',
        'contact' => 'Kontakt',
        'make_appointment' => 'Einen Termin machen',
        'working_hours' => 'Arbeitszeit',
        'testimonials' => 'Referenzen',
        'terms_of_service' => 'Nutzungsbedingungen',
        'privacy_policy' => 'Datenschutz-Bestimmungen',
        'patients' => 'Patientinnen',
        'years_experience' => 'Jahre Erfahrung',
        'sign_up' => 'Anmeldung',
        'available_doctors' => 'Verfügbare Ärzte',
        'select_doctors' => 'Ärzte auswählen',
        'contact_doctors' => 'Arzt kontaktieren',
        'contact_hospital' => 'Krankenhaus kontaktieren',
        'easy_solutions' => 'Einfache Lösungen',
        '4_easy_step_and_get_the_world_best_treatment' => '4 einfache Schritte und erhalten Sie die beste Behandlung der Welt',
        'book_an_appointment' => 'Vereinbare einen Termin',
        'select_doctor' => 'Arzt auswählen',
        'book_now' => 'buchen Sie jetzt',
        'patients_beds' => 'Patientenbetten',
        'doctors_nurses' => 'Ärzte & Krankenschwestern',
        'happy_patients' => 'Glückliche Patienten',
        'book_appointment' => 'Einen Termin verabreden',
        'our_services' => 'Unsere Dienstleistungen',
        'we_offer_different_services_to_improve_your_health' => 'Wir bieten verschiedene Dienstleistungen an, um Ihre Gesundheit zu verbessern',
        'professional_doctors' => 'Professionelle Ärzte',
        'we_are_experienced_healthcare_professionals' => 'Wir sind erfahrene Gesundheitsexperten',
        'our_testimonials' => 'Unsere Erfahrungsberichte',
        'what_our_patient_say_about_medical_treatments' => 'Was unsere Patienten über unsere medizinischen Behandlungen sagen',
    ],

    'web_contact' => [
        'call_today' => 'Ruf heute an',
        'open_hours' => 'Öffnungszeiten',
        'our_location' => 'unsere Position',
        'send_us_a_message' => 'Schick uns eine Nachricht',
        'your_name' => 'Dein Name',
        'your_email' => 'Deine E-Mail',
        'phone_number' => 'Telefonnummer',
        'select_enquiry' => 'Anfrage auswählen',
        'your_message' => 'Ihre Nachricht',
        'send_message' => 'Nachricht senden',
        'enter_your_name' => 'Gib deinen Namen ein',
        'enter_your_email' => 'Geben sie ihre E-Mail Adresse ein',
        'contact_no' => 'Kontakt Nr',
        'please_enter_your_phone_number' => 'Bitte geben sie ihre Telefonnummer ein',
        'write_your_message' => 'Schreibe deine Nachricht',
        'type_your_message' => 'Geben Sie Ihre Nachricht ein',
        'enter_your_phone_number' => 'Trage deine Telefonnummer ein',
        'get_in_touch' => 'Kontaktieren Sie uns und lassen Sie uns wissen, wie wir Ihnen helfen können. Füllen Sie das Formular aus und wir werden uns so schnell wie möglich bei Ihnen melden.',
    ],

    'web_menu' => [
        'about' => 'Über',
        'our_features' => 'Unsere Funktionen',
        'appointment' => 'Termin',
        'working_hours' => 'Arbeitszeit',
        'login' => 'Anmeldung',
        'useful_link' => 'Nützlicher Link',
        'contact_information' => 'Kontaktinformationen',
        'copyright' => 'Urheberrechte ©',
        'all_rights_reserved_by' => 'Alle Rechte vorbehalten von',
        'all_rights_reserved' => 'Alle Rechte vorbehalten',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'Einen Termin machen',
        'call_now_and_get_a_free_consulting' => 'Rufen Sie jetzt an und lassen Sie sich kostenlos beraten',
        'enter_your_first_name' => 'Geben Sie Ihren Vornamen ein',
        'enter_your_last_name' => 'Geben Sie Ihren Nachnamen ein',
        'enter_your_password' => 'Geben Sie Ihr Passwort ein',
        'enter_confirm_password' => 'Geben Sie das Kennwort zur Bestätigung ein',
        'select_department' => 'Abteilung auswählen',
        'select_doctor' => 'Arzt auswählen',
        'enter_description' => 'Beschreibung eingeben',
        'select_time' => 'Wählen Sie Zeit',
    ],

    'web_working_hours' => [
        'opening_hours' => 'Öffnungszeiten',
        'no_yet_opening_hours' => 'Noch keine Öffnungszeiten',
    ],

    // subscription plan
    'subscription_plans' => [
        'select_plan_type' => 'Planart auswählen',
        'end_date' => 'Ablauf am',
        'make_default' => 'Machen Standard',
        'start_date' => 'Anfangsdatum',
        'add_subscription_plan' => 'Abonnementplan hinzufügen',
        'name' => 'Name',
        'currency' => 'Währung',
        'price' => 'Preis',
        'valid_until' => 'Gültig bis',
        'edit_subscription_plan' => 'Abonnementplan bearbeiten',
        'plan_type' => 'Plantyp',
        'active_plan' => 'Aktive Pläne',
        'valid_until_tooltip' => 'Wenn Sie 1 eingeben und der Plantyp Jahr ist, wird es als 1 Jahr und Monat betrachtet.',
        'trail_plan' => 'Wegplan',
        'trail_plan_text' => 'Der Trail-Plan hat standardmäßig den Preis Null und die Währung in USD, die bis (in Tagen) gültig sind.',
        'plan_features' => 'Planfunktionen',
        'select_all' => 'Wählen Sie Alle',
        'default_plan_text_one' => 'Dieses Menü enthält',
        'default_plan_text_two' => 'Untermenüs.',
        'payment_type' => 'Zahlungsart wählen',
        'transactions' => 'Transaktionen',
        'view_subscription_plan' => 'Details zum Abonnementplan',
        'transaction_details' => 'Transaktionsdetails',
        'plan_name' => 'Planname',
        'transaction_date' => 'Transaktionsdatum',
        'payment_method' => 'Bezahlverfahren',
        'amount' => 'Betragen',
        'free_plan' => 'Kostenloser Plan',
        'subscription_plans' => 'Abonnementpläne',
        'transaction' => 'Transaktion',
        'frequency' => 'Frequenz',
        'trail_end_date' => 'Enddatum der Testversion',
        'payment' => 'Zahlung',
        'enter_plan_name' => 'Plannamen eingeben',
        'select_currency' => 'Währung wählen',
        'enter_price' => 'Preis eingeben',
        'enter_trial_day' => 'Geben Sie Probetage ein',
        'remaining_balance' => 'Die verbleibende Summe',
        'amount_to_pay' => 'Zu zahlender Betrag',
        'used_days' => 'Tage genutzt',
        'total_extra_days' => 'Gesamtzahl der zusätzlichen Tage',
        'pay_or_switch_plan' => 'Tarif bezahlen/wechseln',
    ],

    // subscription pricing plan keys
    'subscription_pricing_plans' => [
        'subscription_pricing_plan' => 'Abonnement-Preisplan',
        'choose_plan' => 'Wählen Sie einen Plan',
        'week' => 'Woche',
        'month' => 'Monat',
        'year' => 'Jahr',
        'has_been_subscribed' => 'wurde abonniert',
        'currently_active' => 'Gerade aktiv',
        'renew_plan' => 'Plan erneuern',
        'no_pricing_plan_found' => 'Wir konnten keine Abonnementpläne finden',
        'renew_free_plan' => 'Kostenloser Plan kann nicht verlängert/ausgewählt werden',
        'proceed_to_payment' => 'Weiter zur Zahlung',
        'switch_plan' => 'Plan wechseln',
    ],

    // Landing Cms
    'landing_cms' => [
        'landing_cms' => 'Landing-CMS',
        'section_one' => 'Abschnitt eins',
        'text_main' => 'Texthaupt',
        'text_secondary' => 'Sekundärtext',
        'image' => 'Bild',
        'section_two' => 'Abschnitt zwei',
        'card_one_image' => 'Karte eins Bild',
        'card_one_text' => 'Karte eins Text',
        'card_one_text_secondary' => 'Karte 1 Text sekundär',
        'card_two_image' => 'Karte zwei Bild',
        'card_two_text' => 'Karte zwei Text',
        'card_two_text_secondary' => 'Karte 2 Text sekundär',
        'card_third_image' => 'Drittes Bild der Karte',
        'card_third_text' => 'Dritter Text der Karte',
        'card_third_text_secondary' => 'Karte dritter Text sekundär',
        'section_three' => 'Abschnitt drei',
        'text_one' => 'Text eins',
        'text_two' => 'Text zwei',
        'text_three' => 'Text Drei',
        'text_four' => 'Text vier',
        'text_five' => 'Text fünf',
        'section_four' => 'Abschnitt vier',
        'card_three_image' => 'Karte Drei Bild',
        'card_three_text' => 'Karte drei Text',
        'card_three_text_secondary' => 'Karte 3 Text Sekundär',
        'card_four_image' => 'Karte vier Bild',
        'card_four_text' => 'Karte vier Text',
        'card_four_text_secondary' => 'Karte vier Text sekundär',
        'card_five_image' => 'Karte fünf Bild',
        'card_five_text' => 'Karte fünf Text',
        'card_five_text_secondary' => 'Karte 5 Text Sekundär',
        'card_six_image' => 'Karte Sechs Bild',
        'card_six_text' => 'Karte Sechs Text',
        'card_six_text_secondary' => 'Karte Sechs Text Sekundär',
        'section_five' => 'Abschnitt fünf',
        'main_image' => 'Hauptbild',
        'card_one_number' => 'Karte eine Nummer',
        'card_two_number' => 'Karte zwei Nummer',
        'card_three_number' => 'Karte drei Nummer',
        'card_four_number' => 'Karte vier Nummer',
        'about_us' => 'Über uns',
        'main_img_one' => 'Hauptbild Eins',
        'main_img_two' => 'Hauptbild Zwei',
    ],

    'subscribe' => [
        'subscribers' => 'Abonnentinnen',
    ],

    'footer_setting' => [
        'footer_settings' => 'Fußzeileneinstellungen',
        'footer_text' => 'Fusszeile',
        'address' => 'Die Anschrift',
    ],

    'landing' => [
        'subscribe_our_newsletter' => 'Unseren Newsletter abonnieren',
        'subscribe' => 'Abonnieren',
        'usefull_link' => 'Nützlicher Link',
        'faqs' => 'FAQ',
        'about' => 'Über',
        'home' => 'Heim',
        'pricing' => 'Preisgestaltung',
        'get_in_touch' => 'In Kontakt kommen',
        'all_rights_reserved' => 'Alle Rechte vorbehalten',
        'call' => 'Anruf',
        'choose_your_pricing_plan' => 'Wählen Sie Ihren Preisplan',
        'enquiry' => 'Anfrage',
    ],

    'faqs' => [
        'faqs' => 'FAQs',
        'add_faqs' => 'FAQs hinzufügen',
        'edit_faqs' => 'FAQs bearbeiten',
        'question' => 'Frage',
        'answer' => 'Antworten',
        'show' => 'FAQ anzeigen',
    ],

    'hospitals_list' => [
        'hospital_name' => 'Krankenhausname',
        'hospital_username' => 'Krankenhaus-Benutzername',
        'add_new_hospital' => 'Neues Krankenhaus hinzufügen',
        'edit_hospital' => 'Krankenhaus bearbeiten',
        'new_hospital' => 'Neues Krankenhaus',
    ],

    'subscription' => [
        'month' => 'Monat',
        'year' => 'Jahr',
        'subscription' => 'Abonnement',
        'subscriptions' => 'Abonnements',
        'subscription_details' => 'Abonnementdetails',
        'edit_subscription' => 'Abonnement bearbeiten',
        'payment_approved' => 'Zahlung genehmigt',
        'approved' => 'Zugelassen',
        'denied' => 'Bestritten',
        'select_manual_payment' => 'Wählen Sie Manuelle Zahlung',
        'waiting_for_approval' => 'Warten auf die Bestätigung',
        'cash_payment_done' => 'Ihre Zahlung ist abgeschlossen und Ihr Abonnement wird aktiviert, sobald der Administrator Ihre Transaktion genehmigt hat.',
    ],

    'delete' => [
        'accountant' => 'Buchhalter',
        'account' => 'Konto',
        'advanced_payment' => 'Vorauszahlung',
        'ambulance_call' => 'Notruf',
        'ambulance' => 'Ambulanz',
        'appointment' => 'Geplanter Termin',
        'bed_assign' => 'Bett zuweisen',
        'bed_type' => 'Betttyp',
        'bed' => 'Bett',
        'bill' => 'Rechnung',
        'birth_report' => 'Geburtsbericht',
        'blood_group' => 'Blutgruppe',
        'blood_donation' => 'Blutspende',
        'blood_donor' => 'Blutspender',
        'blood_issue' => 'Blutproblem',
        'medicine_brand' => 'Medizin Marke',
        'call_log' => 'Anrufliste',
        'case_handler' => 'Fallbearbeiter',
        'medicine_category' => 'Kategorie Medizin',
        'charge_category' => 'Gebührenkategorie',
        'charge' => 'Aufladen',
        'department' => 'Abteilung',
        'diagnosis_category' => 'Diagnosekategorie',
        'doctor_opd_charge' => 'Arzt Opd Gebühr',
        'doctor_department' => 'Arztabteilung',
        'document' => 'Dokumentieren',
        'document_type' => 'Dokumentenart',
        'employee_payroll' => 'Gehaltsabrechnung der Mitarbeiter',
        'expense' => 'Aufwand',
        'faq' => 'FAQ',
        'income' => 'Einkommen',
        'insurance' => 'Versicherung',
        'investigation_report' => 'Untersuchungsbericht',
        'invoice' => 'Rechnung',
        'ipd_charge' => 'Ipd-Gebühr',
        'ipd_consultant_instruction' => 'Ipd-Berateranweisung',
        'ipd_diagnosis' => 'Ipd-Diagnose',
        'ipd_patient' => 'IPD-Patient',
        'ipd_payment' => 'IPD-Zahlung',
        'ipd_prescription' => 'IPD-Rezept',
        'issued_item' => 'Ausgestellter Artikel',
        'item_category' => 'Artikelkategorie',
        'item_stock' => 'Artikelbestand',
        'item' => 'Artikel',
        'lab_technician' => 'Labortechniker',
        'live_consultation' => 'Live-Beratung',
        'live_meeting' => 'Live-Meeting',
        'medicine' => 'Medizin',
        'notice_board' => 'Schild',
        'nurse' => 'Krankenpfleger',
        'opd_diagnosis' => 'OPD-Diagnose',
        'opd_patient' => 'OPD-Patient',
        'opd_patient_visit' => 'OPD-Patientenbesuch',
        'operation_report' => 'Betriebsbericht',
        'package' => 'Paket',
        'pathology_category' => 'Kategorie Pathologie',
        'pathology_test' => 'Pathologie-Test',
        'patient_admission' => 'Patientenaufnahme',
        'case' => 'Fall',
        'patient_diagnosis_test' => 'Patientendiagnostiktest',
        'patient' => 'Geduldig',
        'payment' => 'Zahlung',
        'pharmacist' => 'Apotheker',
        'prescription' => 'Verschreibung',
        'radiology_category' => 'Kategorie Radiologie',
        'radiology_test' => 'Radiologie-Test',
        'receptionist' => 'Rezeptionist',
        'schedule' => 'Schedule',
        'service_slider' => 'Service-Schieberegler',
        'service' => 'Service',
        'sms' => 'SMS',
        'subscriber' => 'Teilnehmer',
        'subscription_plan' => 'Abonnementplan',
        'hospital' => 'Krankenhaus',
        'enquiry' => 'Enquiry',
        'user' => 'Benutzer',
        'vaccinated_patient' => 'Geimpfter Patient',
        'vaccination' => 'Impfung',
        'visitor' => 'Besucher',
        'testimonial' => 'Zeugnis',
        'opd_timelines' => 'OPD-Zeitleiste',
    ],

    'flash' => [
        'not_allow_access_record' => 'Anscheinend sind Sie nicht berechtigt, auf diesen Datensatz zuzugreifen.',
        'accountant_not_found' => 'Buchhalter nicht gefunden',
        'admin_not_found' => 'Administrator nicht gefunden',
        'advance_payment_not_found' => 'Anzahlung nicht gefunden',
        'ambulance_call_not_found' => 'Krankenwagenruf nicht gefunden',
        'ambulance_not_found' => 'Krankenwagen nicht gefunden',
        'bed_assign_not_found' => 'Bettenzuweisung nicht gefunden',
        'bed_not_found' => 'Bett nicht gefunden',
        'birth_report_not_found' => 'Geburtsbericht nicht gefunden',
        'blood_bank_not_found' => 'Blutbank nicht gefunden',
        'blood_donation_not_found' => 'Blutspende nicht gefunden',
        'blood_donor_not_found' => 'Blutspender nicht gefunden',
        'blood_issue_not_found' => 'Blutproblem nicht gefunden',
        'brand_not_found' => 'Marke nicht gefunden',
        'call_log_not_found' => 'Anrufprotokoll nicht gefunden',
        'case_handler_not_found' => 'Fallbearbeiter nicht gefunden',
        'charge_not_found' => 'Ladung nicht gefunden',
        'currency_not_found' => 'Währung nicht gefunden',
        'death_report_not_found' => 'Todesbericht nicht gefunden',
        'department_not_found' => 'Abteilung nicht gefunden',
        'doctor_opd_charge_not_found' => 'Doctor Opd Charge nicht gefunden',
        'document_not_found' => 'Dokument nicht gefunden',
        'employee_payroll_not_found' => 'Gehaltsabrechnung des Mitarbeiters nicht gefunden',
        'expense_not_found' => 'Kosten nicht gefunden',
        'front_service_not_found' => 'Frontservice nicht gefunden',
        'hospital_not_found' => 'Krankenhaus nicht gefunden',
        'income_not_found' => 'Einkommen nicht gefunden',
        'insurance_not_found' => 'Versicherung nicht gefunden',
        'invoice_not_found' => 'Rechnung nicht gefunden',
        'ipd_charge_not_found' => 'IPD-Gebühr nicht gefunden',
        'ipd_consultant_register_not_found' => 'IPD-Beraterregister nicht gefunden',
        'ipd_diagnosis_not_found' => 'IPD-Diagnose nicht gefunden',
        'ipd_patient_not_found' => 'IPD-Patient nicht gefunden',
        'ipd_payment_not_found' => 'IPD-Zahlung nicht gefunden',
        'ipd_prescription_not_found' => 'IPD-Rezept nicht gefunden',
        'ipd_timeline_not_found' => 'IPD-Timeline nicht gefunden',
        'issued_item_not_found' => 'Ausgestellter Artikel nicht gefunden',
        'item_category_not_found' => 'Artikelkategorie nicht gefunden',
        'item_stock_not_found' => 'Artikelbestand nicht gefunden',
        'lab_technician_not_found' => 'Labortechniker nicht gefunden',
        'live_consultation_not_found' => 'Live-Beratung nicht gefunden',
        'live_meeting_not_found' => 'Live-Meeting nicht gefunden',
        'medicine_not_found' => 'Medikament nicht gefunden',
        'notice_board_not_found' => 'Schwarzes Brett nicht gefunden',
        'nurse_not_found' => 'Krankenschwester nicht gefunden',
        'opd_diagnosis_not_found' => 'Opd-Diagnose nicht gefunden',
        'opd_patient_not_found' => 'OPD-Patient nicht gefunden',
        'opd_timeline_not_found' => 'OPD-Zeitachse nicht gefunden',
        'operation_report_not_found' => 'Operation Report not found',
        'package_not_found' => 'Paket nicht gefunden',
        'pathology_category_not_found' => 'Pathologiekategorie nicht gefunden',
        'pathology_test_not_found' => 'Pathologietest nicht gefunden',
        'patient_admission_not_found' => 'Patientenaufnahme nicht gefunden',
        'patient_case_not_found' => 'Patientenfall nicht gefunden',
        'patient_not_found' => 'Patient nicht gefunden',
        'diagnosis_test_not_found' => 'Diagnosetest nicht gefunden',
        'pharmacist_not_found' => 'Apotheker nicht gefunden',
        'postal_not_found' => 'Post nicht gefunden',
        'radiology_category_not_found' => 'Radiologiekategorie nicht gefunden',
        'radiology_test_not_found' => 'Radiologischer Test nicht gefunden',
        'receptionist_not_found' => 'Empfangsdame nicht gefunden',
        'schedule_not_found' => 'Zeitplan nicht gefunden',
        'sms_not_found' => 'SMS nicht gefunden',
        'user_not_found' => 'Benutzer nicht gefunden',
        'vaccinated_patient_not_found' => 'Geimpfter Patient nicht gefunden',
        'vaccination_not_found' => 'Impfung nicht gefunden',
        'visitor_not_found' => 'Besucher nicht gefunden',
        'testimonial_not_found' => 'Zeugnis nicht gefunden',
        'accountant_save' => 'Buchhalter erfolgreich gespeichert.',
        'accountant_update' => 'Buchhalter erfolgreich aktualisiert.',
        'accountant_cant_delete' => 'Buchhalter kann nicht gelöscht werden.',
        'accountant_delete' => 'Buchhalter erfolgreich gelöscht.',
        'account_save' => 'Konto erfolgreich gespeichert.',
        'account_retrieved' => 'Konto erfolgreich abgerufen.',
        'account_cant_delete' => 'Konto kann nicht gelöscht werden.',
        'account_delete' => 'Konto erfolgreich gelöscht.',
        'account_update' => 'Konto erfolgreich aktualisiert.',
        'advanced_payment_save' => 'Vorauszahlung erfolgreich gespeichert.',
        'advanced_payment_not' => 'Vorauszahlung nicht gefunden',
        'advanced_payment_retrieve' => 'Vorauszahlung erfolgreich abgerufen.',
        'advanced_payment_updated' => 'Vorauszahlung erfolgreich aktualisiert.',
        'advanced_payment_deleted' => 'AdvancedPayment erfolgreich gelöscht.',
        'ambulance_call_saved' => 'Krankenwagenruf erfolgreich gespeichert.',
        'ambulance_call_updated' => 'Krankenwagenruf erfolgreich aktualisiert.',
        'ambulance_call_deleted' => 'Krankenwagenruf erfolgreich gelöscht.',
        'driver_not_found' => 'Treibername nicht gefunden',
        'driver_retrieved' => 'Fahrername erfolgreich abgerufen',
        'ambulance_saved' => 'Krankenwagen erfolgreich gespeichert.',
        'ambulance_update' => 'Krankenwagen erfolgreich aktualisiert.',
        'ambulance_cant_delete' => 'Krankenwagen kann nicht gelöscht werden.',
        'ambulance_delete' => 'Krankenwagen erfolgreich gelöscht.',
        'appointment_list_retrieved' => 'Terminliste erfolgreich abgerufen.',
        'appointment_retrieved' => 'Termin erfolgreich abgerufen.',
        'appointment_not_found' => 'Termin nicht gefunden',
        'date_smaller' => 'Datum sollte nicht kleiner sein als das Geburtsdatum des Patienten.',
        'assign_date_smaller' => 'Zuweisungsdatum sollte nicht kleiner sein als das Geburtsdatum des Patienten.',
        'admission_date_smaller' => 'Das Aufnahmedatum sollte nicht kleiner sein als das Geburtsdatum des Patienten.',
        'case_date_smaller' => 'Das Falldatum sollte nicht kleiner als das Geburtsdatum des Patienten sein.',
        'investigation_date_smaller' => 'Das Datum des Untersuchungsberichts sollte nicht kleiner sein als das Geburtsdatum des Patienten.',
        'bill_date_smaller' => 'Das Rechnungsdatum sollte nicht kleiner als das Geburtsdatum des Patienten sein.',
        'cant_create' => 'Bericht kann nicht erstellt werden, da der Patient tot ist.',
        'appointment_created' => 'Termin erfolgreich erstellt.',
        'appointment_delete' => 'Termin erfolgreich gelöscht.',
        'appointment_cancel' => 'Termin erfolgreich storniert.',
        'appointment_booked' => 'Termin erfolgreich gebucht',
        'appointment_saved' => 'Termin erfolgreich gespeichert.',
        'appointment_updated' => 'Termin erfolgreich aktualisiert.',
        'appointment_charge_must_be_greater_than_570' => 'Die Termingebühr muss größer als 570 sein',
        'appointment_approved_successfully' => 'Termin erfolgreich genehmigt',
        'appointment_cancelled_successfully' => 'Termin erfolgreich abgesagt',
        'retrieve' => 'Erfolgreich abgerufen',
        'bed_assign_save' => 'Bettenzuweisung erfolgreich gespeichert.',
        'bed_assign_update' => 'Bettzuweisung erfolgreich aktualisiert.',
        'bed_assign_delete' => 'Bettzuweisung erfolgreich gelöscht.',
        'bed_saved' => 'Bett erfolgreich gespeichert.',
        'beds_saved' => 'Betten erfolgreich gespeichert.',
        'bed_retrieved' => 'Bett erfolgreich abgerufen.',
        'bed_updated' => 'Bett erfolgreich aktualisiert.',
        'bed_cant_deleted' => 'Bett kann nicht gelöscht werden.',
        'bed_deleted' => 'Bett erfolgreich gelöscht.',
        'bed_type_retrieved' => 'Betttyp erfolgreich abgerufen.',
        'bed_type_saved' => 'Betttyp erfolgreich gespeichert.',
        'bed_type_updated' => 'Betttyp erfolgreich aktualisiert.',
        'bed_type_not_found' => 'Betttyp nicht gefunden',
        'bed_type_cant_deleted' => 'Betttyp kann nicht gelöscht werden.',
        'bed_type_deleted' => 'Betttyp erfolgreich gelöscht.',
        'bill_saved' => 'Rechnung erfolgreich gespeichert.',
        'bill_updated' => 'Rechnung erfolgreich aktualisiert.',
        'bill_deleted' => 'Rechnung erfolgreich gelöscht.',
        'bill_retrieved' => 'Details erfolgreich abgerufen.',
        'birth_report_saved' => 'Geburtsbericht erfolgreich gespeichert.',
        'birth_report_updated' => 'Geburtsbericht erfolgreich aktualisiert.',
        'birth_report_retrieved' => 'Geburtsbericht erfolgreich abgerufen.',
        'birth_report_deleted' => 'Geburtsbericht erfolgreich gelöscht.',
        'blood_group_saved' => 'Blutgruppe erfolgreich gespeichert.',
        'blood_group_updated' => 'Blutgruppe erfolgreich aktualisiert.',
        'blood_bank_retrieved' => 'Blutbank erfolgreich abgerufen.',
        'blood_bank_cant_deleted' => 'Blutbank kann nicht gelöscht werden.',
        'blood_bank_updated' => 'Blutbank erfolgreich aktualisiert.',
        'blood_bank_deleted' => 'Blutbank erfolgreich gelöscht.',
        'blood_donation_saved' => 'Blutspende erfolgreich gespeichert.',
        'blood_donation_retrieved' => 'Blutspende erfolgreich abgerufen.',
        'blood_donation_updated' => 'Blutspende erfolgreich aktualisiert.',
        'blood_donation_deleted' => 'Blutspende erfolgreich gelöscht.',
        'blood_donor_saved' => 'Blutspender erfolgreich gespeichert.',
        'blood_donor_retrieved' => 'Blutspender erfolgreich abgerufen.',
        'blood_donor_updated' => 'Blutspender erfolgreich aktualisiert.',
        'blood_donor_cant_delete' => 'Blutspender kann nicht gelöscht werden.',
        'blood_donor_delete' => 'Blutspender erfolgreich gelöscht.',
        'blood_issue_saved' => 'Blutproblem erfolgreich gespeichert.',
        'blood_issue_updated' => 'Blutproblem erfolgreich aktualisiert.',
        'blood_issue_retrieved' => 'Blutproblem erfolgreich gefunden.',
        'blood_issue_deleted' => 'Blutproblem erfolgreich gelöscht.',
        'blood_group_retrieved' => 'Blutgruppe erfolgreich abgerufen.',
        'medicine_brand_saved' => 'Medikamentenmarke erfolgreich gespeichert.',
        'medicine_brand_updated' => 'Medizinmarke erfolgreich aktualisiert.',
        'medicine_brand_cant_deleted' => 'Medizinmarke kann nicht gelöscht werden.',
        'medicine_brand_deleted' => 'Arzneimittelmarke erfolgreich gelöscht.',
        'call_log_saved' => 'Anrufliste erfolgreich gespeichert.',
        'call_log_updated' => 'Anrufliste erfolgreich aktualisiert.',
        'call_log_deleted' => 'Anrufliste erfolgreich gelöscht.',
        'case_handler_saved' => 'Fallbearbeiter erfolgreich gespeichert.',
        'case_handler_updated' => 'Fallbearbeiter erfolgreich aktualisiert.',
        'case_handler_cant_deleted' => 'Fallbearbeiter kann nicht gelöscht werden.',
        'case_handler_deleted' => 'Fallbearbeiter erfolgreich gelöscht.',
        'notification_read' => 'Benachrichtigung erfolgreich gelesen.',
        'all_notification_read' => 'Alle Benachrichtigungen erfolgreich gelesen.',
        'request_pending' => 'Ihre manuellen Transaktionsanfragen ausstehend.',
        'manual_payment_approved' => 'Manuelle Zahlung erfolgreich genehmigt.',
        'manual_payment_denied' => 'Manuelle Zahlung erfolgreich verweigert.',
        'payment_gateway_updated' => 'Zahlungsgateway erfolgreich aktualisiert.',
        'payment_saved' => 'Zahlung erfolgreich gespeichert.',
        'payment_updated' => 'Zahlung erfolgreich aktualisiert.',
        'payment_deleted' => 'Zahlung erfolgreich gelöscht.',
        'payment_retrieved' => 'Zahlung erfolgreich abgerufen.',
        'medicine_saved' => 'Medizin erfolgreich gespeichert.',
        'medicine_updated' => 'Medizin erfolgreich aktualisiert.',
        'medicine_deleted' => 'Medizin erfolgreich gelöscht.',
        'medicine_retrieved' => 'Medizin erfolgreich abgerufen.',
        'pathology_test_saved' => 'Pathologietest erfolgreich gespeichert.',
        'pathology_test_updated' => 'Pathologietest erfolgreich aktualisiert.',
        'pathology_test_deleted' => 'Pathologietest erfolgreich gelöscht.',
        'pathology_test_retrieved' => 'Pathologietest erfolgreich abgerufen.',
        'patient_admission_saved' => 'Patientenaufnahme erfolgreich gespeichert.',
        'patient_admission_updated' => 'Patientenaufnahme erfolgreich aktualisiert.',
        'patient_admission_cant_deleted' => 'Patientenaufnahme kann nicht gelöscht werden.',
        'patient_admission_deleted' => 'Patientenaufnahme erfolgreich gelöscht.',
        'patient_admission_retrieved' => 'Patientenaufnahme erfolgreich abgerufen.',
        'Patient_saved' => 'Patient erfolgreich gespeichert.',
        'Patient_updated' => 'Patient erfolgreich aktualisiert.',
        'Patient_cant_deleted' => 'Patient kann nicht gelöscht werden.',
        'Patient_deleted' => 'Patient erfolgreich gelöscht.',
        'case_saved' => 'Fall erfolgreich gespeichert.',
        'case_updated' => 'Fall erfolgreich aktualisiert.',
        'case_cant_deleted' => 'Fall kann nicht gelöscht werden.',
        'case_deleted' => 'Fall erfolgreich gelöscht.',
        'case_retrieved' => 'Fall erfolgreich abgerufen.',
        'notice_board_saved' => 'Notizenbrett erfolgreich gespeichert.',
        'notice_board_retrieved' => 'Das Schwarze Brett wurde erfolgreich abgerufen.',
        'notice_board_updated' => 'Das Schwarze Brett wurde erfolgreich aktualisiert.',
        'notice_board_deleted' => 'Schwarzes Brett erfolgreich gelöscht.',
        'medicine_category_saved' => 'Medizinkategorie erfolgreich gespeichert.',
        'medicine_category_not_found' => 'Medizinkategorie nicht gefunden',
        'medicine_category_retrieved' => 'Medizinkategorie erfolgreich abgerufen.',
        'medicine_category_cant_deleted' => 'Medizinkategorie kann nicht gelöscht werden.',
        'medicine_category_deleted' => 'Medikamentenkategorie erfolgreich gelöscht.',
        'medicine_category_updated' => 'Medizinkategorie erfolgreich aktualisiert.',
        'Standard_charge_retrieved' => 'StandardCharge erfolgreich abgerufen.',
        'charge_saved' => 'Gebühr erfolgreich gespeichert.',
        'charge_retrieved' => 'Gebühr erfolgreich abgerufen.',
        'charge_updated' => 'Gebühr erfolgreich aktualisiert.',
        'charge_deleted' => 'Gebühr erfolgreich gelöscht.',
        'radiology_test_saved' => 'Radiologietest erfolgreich gespeichert.',
        'radiology_test_updated' => 'Radiologietest erfolgreich aktualisiert.',
        'radiology_test_deleted' => 'Radiologietest erfolgreich gelöscht.',
        'radiology_test_retrieved' => 'Radiologietest erfolgreich abgerufen.',
        'item_returned' => 'Artikel erfolgreich zurückgegeben.',
        'issued_item_saved' => 'Ausgestellter Artikel erfolgreich gespeichert.',
        'issued_item_deleted' => 'Ausgestellter Artikel erfolgreich gelöscht.',
        'charge_category_saved' => 'Kostenkategorie erfolgreich gespeichert.',
        'charge_category_not_found' => 'Gebührenkategorie nicht gefunden',
        'charge_category_retrieved' => 'Gebührenkategorie erfolgreich abgerufen.',
        'charge_category_updated' => 'Kostenkategorie erfolgreich aktualisiert.',
        'charge_category_cant_deleted' => 'Gebührenkategorie kann nicht gelöscht werden.',
        'charge_category_deleted' => 'Kostenkategorie erfolgreich gelöscht.',
        'radiology_category_saved' => 'Radiologiekategorie erfolgreich gespeichert.',
        'radiology_category_retrieved' => 'Radiologiekategorie erfolgreich abgerufen.',
        'radiology_category_updated' => 'Radiologiekategorie erfolgreich aktualisiert.',
        'radiology_category_cant_deleted' => 'Kategorie Radiologie kann nicht gelöscht werden.',
        'radiology_category_deleted' => 'Radiologiekategorie erfolgreich gelöscht.',
        'item_category_saved' => 'Artikelkategorie erfolgreich gespeichert.',
        'item_category_retrieved' => 'Artikelkategorie erfolgreich abgerufen.',
        'item_category_updated' => 'Artikelkategorie erfolgreich aktualisiert.',
        'item_category_cant_deleted' => 'Artikelkategorie kann nicht gelöscht werden.',
        'item_category_deleted' => 'Artikelkategorie erfolgreich gelöscht.',
        'pathology_category_saved' => 'Pathologiekategorie erfolgreich gespeichert.',
        'pathology_category_retrieved' => 'Pathologiekategorie erfolgreich abgerufen.',
        'pathology_category_updated' => 'Pathologiekategorie erfolgreich aktualisiert.',
        'pathology_category_cant_deleted' => 'Pathologiekategorie kann nicht gelöscht werden.',
        'pathology_category_deleted' => 'Pathologiekategorie erfolgreich gelöscht.',
        'live_status_retrieved' => 'Live-Status erfolgreich abgerufen.',
        'live_consultation_saved' => 'Live-Konsultation erfolgreich gespeichert.',
        'live_consultation_retrieved' => 'Live-Konsultation erfolgreich abgerufen.',
        'live_consultation_updated' => 'Live-Konsultation erfolgreich aktualisiert.',
        'live_consultation_deleted' => 'Live-Konsultation erfolgreich gelöscht.',
        'live_meeting_saved' => 'Live Meeting erfolgreich gespeichert.',
        'live_meeting_retrieved' => 'Live Meeting erfolgreich abgerufen.',
        'live_meeting_updated' => 'Live Meeting erfolgreich aktualisiert.',
        'live_meeting_deleted' => 'Live Meeting erfolgreich gelöscht.',
        'user_zoom_credential_retrieved' => 'Benutzer-Zoom-Anmeldeinformationen erfolgreich abgerufen.',
        'user_zoom_credential_saved' => 'Benutzer-Zoom-Anmeldedaten erfolgreich gespeichert.',
        'item_not_found' => 'Elemente nicht gefunden',
        'mail_sent' => 'Mail erfolgreich gesendet.',
        'item_saved' => 'Artikel erfolgreich gespeichert.',
        'item_updated' => 'Element erfolgreich aktualisiert.',
        'item_cant_deleted' => 'Element kann nicht gelöscht werden.',
        'item_deleted' => 'Element erfolgreich gelöscht.',
        'lab_technician_saved' => 'Labortechniker erfolgreich gespeichert.',
        'lab_technician_updated' => 'Labortechniker erfolgreich aktualisiert.',
        'lab_technician_cant_deleted' => 'Labortechniker kann nicht gelöscht werden.',
        'lab_technician_deleted' => 'Labortechniker erfolgreich gelöscht.',
        'nurse_saved' => 'Krankenschwester erfolgreich gespeichert.',
        'nurse_updated' => 'Krankenschwester erfolgreich aktualisiert.',
        'nurse_cant_deleted' => 'Krankenschwester kann nicht gelöscht werden.',
        'nurse_deleted' => 'Krankenschwester erfolgreich gelöscht.',
        'Pharmacist_saved' => 'Apotheker erfolgreich gespeichert.',
        'Pharmacist_updated' => 'Apotheker erfolgreich aktualisiert.',
        'Pharmacist_cant_deleted' => 'Apotheker kann nicht gelöscht werden.',
        'Pharmacist_deleted' => 'Apotheker erfolgreich gelöscht.',
        'package_saved' => 'Paket erfolgreich gespeichert.',
        'package_updated' => 'Paket erfolgreich aktualisiert.',
        'package_cant_deleted' => 'Paket kann nicht gelöscht werden.',
        'package_deleted' => 'Paket erfolgreich gelöscht.',
        'item_stock_saved' => 'Artikelbestand erfolgreich gespeichert.',
        'item_stock_updated' => 'Artikelbestand erfolgreich aktualisiert.',
        'item_stock_deleted' => 'Artikelbestand erfolgreich gelöscht.',
        'diagnosis_category_saved' => 'Diagnosekategorie erfolgreich gespeichert.',
        'diagnosis_category_not_found' => 'Diagnosekategorie nicht gefunden',
        'diagnosis_category_retrieved' => 'Diagnosekategorie erfolgreich abgerufen.',
        'diagnosis_category_updated' => 'Diagnosekategorie erfolgreich aktualisiert.',
        'diagnosis_category_cant_deleted' => 'Diagnosekategorie kann nicht gelöscht werden.',
        'diagnosis_category_deleted' => 'Diagnosekategorie erfolgreich gelöscht.',
        'death_report_saved' => 'Todesmeldung erfolgreich gespeichert.',
        'death_report_retrieved' => 'Todesmeldung erfolgreich abgerufen.',
        'death_report_updated' => 'Todesmeldung erfolgreich aktualisiert.',
        'death_report_deleted' => 'Todesmeldung erfolgreich gelöscht.',
        'department_saved' => 'Abteilung erfolgreich gespeichert.',
        'department_retrieved' => 'Abteilung erfolgreich abgerufen.',
        'department_updated' => 'Abteilung erfolgreich aktualisiert.',
        'department_deleted' => 'Abteilung erfolgreich gelöscht.',
        'doctor_department_saved' => 'Arztabteilung erfolgreich gespeichert.',
        'doctor_department_not_found' => 'Arztabteilung nicht gefunden',
        'doctor_department_retrieved' => 'Ärzteabteilung erfolgreich abgerufen.',
        'doctor_department_updated' => 'Ärzteabteilung erfolgreich aktualisiert.',
        'doctor_department_cant_deleted' => 'Arztabteilung kann nicht gelöscht werden.',
        'doctor_department_deleted' => 'Arztabteilung erfolgreich gelöscht.',
        'patient_diagnosis_saved' => 'Patientendiagnose erfolgreich gespeichert.',
        'patient_diagnosis_updated' => 'Patientendiagnose erfolgreich aktualisiert.',
        'patient_diagnosis_deleted' => 'Patientendiagnose erfolgreich gelöscht.',
        'users_not_found' => 'Benutzer nicht gefunden',
        'user_saved' => 'Benutzer erfolgreich gespeichert.',
        'user_deleted' => 'Benutzer erfolgreich gelöscht.',
        'user_updated' => 'Benutzer erfolgreich aktualisiert.',
        'posts_not_found' => 'Beiträge nicht gefunden',
        'post_saved' => 'Beitrag erfolgreich gespeichert.',
        'post_deleted' => 'Beitrag erfolgreich gelöscht.',
        'post_state_updated' => 'Beitrag erfolgreich aktualisiert.',
        'doctor_save' => 'Doktor erfolgreich gespeichert.',
        'doctor_not_found' => 'Arzt nicht gefunden',
        'doctor_update' => 'Doktor erfolgreich aktualisiert.',
        'doctor_cant_deleted' => 'Arzt kann nicht gelöscht werden.',
        'doctor_delete' => 'Arzt erfolgreich gelöscht.',
        'OPD_charge_saved' => 'Doctor OPD Charge erfolgreich gespeichert.',
        'OPD_charge_retrieved' => 'OPD-Gebühr des Arztes erfolgreich abgerufen.',
        'OPD_charge_updated' => 'Doctor OPD Charge erfolgreich aktualisiert.',
        'OPD_charge_deleted' => 'Doctor OPD Charge erfolgreich gelöscht.',
        'operation_report_saved' => 'Betriebsbericht erfolgreich gespeichert.',
        'operation_report_retrieved' => 'Betriebsbericht erfolgreich abgerufen.',
        'operation_report_updated' => 'Betriebsbericht erfolgreich aktualisiert.',
        'operation_report_deleted' => 'Operation Report erfolgreich gelöscht.',
        'OPD_diagnosis_saved' => 'OPD-Diagnose erfolgreich gespeichert.',
        'OPD_diagnosis_retrieved' => 'OPD-Diagnose erfolgreich abgerufen.',
        'OPD_diagnosis_updated' => 'OPD-Diagnose erfolgreich aktualisiert.',
        'OPD_diagnosis_deleted' => 'OPD-Diagnose erfolgreich gelöscht.',
        'OPD_timeline_saved' => 'OPD-Zeitachse erfolgreich gespeichert.',
        'OPD_timeline_retrieved' => 'OPD-Zeitachse erfolgreich abgerufen.',
        'OPD_timeline_updated' => 'OPD-Zeitachse erfolgreich aktualisiert.',
        'OPD_timeline_deleted' => 'OPD-Zeitachse erfolgreich gelöscht.',
        'OPD_Patient_saved' => 'OPD Patient erfolgreich gespeichert.',
        'OPD_Patient_updated' => 'OPD Patient erfolgreich aktualisiert.',
        'OPD_Patient_deleted' => 'OPD Patient erfolgreich gelöscht.',
        'IPD_charge_saved' => 'IPD Charge erfolgreich gespeichert.',
        'IPD_charge_retrieved' => 'IPD-Gebühr erfolgreich abgerufen.',
        'IPD_charge_updated' => 'IPD Charge erfolgreich aktualisiert.',
        'IPD_charge_deleted' => 'IPD Charge erfolgreich gelöscht.',
        'IPD_diagnosis_saved' => 'IPD-Diagnose erfolgreich gespeichert.',
        'IPD_diagnosis_retrieved' => 'IPD-Diagnose erfolgreich abgerufen.',
        'IPD_diagnosis_updated' => 'IPD-Diagnose erfolgreich aktualisiert.',
        'IPD_diagnosis_deleted' => 'IPD-Diagnose erfolgreich gelöscht.',
        'IPD_Patient_saved' => 'IPD Patient erfolgreich gespeichert.',
        'IPD_Patient_updated' => 'IPD Patient erfolgreich aktualisiert.',
        'IPD_Patient_deleted' => 'IPD Patient erfolgreich gelöscht.',
        'IPD_consultant_saved' => 'IPD-Berateranleitung erfolgreich gespeichert.',
        'IPD_consultant_retrieved' => 'IPD-Berateranleitung erfolgreich abgerufen.',
        'IPD_consultant_updated' => 'IPD-Berateranleitung erfolgreich aktualisiert.',
        'IPD_consultant_deleted' => 'IPD-Berateranleitung erfolgreich gelöscht.',
        'IPD_Prescription_saved' => 'IPD-Rezept erfolgreich gespeichert.',
        'IPD_Prescription_retrieved' => 'IPD-Rezept erfolgreich abgerufen.',
        'IPD_Prescription_updated' => 'IPD-Rezept erfolgreich aktualisiert.',
        'IPD_Prescription_deleted' => 'IPD-Rezept erfolgreich gelöscht.',
        'prescription_saved' => 'Rezept erfolgreich gespeichert.',
        'prescription_not_found' => 'Rezept nicht gefunden',
        'prescription_retrieved' => 'Rezept erfolgreich abgerufen.',
        'prescription_updated' => 'Rezept erfolgreich aktualisiert.',
        'prescription_deleted' => 'Rezept erfolgreich gelöscht.',
        'setting_updated' => 'Einstellung erfolgreich aktualisiert.',
        'service_saved' => 'Dienst erfolgreich gespeichert.',
        'service_not_found' => 'Service nicht gefunden',
        'service_updated' => 'Dienst erfolgreich aktualisiert.',
        'service_cant_deleted' => 'Diensttyp kann nicht gelöscht werden.',
        'service_deleted' => 'Dienst erfolgreich gelöscht.',
        'IPD_payment_saved' => 'IPD-Zahlung erfolgreich gespeichert.',
        'IPD_payment_retrieved' => 'IPD-Zahlung erfolgreich abgerufen.',
        'IPD_payment_updated' => 'IPD-Zahlung erfolgreich aktualisiert.',
        'IPD_payment_deleted' => 'IPD-Zahlung erfolgreich gelöscht.',
        'IPD_timeline_saved' => 'IPD-Zeitachse erfolgreich gespeichert.',
        'IPD_timeline_retrieved' => 'IPD-Zeitachse erfolgreich abgerufen.',
        'IPD_timeline_updated' => 'IPD-Zeitachse erfolgreich aktualisiert.',
        'IPD_timeline_deleted' => 'IPD-Zeitachse erfolgreich gelöscht.',
        'document_saved' => 'Dokument erfolgreich gespeichert.',
        'document_retrieved' => 'Dokument erfolgreich abgerufen.',
        'document_updated' => 'Dokument erfolgreich aktualisiert.',
        'document_deleted' => 'Dokument erfolgreich gelöscht.',
        'expense_saved' => 'Kosten erfolgreich gespeichert.',
        'expense_retrieved' => 'Kosten erfolgreich abgerufen.',
        'expense_updated' => 'Kosten erfolgreich aktualisiert.',
        'expense_deleted' => 'Kosten erfolgreich gelöscht.',
        'income_saved' => 'Einkommen erfolgreich gespeichert',
        'income_retrieved' => 'Einkommen erfolgreich abgerufen.',
        'income_updated' => 'Einkommen erfolgreich aktualisiert.',
        'income_deleted' => 'Einnahmen erfolgreich gelöscht.',
        'visitor_saved' => 'Besucher erfolgreich gespeichert.',
        'visitor_updated' => 'Besucher erfolgreich aktualisiert.',
        'visitor_deleted' => 'Besucher erfolgreich gelöscht.',
        'vaccinated_patients_saved' => 'Geimpfte Patienten erfolgreich gespeichert.',
        'vaccinated_patients_retrieved' => 'Geimpfte Patienten erfolgreich gefunden.',
        'vaccinated_patients_updated' => 'Geimpfte Patienten erfolgreich aktualisiert.',
        'vaccinated_patients_deleted' => 'Geimpfte Patienten erfolgreich gelöscht.',
        'vaccination_saved' => 'Impfung erfolgreich gespeichert.',
        'vaccination_retrieved' => 'Impfung erfolgreich abgerufen.',
        'vaccination_updated' => 'Impfung erfolgreich aktualisiert.',
        'vaccination_cant_deleted' => 'Impfung kann nicht gelöscht werden',
        'vaccination_deleted' => 'Impfung erfolgreich gelöscht.',
        'invoice_saved' => 'Rechnung erfolgreich gespeichert.',
        'invoice_updated' => 'Rechnung erfolgreich aktualisiert.',
        'invoice_deleted' => 'Rechnung erfolgreich gelöscht.',
        'insurance_saved' => 'Versicherung erfolgreich gespeichert.',
        'invoice_id_already_exist' => 'Rechnungs-ID existiert bereits',
        'insurance_updated' => 'Versicherung erfolgreich aktualisiert.',
        'insurance_cant_deleted' => 'Versicherungsart kann nicht gelöscht werden.',
        'insurance_deleted' => 'Versicherung erfolgreich gelöscht.',
        'receptionist_saved' => 'Rezeption erfolgreich gespeichert.',
        'receptionist_updated' => 'Empfangsdame erfolgreich aktualisiert.',
        'receptionist_cant_deleted' => 'Empfangstyp kann nicht gelöscht werden.',
        'receptionist_deleted' => 'Empfangsdame erfolgreich gelöscht.',
        'schedule_saved' => 'Zeitplan erfolgreich gespeichert.',
        'schedule_updated' => 'Zeitplan erfolgreich aktualisiert.',
        'schedule_cant_deleted' => 'Zeitplantyp kann nicht gelöscht werden.',
        'schedule_deleted' => 'Zeitplan erfolgreich gelöscht.',
        'frontService_saved' => 'FrontService erfolgreich gespeichert.',
        'frontService_retrieved' => 'FrontService erfolgreich abgerufen.',
        'frontService_updated' => 'FrontService erfolgreich aktualisiert.',
        'frontService_deleted' => 'FrontService erfolgreich gelöscht.',
        'front_setting_updated' => 'Vordereinstellung erfolgreich aktualisiert.',
        'order_created' => 'Bestellung erfolgreich erstellt.',
        'FAQs_created' => 'FAQs erfolgreich erstellt.',
        'FAQs_retrieved' => 'FAQs erfolgreich abgerufen.',
        'FAQs_updated' => 'FAQs erfolgreich aktualisiert.',
        'FAQs_deleted' => 'FAQs erfolgreich gelöscht.',
        'income_and_expense_retrieved' => 'Einnahmen- und Ausgabenabrechnung erfolgreich abgerufen.',
        'income_report_generate' => 'Ertragsbericht erfolgreich erstellt.',
        'hospital_saved' => 'Krankenhaus erfolgreich gespeichert.',
        'hospital_schedule_saved' => 'Krankenhausplan erfolgreich gespeichert.',
        'hospital_update' => 'Krankenhaus erfolgreich aktualisiert.',
        'IPD_bill_saved' => 'IPD-Rechnung erfolgreich gespeichert.',
        'document_type_saved' => 'Dokumenttyp erfolgreich gespeichert.',
        'document_type_not_found' => 'Dokumenttyp nicht gefunden',
        'document_type_retrieved' => 'Dokumenttyp erfolgreich abgerufen.',
        'document_type_updated' => 'Dokumenttyp erfolgreich aktualisiert.',
        'document_type_cant_deleted' => 'Dokumenttyp kann nicht gelöscht werden.',
        'document_type_deleted' => 'Dokumenttyp erfolgreich gelöscht.',
        'subscription_plan_saved' => 'Abonnement erfolgreich erstellt.',
        'subscription_plan_retrieved' => 'Abonnementplan erfolgreich abgerufen.',
        'subscription_plan_updated' => 'Abonnement erfolgreich aktualisiert.',
        'subscription_plan_cant_deleted' => 'Abonnementplan kann nicht gelöscht werden.',
        'subscription_plan_deleted' => 'Abo erfolgreich gelöscht.',
        'employee_payroll_saved' => 'Personalabrechnung erfolgreich gespeichert.',
        'employee_payroll_updated' => 'Mitarbeiter-Gehaltsabrechnung erfolgreich aktualisiert.',
        'employee_payroll_deleted' => 'Mitarbeiter-Gehaltsabrechnung erfolgreich gelöscht.',
        'employee_list_not_found' => 'Mitarbeiterliste nicht gefunden',
        'employee_payroll_retrieved' => 'Mitarbeiter-Lohnabrechnung erfolgreich abgerufen.',
        'enquiry_send' => 'Anfrage erfolgreich gesendet.',
        'enquiry_delete' => 'Anfrage erfolgreich gelöscht.',
        'testimonial_save' => 'Testimonial erfolgreich gespeichert.',
        'testimonial_retrieve' => 'Testimonial erfolgreich abgerufen.',
        'testimonial_update' => 'Testimonial erfolgreich aktualisiert.',
        'testimonial_delete' => 'Testimonial erfolgreich gelöscht.',
        'new_tenant_assigned' => 'Neuer Mieter erfolgreich zugewiesen',
        'password_update' => 'Passwort erfolgreich aktualisiert.',
        'profile_update' => 'Profil erfolgreich aktualisiert.',
        'data_retrieved' => 'Daten erfolgreich abgerufen.',
        'subscription_created' => 'Abonnement erfolgreich erstellt.',
        'subscription_updated' => 'Abonnement erfolgreich aktualisiert.',
        'subscription_retrieved' => 'Abonnement erfolgreich abgerufen.',
        'postal_receive_saved' => 'Postempfang erfolgreich gespeichert.',
        'postal_dispatch_saved' => 'Postversand erfolgreich gespeichert.',
        'postal_dispatch_deleted' => 'Postversand erfolgreich gelöscht.',
        'postal_receive_retrieved' => 'Postempfang erfolgreich abgerufen.',
        'postal_dispatch_retrieved' => 'Postversand erfolgreich abgerufen.',
        'postal_receive_update' => 'Update erfolgreich per Post erhalten',
        'postal_receive_deleted' => 'Posteingang erfolgreich gelöscht.',
        'postal_dispatch_update' => 'Update Postversand erfolgreich',
        'postal_deleted' => 'Post erfolgreich gelöscht.',
        'investigation_report_saved' => 'Untersuchungsbericht erfolgreich gespeichert.',
        'investigation_report_not_found' => 'Untersuchungsbericht nicht gefunden',
        'investigation_report_updated' => 'Untersuchungsbericht erfolgreich aktualisiert.',
        'investigation_report_deleted' => 'Untersuchungsbericht erfolgreich gelöscht.',
        'sms_limit_over' => 'Das SMS-Limit Ihres aktuellen Plans ist abgelaufen.',
        'sms_send' => 'SMS erfolgreich versendet.',
        'sms_delete' => 'SMS erfolgreich löschen',
        'user_list_not' => 'Benutzerliste nicht gefunden',
        'user_retrieved' => 'Benutzer erfolgreich abgerufen.',
        'language_update' => 'Sprache erfolgreich aktualisiert.',
        'sms_retrieved' => 'SMS abgerufen',
        'default_plan_changed' => 'Standardplan erfolgreich geändert.',
        'session_created' => 'Sitzung erfolgreich erstellt.',
        'your_payment_success' => 'Ihre Zahlung wurde erfolgreich abgeschlossen',
        'email_verified' => 'E-Mail erfolgreich verifiziert.',
        'cannot_switch' => 'Kann nicht zum Nullplan wechseln, wenn eine Testversion verfügbar ist / einen kostenpflichtigen Plan hat, der ist currently active',
        'some_doctors' => 'Einige Ärzte haben ihre Tage an bestimmten ungeprüften Tagen angesetzt, also sind Sie sich sicher Sie möchten diesen Vorgang ausführen?',
        'currency_not_supported_paypal' => 'Diese Währung wird von PayPal nicht für Zahlungen unterstützt.',
        'currency_not_supported_razorpay' => 'Diese Währung wird von Razorpay nicht für Zahlungen unterstützt.',
        'unable_to_process' => 'Die Zahlung kann im Moment nicht bearbeitet werden. Versuchen Sie es später noch einmal.',
        'the_patient' => 'Der Patient ist bereits mit demselben Impfstoff und derselben Dosisnummer registriert.',
        'opd_diagnosis_report_generated' => 'Diagnosebericht erfolgreich erstellt.',
        'failed_to_redirect' => 'Umleitung fehlgeschlagen',
        'access_denied' => 'Zugriff verweigert',
        'patient_smart_card_deleted' => 'Patienten-Smartcard erfolgreich gelöscht.',
        'smart_patient_card_template_already_in_use' => 'Smart-Patientenkarten-Vorlage wird bereits verwendet.',
        'please_select_header_color' => 'Bitte wählen Sie die Farbe der Kopfzeile aus',
    ],

    'purchase_medicine' => [
        'purchase_number' => 'Kaufnummer',
        'total' => 'Gesamt',
        'discount' => 'Rabatt',
        'tax_amount' => 'Steuerbetrag',
        'net_amount' => 'Netto-Betrag',
        'payment_mode' => 'Zahlungsart',
        'payment_note' => 'Zahlungshinweis',
        'note' => 'Note',
        'purchase_medicine' => 'Kaufen Sie Medikamente',
        'purchase_medicine_details' => 'Details zum Kauf von Medikamenten',
        'purchase_medicine_overview' => 'Übersicht über den Kauf von Arzneimitteln',
        'lot_no' => 'Lot-Nr.',
        'tax' => 'Steuer',
        'quantity' => 'Menge',
        'amount' => 'Menge',
        'expiry_date' => 'Verfallsdatum',
        'other_details' => 'Andere Details',
        'dose_duration' => 'Dosisdauer',
    ],

    'used_medicine' => [
        'used_medicine' => 'Gebrauchte Medizin',
        'used_quantity' => 'Gebrauchte Menge',
        'used_at' => 'Verwendet bei',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'Arzneimittelrechnungen',
        'medicine_bill' => 'Medizingesetz',
        'edit_medicine_bill' => 'Bearbeiten Sie das Arzneimittelgesetz',
        'medicine_bill_details' => 'Einzelheiten zum Arzneimittelgesetz',
        'dose_interval' => 'Dosisintervall',
        'available_quantity' => 'Die verfügbare Menge von',
        'is' => 'Ist',
        'prescription_not_found' => 'Rezept nicht gefunden.',
        'medicine_not_selected' => 'Bitte wählen Sie mindestens ein Arzneimittel aus.',
        'duplicate_medicine' => 'Es können keine doppelten Medikamente hinzugefügt werden.',
        'payment_status' => 'Zahlungsstatus',
        'sale_price' => 'Verkaufspreis',
        'add_medicine_bill' => 'Arzneimittelrechnung hinzufügen',
        'select_medicine' => 'Wählen Sie Medizin',
        'update_quantity' => 'Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge.',
        'net_amount_not_empty' => 'Der Nettobetrag darf nicht leer sein.',
        'net_amount_not_zero' => 'Der Nettobetrag darf nicht Null sein.',
        'medicine_required' => 'Fachrichtung Medizin ist erforderlich.',
        'bill_number' => 'Rechnungsnummer',
        'connect_with_zoom' => 'Verbinden Sie sich mit Zoom',
        'connected' => 'In Verbindung gebracht',
    ],

    'service_slider' => [
        'service_slider_image' => 'Service-Slider-Bild',
        'add_service_slider' => 'Fügen Sie ein Service-Slider-Bild hinzu',
        'edit_service_slider' => 'Bearbeiten Sie das Service-Slider-Bild',
        'img_tooltip_text' => 'Die beste Auflösung für dieses Bild ist 140x50',
    ],

    'new_change' => [
        'current_password_invalid' => 'Das aktuelle Passwort ist ungültig.',
        'captcha_verification_failed' => 'Überprüfung des Captchas fehlgeschlagen.',
        'paystack_created' => 'Paystack erfolgreich erstellt.',
        'unique_vehicle_number' => 'Die Fahrzeugnummer ist bereits vergeben.',
        'unique_patient' => 'Der Name des Patienten ist bereits vergeben.',
        'select_appointment_date' => 'Bitte wählen Sie den Termin aus.',
        'select_time_slot' => 'Bitte wählen Sie den Termintermin aus.',
        'pending_payment' => 'Ausstehende Zahlung',
        'have_to_connect_zoom' => 'Sie müssen eine Verbindung mit Zoom herstellen.',
        'invalid_token' => 'Inkorrekter Zugangscode.',
        'in_progress' => 'Leider können Sie diese Besprechung nicht löschen, da sie noch läuft.',
        'add_credential' => 'Bitte fügen Sie Anmeldeinformationen für das Zoom-Meeting hinzu.',
        'already_in_use' => 'Ihre Zoom-Zugangsdaten werden bereits verwendet.',
        'all_required_fields' => 'Bitte füllen Sie alle erforderlichen Felder aus.',
        'password_not_match' => 'Passwort und Passwort bestätigen stimmen nicht überein.',
        'subscribed_success' => 'Erfolgreich abonniert.',
        'not_have_account' => 'Sie haben kein Konto',
        'google_captcha_required' => 'Das Google reCaptcha-Feld ist erforderlich.',
        'captcha_failed' => 'Die Captcha-Überprüfung ist fehlgeschlagen',
        'case_required' => 'Das Fallfeld ist erforderlich.',
        'bed_required' => 'Das Bettfeld ist erforderlich.',
        'best_resolution_profile' => 'Die beste Auflösung für dieses Profil wird sein',
        'best_resolution_icon' => 'Die beste Auflösung für dieses Symbol ist',
        'best_resolution_image' => 'Die beste Auflösung für dieses Bild ist',
        'select_ipd_patient' => 'Wählen Sie IPD-Patient aus',
        'currency_update' => 'Währung erfolgreich aktualisiert',
        'currency_store' => 'Währung erfolgreich gespeichert',
        'plan_price' => 'Planpreis',
        'new_plan' => 'Neuer Plan',
        'pre_plan' => 'Verbleibender Saldo der vorherigen Planen',
        'payable_amount' => 'Zu zahlender Betrag',
        'remaining_days' => 'Verbleibende Tage',
        'used_balance' => 'Gebrauchtes Guthaben',
        'current_plan' => 'Derzeitiger Plan',
        'current_expired_plan' => 'Aktueller abgelaufener Plan',
        'sunday' => 'Sonntag',
        'monday' => 'Montag',
        'tuesday' => 'Dienstag',
        'wednesday' => 'Mittwoch',
        'thursday' => 'Donnerstag',
        'friday' => 'Freitag',
        'saturday' => 'Samstag',
        'service_slider_store' => 'Service-Slider-Bild erfolgreich erstellt.',
        'service_slider_update' => 'Das Bild des Service-Sliders wurde erfolgreich aktualisiert.',
        'captcha_key' => 'Google Captcha-Schlüssel',
        'captcha_secret' => 'Google Captcha-Geheimnis',
        'change_image' => 'Bild ändern',
        'allow_img_text_extra' => 'Zulässige Dateitypen: PNG, JPG, GIF, JPEG, SVG, WebP.',
        'sms_limit' => 'SMS-Limit',
        'enter_sms-limit' => 'Geben Sie das SMS-Limit ein',
        'no_records_found' => 'Keine Datensätze gefunden.',

        'bed_distinct' => 'Das Feld „Bett“ hat einen doppelten Wert.',
        'bed_unique' => 'Die Bed :-Eingabe wurde bereits übernommen.',
        'name_unique' => 'Der Name ist bereits vergeben.',
        'charge_number' => 'Die Ladung muss eine Nummer sein.',
        'charge_regex' => 'Die Gebühr muss ein gültiges Format haben.',
        'password_min' => 'Das Passwort muss mindestens 6 Zeichen enthalten.',
        'password_same' => 'Das Passwort und das Bestätigungspasswort müssen übereinstimmen.',
        'bed_required' => 'Das Bettfeld ist erforderlich.',
        'slug_unique' => 'Die Krankenhausschnecke wurde bereits genommen.',
        'service_image_required' => 'Das Feld „Servicebild-Schieberegler“ ist erforderlich.',
        'email_subscribe' => 'Die E-Mail wurde bereits abonniert.',
        'admission_required' => 'Das Feld „Zulassungs-ID“ ist erforderlich.',
        'one_patient' => 'Bitte wählen Sie mindestens einen Patienten aus.',
        'category_required' => 'Das Feld „Kategorie“ ist erforderlich.',
        'brand_required' => 'Das Feld „Marke“ ist erforderlich.',
        'card_one_char' => 'Der Sekundärtext der Karte darf nicht länger als 90 Zeichen sein',
        'pathology_units' => 'Pathologische Einheiten',
        'pathology_unit' => 'Abteilung für Pathologie',
        'add_unit' => 'Neue Abteilung für Pathologie',
        'edit_unit' => 'Abteilung Pathologie bearbeiten',
        'pathology_unit_not_found' => 'Pathologieeinheit nicht gefunden',
        'pathology_unit_cant_deleted' => 'Die Pathologieeinheit kann nicht gelöscht werden.',
        'pathology_parameter_not_found' => 'Pathologieparameter nicht gefunden',
        'pathology_parameter_cant_deleted' => 'Der Pathologieparameter kann nicht gelöscht werden.',
        'pathology_parameter' => 'Pathologieparameter',
        'pathology_parameters' => 'Pathologische Parameter',
        'add_parameter' => 'Neuer Pathologieparameter',
        'edit_parameter' => 'Pathologieparameter bearbeiten',
        'parameter_name_required' => 'Das Feld „Parametername“ ist erforderlich.',
        'patient_result_required' => 'Das Feld „Patientenergebnis“ ist erforderlich.',
        'parameter_name' => 'Parametername',
        'patient_result' => 'Patientenergebnis',
        'select_parameter_name' => 'Wählen Sie Parametername',
        'reference_range' => 'Referenzbereich',
        'select_unit' => 'Wählen Sie Einheit',
        'back_to_main_site' => 'Zurück zur Hauptseite',
        'added_at' => 'Hinzugefügt am',
        'print_pathology_test' => 'Pathologietest drucken',
        'pathology_test_report' => 'Pathologischer Testbericht',

        'default_admin_not_delete' => 'Der Standard-SuperAdmin kann nicht gelöscht werden.',
        'notify_mail_for_patient_book' => 'Benachrichtigungsmail für vom Patienten gebuchten Termin',
        'currency_setting_not_found' => 'Währungseinstellung nicht gefunden',
        'default_currency_not_delete' => 'Die Standardwährung kann nicht gelöscht werden',
        'time_invalid' => 'Die Startzeit des Tages ist ungültig',
        'hospital_not_delete' => 'Der Krankenhaustyp kann nicht gelöscht werden.',
        'patient_invoice_bill' => 'Patientenrechnung',
        'patient_mail_send' => 'Patientenrechnungsmail erfolgreich versendet.',
        'is' => 'Ist',
        'staff_limit' => 'Das maximale Personalzusatzlimit beträgt 10.',
        'medicine_bill_already_use' => 'Dieses Arzneimittel wird bereits in Arzneimittelrechnungen verwendet. Möchten Sie es wirklich löschen?',
        'not_in_use' => 'Nicht in Gebrauch',
        'paystack_support_zar' => 'Paystack unterstützte nur die Währung ZAR.',
        'payment_fail' => 'Die Zahlung ist aus irgendeinem Grund fehlgeschlagen',
        'paystack_token_expired' => 'Der Paystack-Token ist abgelaufen. Bitte aktualisieren Sie die Seite und versuchen Sie es erneut.',
        'paytm_support_indian' => 'Paytm unterstützt nur die indische Währung.',
        'medicine_purchase_success' => 'Medikament erfolgreich gekauft',
        'provide_stripe_key' => 'Bitte geben Sie einen Stripe-Schlüssel an.',
        'currency_not_delete' => 'Die Währung kann nicht gelöscht werden.',
        'admin_not_delete' => 'Der Standardadministrator kann nicht gelöscht werden.',
        'slug_unique' => 'Die Krankenhauskugel wurde bereits genommen.',
        'subscription_mail' => 'Abo-Mail.',
        'hospital_register' => 'Benachrichtigungsmail für neu registriertes Krankenhaus',
        'appointment_with_doctor' => 'Sie haben einen Termin bei Dr.',
        'doctor_appointments' => 'Arzttermine',
        'enquiry_mail' => 'Anfragemail',
        'consultancy_create' => 'Neue Live-Beratung erstellt',
        'meeting_create' => 'Neues Live-Meeting erstellt',
        'hello' => 'Hallo',
        'dr.' => 'DR.',
        'reminder' => 'Dies dient nur dazu, Sie daran zu erinnern, dass Ihr Termin mit',
        'within_one_hour' => 'ist innerhalb der nächsten Stunde',
        'patient_problem' => 'Patientenproblem',
        'appointment_time' => 'Termin',
        'thanks_regards' => 'Danke und Grüße',
        'new_hospital_registerd' => 'In Ihrer Krankenhausliste wurde ein neues Krankenhaus eingetragen.',
        'hospital_contact' => 'Kontakt zum Krankenhaus',
        'prescription_report' => 'Rezeptbericht',
        'years' => 'Jahre',
        'patient_diagnosis_test_report' => 'Testbericht zur Patientendiagnose',
        'diagnosis_report_id' => 'ID des Patientendiagnoseberichts',
        'no_ipd_patient_found' => 'Kein IPD-Patient gefunden',
        'deduction_not_greater_than_salary' => 'Die Abzüge dürfen nicht höher sein als das Grundgehalt + Zulage',
        'terms_condition_required' => 'Die Allgemeinen Geschäftsbedingungen sind erforderlich.',
        'privacy_policy' => 'Die Datenschutzerklärung ist erforderlich.',
        'image_must_be' => 'Das Bild muss eine Datei des folgenden Typs sein: jpg, jpeg, png.',
        'field_not_contain_white_space' => 'Das Feld enthält nicht nur Leerzeichen',
        'document_must_be_file_type' => 'Das Dokument muss eine Datei des folgenden Typs sein: jpeg, jpg, png, pdf, doc, docx.',
        'select_code' => 'Wählen Sie Code aus',
        'select_item' => 'Menüpunkt wählen',
        'discount_less_than_amount' => 'Der Rabatt sollte geringer sein als der Gesamtbetrag.',
        'tax_less_100' => 'Die Steuern sollten weniger als 100 % betragen.',
        'quantity_not_empty' => 'Die Menge darf nicht Null oder leer sein.',
        'select_duration' => 'Wählen Sie Dauer aus',
        'select_dose_interval' => 'Wählen Sie Dosisintervall',
        'enter_lot_no' => 'Geben Sie die Chargennummer ein.',
        'tax_not_empty' => 'Der Steuerbetrag darf nicht Null oder leer sein.',
        'quantity_greater_than_0' => 'Die Menge sollte größer als 0 sein.',
        'enter_sale_price' => 'Geben Sie den Verkaufspreis ein.',
        'enter_purchase_price' => 'Kaufpreis eingeben.',
        'enter_quantity' => 'Bitte Menge eingeben.',
        'select_charge' => 'Wählen Sie „Aufladen“.',
        'charchter_160' => 'Die Nachricht darf nicht länger als 160 Zeichen sein.',
        'enter_captcha_key' => 'Bitte geben Sie den Google-Captcha-Schlüssel ein.',
        'enter_captcha_secret' => 'Bitte geben Sie das Google-Captcha-Geheimnis ein.',
        'paypal_client_id' => 'Bitte geben Sie die PayPal-Kunden-ID ein.',
        'paypal_secret' => 'Bitte geben Sie das PayPal-Geheimnis ein.',
        'paypal_mode' => 'Bitte wechseln Sie in den PayPal-Modus.',
        'razor_pay_secret' => 'Bitte geben Sie das Razorpay-Geheimnis ein.',
        'razorpay_key' => 'Bitte geben Sie den Razorpay-Schlüssel ein.',
        'stripe_secret' => 'Bitte geben Sie das Stripe-Geheimnis ein.',
        'stripe_key' => 'Bitte geben Sie Stripe Secret ein.',
        'paystack_key' => 'Bitte geben Sie den öffentlichen Paystack-Schlüssel ein.',
        'paystack_secret' => 'Bitte geben Sie den geheimen Paystack-Schlüssel ein.',
        'paytm_id' => 'Bitte geben Sie die Paytm-Händler-ID ein.',
        'paytm_key' => 'Bitte geben Sie den Paytm-Händlerschlüssel ein.',
        'sending' => 'Senden...',
        'warning' => 'Warnung !',
        'select_payment_gateway' => 'Wählen Sie Zahlungsgateway aus',
        'upcoming_appointments' => 'Kommende Termine',
        'expired' => 'Abgelaufen',
        'not_expired' => 'Nicht abgelaufen',
        'plan_expire_status' => 'Erlöschen',
        'select_plan_expire_status' => 'Wählen Sie „Ablaufen“.',
        'if_you_did_not_create_an_account' => 'Wenn Sie kein Konto erstellt haben, sind keine weiteren Schritte erforderlich.',
        'verify_email_address' => 'E-Mail-Adresse bestätigen',
        'click_the_button_below_to_verify_your_email_address' => 'Bitte klicken Sie auf die Schaltfläche unten, um Ihre E-Mail-Adresse zu bestätigen.',
        'trouble' => 'Wenn Sie Probleme beim Klicken auf die Schaltfläche „E-Mail-Adresse bestätigen“ haben, kopieren Sie die folgende URL und fügen Sie sie in Ihren Webbrowser ein',
    ],
    'holiday' => [
        'holiday' => 'Feiertag',
        'add_holiday' => 'Feiertag hinzufügen',
        'doctor_holiday' => 'Arztferien',
        'service_category' => 'Dienstleistungskategorie',
        'holiday_date' => 'Feiertagsdatum',
        'reason' => 'Grund',
        'holiday_already_is_exist' => 'Feiertag existiert bereits.',
        'doctor_holiday_create' => 'Arztferien erfolgreich gespeichert.',
        'you_are_not_allow_to_record' => 'Sie haben anscheinend keinen Zugriff auf diesen Datensatz.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'Pausen',
        'lunch_break' => 'Pause',
        'break_create' => 'Pause erfolgreich gespeichert.',
        'break_update' => 'Pause erfolgreich aktualisiert.',
        'add_break' => 'Pause hinzufügen',
        'edit_break' => 'Pause bearbeiten',
        'break_already_is_exist' => 'Pause existiert bereits.',
        'break_time_greater_than_zero' => 'Die Pausenzeit muss größer als Null sein.',
        'break_to_time_greater_than_zero' => 'Die Pause bis-Zeit muss größer als Null sein.',
        'break_to_time_greater_than_from_time' => 'Die Pause bis-Zeit muss größer sein als die Pause von-Zeit.',
        'every_day' => 'Täglich',
        'single_day' => 'Ein Tag',
        'date_required' => 'Das Datumsfeld ist erforderlich',
        'ipd_timeline' => 'IPD-Zeitleiste',
        'every_day' => 'Täglich',
        'single_day' => 'Ein Tag',
        'date_required' => 'Das Datumsfeld ist erforderlich.',

        'professional_details' => 'Professionelle Details',
        'get_direction' => 'Holen Sie sich die Richtung',
        'filters' => 'Filter',
        'smart_card_template_saved' => 'Smart-Patientenkarten-Vorlage erfolgreich gespeichert.',
        'smart_card_template_update' => 'Die Smart-Patientenkarten-Vorlage wurde erfolgreich aktualisiert.',
        'smart_card_saved' => 'Smart-Patientenkarte erfolgreich gespeichert.',
        'smart_patient_card_template' => 'Vorlagen für intelligente Patientenkarten',
        'new_smart_patient_card_template' => 'Neue Vorlage für eine intelligente Patientenkarte',
        'edit_smart_patient_card_template' => 'Bearbeiten Sie die Smart-Patientenkarten-Vorlage',
        'template_name' => 'Vorlagenname',
        'header_color' => 'Kopfzeilenfarbe',
        'show_email' => 'E-Mail anzeigen',
        'show_phone' => 'Telefon anzeigen',
        'show_dob' => 'Geburtsdatum anzeigen',
        'show_blood_group' => 'Blutgruppe anzeigen',
        'show_address' => 'Adresse anzeigen',
        'show_patient_unique_id' => 'Eindeutige Patienten-ID anzeigen',
        'id' => 'AUSWEIS',
        'generate_smart_patient_card' => 'Generieren Sie eine intelligente Patientenkarte',
        'for_all_patient' => 'Für alle Patienten',
        'only_one_patient' => 'Nur ein Patient',
        'remaining_patient' => 'Bleibender Patient',
        'generate_smart_patient_cards' => 'Generieren Sie intelligente Patientenkarten',
        'card_template' => 'Vorlage für eine intelligente Patientenkarte',
        'smart_patient_card' => 'Intelligente Patientenkarte',
        'template_required' => 'Das Feld „Vorlagenname“ ist erforderlich.',
        'patient_required' => 'Patientenfeld ist erforderlich.',
        'qr_code_not_found' => 'QR-Code nicht gefunden.',
        'dob' => 'Geburtsdatum',
        'appointment_exist_time' => 'Der Termin ist zu diesem Zeitpunkt bereits vorhanden.',
        'appointment_exist_date' => 'Der Termin ist zu diesem Datum bereits vorhanden.',
        'patient_unique_id' => 'Eindeutige Patienten-ID',
        'patient_smart_cards' => 'Patienten-Smartcards',
        'select_template' => 'Vorlage auswählen',
        'print_discharge_slip' => 'Entlassungsschein ausdrucken',
        'discharge_slip' => 'Entladeschein',
        'bed_charge' => 'Bettgebühr',
        'reset_filter' => 'Filter zurücksetzen',
        'discharge' => 'Entladen',
        'not_dischared' => 'Nicht entlassen',
        'diagnosis_success' => 'Der Status des Diagnoseberichts wurde erfolgreich aktualisiert.',
        'case_exist' => 'Patientenfall ist bereits vorhanden.',
        'payment_request_send' => 'Zahlungsanforderung erfolgreich gesendet.',

        'todays_appointments' => 'Heutige Termine',
        'total_meetings' => 'Gesamtzahl der Besprechungen',
        'ipd_due_amount' => 'IPD-fälliger Betrag',
        'recent_appointments' => 'Aktuelle Termine',
    ],

    'custom_field' => [
        '' => 'Manuelle Anweisungen',
        'custom_field' => 'Benutzerdefiniertes Feld',
        'add_custom_field' => 'Benutzerdefiniertes Feld hinzufügen',
        'edit_custom_field' => 'Benutzerdefiniertes Feld bearbeiten',
        'module_name' => 'Modulname',
        'field_type' => 'Feldtyp',
        'field_name' => 'Feldname',
        'grid' => 'Raster',
        'value' => 'Wert',
        'seperated_by_comma' => 'Getrennt durch Komma',
        'is_reqired' => 'Ist erforderlich',
        'input' => 'Eingabe',
        'textarea' => 'Textbereich',
        'checkbox' => 'Kontrollkästchen',
        'number' => 'Nummer',
        'dropdown' => 'Runterfallen',
        'multi_select' => 'Mehrfachauswahl',
        'date' => 'Datum',
        'date_time' => 'Terminzeit',
        'appointment' => 'Termin',
        'ipd_patient' => 'IPD-Patient',
        'opd_patient' => 'OPD-Patient',
        'patient' => 'Patient',
        'value_must_be_greter_then' => 'Wert muss größer als 1 sein',
        'select_module' => 'Modul auswählen',
        'select_field_type' => 'Feldtyp auswählen',
        'toggle' => 'Umschalten',
        'text' => 'Text',
        'grid_tooltip' => '(Bootstrap-Spalte, z. B. 6) – Max. ist 12',
    ],

    'phonepe' => [
        'phonepe' => 'PhonePe',
        'phonepe_merchant_id' => 'Phonepe-Händler-ID',
        'phonepe_merchant_user_id' => 'Phonepe-Händler-Benutzer-ID',
        'phonepe_env' => 'Phonepe Env',
        'phonepe_salt_key' => 'Phonepe-Salzschlüssel',
        'phonepe_salt_index' => 'Phonepe-Salz-Index',
        'phonepe_merchant_transaction_id' => 'Phonepe-Händler-Transaktions-ID',
        'currency_allowed' => 'Nur INR-Währung zulässig',
    ],

    'flutterwave' => [
        'flutterwave' => 'FlutterWave',
        'set_flutterwave_credential' => 'Bitte legen Sie Ihre Flutterwave-Anmeldeinformationen fest.',
        'currency_allowed' => "Nur 'GBP', 'CAD', 'XAF', 'CLP', 'COP', 'EGP', 'EUR', 'GHS', 'GNF', 'KES', 'MWK', 'MAD', 'NGN', 'RWF', 'SLL', 'STD', 'ZAR', 'TZS', 'UGX', 'USD', 'XOF', 'ZMW' Währung ist zulässig.",
        'flutterwave_public_key' => 'Öffentlicher FlutterWave-Schlüssel',
        'flutterwave_secret_key' => 'FlutterWave-Geheimschlüssel',
    ],

    'google_meet' => [
        'connect_calendar' => 'Verbinden Sie Ihren Google-Kalender',
        'connect_google_meet' => 'Verbinden Sie Google Kalender',
        'disconnect_google_calendar' => 'Trennen Sie Ihren Google-Kalender',
        'sync_google_calendar' => 'Synchronisieren Sie Ihren Google-Kalender',
        'validate_json_file' => 'Bitte legen Sie die JSON-Datei mit Ihren Google-Kalender-Anmeldeinformationen fest',
        'google_calendar_connect' => 'Google Kalender erfolgreich verbunden',
        'google_calendar_add' => 'Kalender erfolgreich hinzugefügt',
        'google_calendar_update' => 'Google-Kalender erfolgreich aktualisiert.',
        'disconnect_or_reconnect' => 'Bitte trennen Sie die Verbindung zu Ihrem Google-Kalender und verbinden Sie ihn erneut',
        'google_calendar_disconnect' => 'Verbindung zum Google-Kalender getrennt',
        'select_google_calendar' => 'Wählen Sie Ihre Kalender (aus Google Kalender) aus, in denen Sie die Ereignisse erstellen möchten',
        'platform_type' => 'Plattformtyp',
        'opd_prescription' => 'OPD-Rezept',
        'google_json_file' => 'Google JSON-Datei',
        'upload_json_file' => 'Bitte laden Sie die JSON-Datei mit Ihren Google-Kalender-Anmeldeinformationen hoch.',
        'upload_file' => 'Bitte laden Sie eine JSON-Datei hoch.',
        'invalid_json_format' => 'Ungültiges Eingabeformat. Bitte laden Sie eine Datei im JSON-Format hoch.',
        'json_file_saved_successfully' => 'Google Kalender-JSON-Datei erfolgreich gespeichert.',
        'upload_again_json_file' => 'Die Google JSON-Datei existiert nicht. Bitte laden Sie die JSON-Datei erneut hoch.',
    ],

    'schedule_weekday' => [
        'Monday' => 'Montag',
        'Tuesday' => 'Dienstag',
        'Wednesday' => 'Mittwoch',
        'Thursday' => 'Donnerstag',
        'Friday' => 'Freitag',
        'Saturday' => 'Samstag',
        'Sunday' => 'Sonntag',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'MO',
        'TUE' => 'DI',
        'WED' => 'HEIRATEN',
        'THU' => 'DO',
        'FRI' => 'FR',
        'SAT' => 'SA',
        'SUN' => 'SONNE',
    ],

    'open_ai' => [
        'open_ai' => 'Openai',
        'provide_prompt' => 'Bitte geben Sie umgehend physische Informationen an.',
        'open_ai_key_not_found' => 'OpenAI-API-Schlüssel nicht gefunden.',
        'repsonse_retrive_successfully' => 'Antwort erfolgreich abgerufen.',
        'open_ai_key' => 'Öffnen Sie den AI-Schlüssel',
        'suggest_medicines' => 'Schlagen Sie Medikamente vor',
        'suggested_medicines' => 'Empfohlene Medikamente',
    ],

    'fields' => [
        'the' => 'Der',
        'required' => 'Feld ist erforderlich.',
        'unique' => 'Die E-Mail wurde bereits vergeben.',
        'min_char' => 'Das Passwort muss mindestens 8 Zeichen lang sein.',
        'confirm' => 'Die Bestätigung des Passworts stimmt nicht überein.',
    ],
];
