<?php

namespace App\Filament\HospitalAdmin\Clusters\Users\Resources\ReceptionistResource\Pages;

use Filament\Actions\Action;
use Illuminate\Database\Eloquent\Model;
use Filament\Resources\Pages\CreateRecord;
use App\Repositories\ReceptionistRepository;
use App\Filament\HospitalAdmin\Clusters\Users\Resources\ReceptionistResource;

class CreateReceptionist extends CreateRecord
{
    protected static string $resource = ReceptionistResource::class;
    protected static bool $canCreateAnother = false;
    protected function getActions(): array
    {
        return [
            Action::make('back')
                ->label(__('messages.common.back'))
                ->url(static::getResource()::getUrl('index')),
        ];
    }
    public function handleRecordCreation(array $input): Model
    {
        $input['status'] = $input['status'] ? 1 : 0;
        $nurse = app(ReceptionistRepository::class)->store($input);
        return $nurse;
    }
    protected function getRedirectUrl(): string
    {
        return static::getResource()::getUrl('index');
    }
    protected function getCreatedNotificationTitle(): ?string
    {
        return __('messages.flash.receptionist_saved');
    }
}
