<?php

namespace App\Filament\HospitalAdmin\Clusters\Patients\Resources\PatientAdmissionResource\Pages;

use Filament\Actions;
use Filament\Actions\Action;
use Filament\Resources\Pages\EditRecord;
use App\Filament\HospitalAdmin\Clusters\Patients\Resources\PatientAdmissionResource;

class EditPatientAdmission extends EditRecord
{
    protected static string $resource = PatientAdmissionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('back')
                ->label(__('messages.common.back'))
                ->url(static::getResource()::getUrl('index')),
        ];
    }
    protected function getSavedNotificationTitle(): ?string
    {
        return __('messages.flash.patient_admission_updated');
    }

    protected function getRedirectUrl(): string
    {
        return static::getResource()::getUrl('index');
    }
}
