<?php

namespace App\Filament\HospitalAdmin\Clusters\Doctors\Resources\DoctorResource\Pages;


use App\Models\User;
use App\Models\Doctor;
use App\Models\Address;
use App\Models\Notification;
use Filament\Actions\Action;
use App\Repositories\DoctorRepository;
use Illuminate\Database\Eloquent\Model;
use Filament\Resources\Pages\EditRecord;
use App\Filament\HospitalAdmin\Clusters\Doctors\Resources\DoctorResource;

class EditDoctor extends EditRecord
{
    protected static string $resource = DoctorResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('back')
                ->label(__('messages.common.back'))
                ->url(static::getResource()::getUrl('index')),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        if (!canAccessRecord(Doctor::class, $data['id'])) {
            Notification::make()
                ->danger()
                ->title(__('messages.flash.access_denied'))
                ->body(__('messages.flash.not_allow_access_record'))
                ->send();
            return $data;
        }
        $user = User::find($data['user_id']);
        $data['first_name'] = $user->first_name;
        $data['last_name'] = $user->last_name;
        $data['email'] = $user->email;
        $data['phone'] = $user->phone;
        $data['gender'] = $user->gender;
        $data['dob'] = $user->dob;
        $data['status'] = $user->status;
        $data['blood_group'] = $user->blood_group;
        $data['qualification'] = $user->qualification;
        $data['designation'] = $user->designation;
        $data['linkedIn_url'] = $user->linkedIn_url;
        $data['facebook_url'] = $user->facebook_url;
        $data['twitter_url'] = $user->twitter_url;
        $data['instagram_url'] = $user->instagram_url;
        $ownerId = Doctor::where('user_id', $data['user_id'])->first()->id;
        $address = Address::where('owner_id', $ownerId)->where('owner_type', Doctor::class)->first();
        if (!$address) {
            return $data;
        } else {
            $data['address1'] = $address->address1;
            $data['address2'] = $address->address2;
            $data['city'] = $address->city;
            $data['zip'] = $address->zip;
            return $data;
        }
    }
    protected function handleRecordUpdate(Model $record, array $data): Model
    {
        $doctor = app(DoctorRepository::class)->update($record, $data);
        return $doctor;
    }
    protected function getSavedNotificationTitle(): ?string
    {
        return __('messages.flash.doctor_update');
    }

    protected function getRedirectUrl(): string
    {
        return static::getResource()::getUrl('index');
    }
}
