<?php

namespace App\Livewire;

use App\Filament\HospitalAdmin\Clusters\Doctors\Resources\DoctorResource;
use App\Filament\HospitalAdmin\Clusters\Patients\Resources\PatientResource;
use App\Models\User;
use App\Models\Doctor;
use Livewire\Component;
use Filament\Tables\Table;
use PhpParser\Comment\Doc;
use App\Models\Appointment;
use App\Models\PatientCase;
use Illuminate\Support\Facades\Route;
use Filament\Forms\Contracts\HasForms;
use Filament\Support\Enums\FontWeight;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Contracts\HasTable;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Columns\SpatieMediaLibraryImageColumn;

class DoctorAppointmentRelationTable extends Component implements HasTable, HasForms
{

    use InteractsWithForms;
    use InteractsWithTable;

    public $record;
    public function GetRecord()
    {
        $id = Route::current()->parameter('record');

        $appointments = Doctor::with('appointments')->where('id', $id)->get();

        foreach ($appointments as $item) {
            $this->record = $item->cases;
        }

        $appointment_ids = $this->record->pluck('doctor_id')->toArray();

        $data = Appointment::with('doctor.doctorUser')->whereIn('doctor_id', $appointment_ids)->orderByDesc('id');
        // dd($data);
        return $data;
    }

    public function table(Table $table): Table
    {
        return $table
            ->query(Self::GetRecord())
            ->columns([
                SpatieMediaLibraryImageColumn::make('patient.patientUser.profile')
                    ->label(__('messages.case.patient'))
                    ->circular()
                    ->defaultImageUrl(function ($record) {
                        if (!$record->patient->patientUser->hasMedia(User::COLLECTION_PROFILE_PICTURES)) {
                            return getUserImageInitial($record->id, $record->patient->patientUser->first_name);
                        }
                    })
                    ->url(fn($record) => PatientResource::getUrl('view', ['record' => $record->patient->id]))
                    ->collection('profile')
                    ->width(50)->height(50),
                TextColumn::make('patient.patientUser.full_name')
                    ->label('')
                    ->formatStateUsing(fn($record) => '<a href="' . PatientResource::getUrl('view', ['record' => $record->patient->id]) . '" class="hoverLink">' . $record->patient->patientUser->full_name . '</a>')
                    ->html()
                    ->color('primary')
                    ->weight(FontWeight::SemiBold)
                    ->description(fn($record) => $record->patient->patientUser->email ?? __('messages.common.n/a'))
                    ->searchable(['first_name', 'last_name']),
                SpatieMediaLibraryImageColumn::make('doctor.doctorUser.profile')
                    ->label(__('messages.role.doctor'))
                    ->circular()
                    ->defaultImageUrl(function ($record) {
                        if (!$record->doctor->user->hasMedia(User::COLLECTION_PROFILE_PICTURES)) {
                            return getUserImageInitial($record->id, $record->doctor->user->full_name);
                        }
                    })
                    ->url(fn($record) => DoctorResource::getUrl('view', ['record' => $record->doctor->id]))
                    ->collection('profile')
                    ->width(50)->height(50),
                TextColumn::make('doctor.doctorUser.full_name')
                    ->label('')
                    ->color('primary')
                    ->weight(FontWeight::SemiBold)
                    ->description(fn($record) => $record->doctor->doctorUser->email ?? __('messages.common.n/a'))
                    ->formatStateUsing(fn($record) => '<a href="' . DoctorResource::getUrl('view', ['record' => $record->doctor->id]) . '" class="hoverLink">' . $record->doctor->doctorUser->full_name . '</a>')
                    ->html()
                    ->searchable(['first_name', 'last_name']),
                TextColumn::make('doctor.department.title')
                    ->label(__('messages.appointment.department_name')),
                TextColumn::make('opd_date')
                    ->label(__('messages.appointment.opd_date'))
                    ->searchable()
                    ->getStateUsing(function ($record) {
                        $date =  \Carbon\Carbon::parse($record->opd_date)->translatedFormat('jS M, Y');
                        $time = \Carbon\Carbon::parse($record->opd_date)->translatedFormat('g:i A');

                        return "<div class='text-center'><span>{$time}</span><br><span class='text-sm'>{$date}</span></div>";
                    })
                    ->html()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ])
            ->emptyStateHeading(__('messages.common.no_data_found'));
    }

    public function render()
    {
        return view('livewire.doctor-appointment-relation-table');
    }
}
