<?php

namespace App\Filament\HospitalAdmin\Clusters\Patients\Resources\CaseHandlerResource\Pages;

use Filament\Actions;
use Filament\Actions\Action;
use Illuminate\Database\Eloquent\Model;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use App\Repositories\CaseHandlerRepository;
use App\Filament\HospitalAdmin\Clusters\Patients\Resources\CaseHandlerResource;

class CreateCaseHandler extends CreateRecord
{
    protected static string $resource = CaseHandlerResource::class;

    protected static bool $canCreateAnother = false;

    protected function getActions(): array
    {
        return [
            Action::make('back')
                ->label(__('messages.common.back'))
                ->url(static::getResource()::getUrl('index')),
        ];
    }

    protected function handleRecordCreation(array $input): Model
    {
        // $input['status'] = ! isset($input['status']) ? 0 : 1;
        // $input['region_code'] = regionCode($input['prefix_code']);
        // dd($input);
        $record =  app(CaseHandlerRepository::class)->store($input);

        // $record = new ($this->getModel())($input);

        return $record;
    }

    protected function getRedirectUrl(): string
    {
        return static::getResource()::getUrl('index');
    }
    protected function getCreatedNotificationTitle(): ?string
    {
        return __('messages.flash.case_saved');
    }
}
